/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.util;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.MapPolygonWithHoles;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3545;

public class PolygonHelper {
    public static MapPolygon createChunkPolygonForWorldCoords(int x, int y, int z) {
        return PolygonHelper.createChunkPolygon(x >> 4, y, z >> 4);
    }

    public static MapPolygon createChunkPolygon(int chunkX, int y, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        class_2338 sw = new class_2338(x, y, z + 16);
        class_2338 se = new class_2338(x + 16, y, z + 16);
        class_2338 ne = new class_2338(x + 16, y, z);
        class_2338 nw = new class_2338(x, y, z);
        return new MapPolygon(sw, se, ne, nw);
    }

    public static MapPolygon createBlockRect(class_2338 corner1, class_2338 corner2) {
        int minX = Math.min(corner1.method_10263(), corner2.method_10263());
        int maxX = Math.max(corner1.method_10263(), corner2.method_10263());
        int minZ = Math.min(corner1.method_10260(), corner2.method_10260());
        int maxZ = Math.max(corner1.method_10260(), corner2.method_10260());
        class_2338 sw = new class_2338(minX, corner1.method_10264(), maxZ);
        class_2338 se = new class_2338(maxX, corner1.method_10264(), maxZ);
        class_2338 ne = new class_2338(maxX, corner2.method_10264(), minZ);
        class_2338 nw = new class_2338(minX, corner2.method_10264(), minZ);
        return new MapPolygon(sw, se, ne, nw);
    }

    @Nonnull
    public static Area createChunksArea(@Nonnull Collection<class_1923> chunks) {
        Area area = new Area();
        for (class_1923 chunkPos : chunks) {
            area.add(new Area(new Rectangle(chunkPos.method_8326(), chunkPos.method_8328(), 16, 16)));
        }
        return area;
    }

    @Nonnull
    public static List<MapPolygonWithHoles> createChunksPolygon(@Nonnull Collection<class_1923> chunks, int y) {
        return PolygonHelper.createPolygonFromArea(PolygonHelper.createChunksArea(chunks), y);
    }

    @Nonnull
    public static Area toArea(@Nonnull MapPolygon polygon) {
        List<class_2338> points = polygon.getPoints();
        int[] xPoints = new int[points.size()];
        int[] yPoints = new int[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            xPoints[i] = points.get(i).method_10263();
            yPoints[i] = points.get(i).method_10260();
        }
        return new Area(new Polygon(xPoints, yPoints, points.size()));
    }

    @Nonnull
    public static List<MapPolygonWithHoles> createPolygonFromArea(@Nonnull Area area, int y) {
        ArrayList<MapPolygon> polygons = new ArrayList<MapPolygon>();
        List<Object> poly = new ArrayList<class_2338>();
        PathIterator iterator = area.getPathIterator(null);
        float[] points = new float[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(points);
            switch (type) {
                case 0: {
                    if (!poly.isEmpty()) {
                        poly = PolygonHelper.simplify(poly);
                        polygons.add(new MapPolygon(poly));
                        poly = new ArrayList();
                    }
                    poly.add(new class_2338(Math.round(points[0]), y, Math.round(points[1])));
                    break;
                }
                case 1: {
                    poly.add(new class_2338(Math.round(points[0]), y, Math.round(points[1])));
                }
            }
            iterator.next();
        }
        if (!poly.isEmpty()) {
            polygons.add(new MapPolygon(poly));
        }
        return PolygonHelper.classifyAndGroup(polygons);
    }

    @Nonnull
    public static List<MapPolygonWithHoles> classifyAndGroup(@Nonnull List<MapPolygon> polygons) {
        ArrayList<MapPolygon> hulls = new ArrayList<MapPolygon>();
        ArrayList<MapPolygon> holes = new ArrayList<MapPolygon>();
        for (MapPolygon polygon : polygons) {
            if (PolygonHelper.isHole(polygon)) {
                holes.add(polygon);
                continue;
            }
            hulls.add(polygon);
        }
        List holeAreas = holes.stream().map(hole -> new class_3545(hole, (Object)PolygonHelper.toArea(hole))).collect(Collectors.toList());
        ArrayList<MapPolygonWithHoles> result = new ArrayList<MapPolygonWithHoles>();
        for (MapPolygon hull : hulls) {
            Area hullArea = PolygonHelper.toArea(hull);
            ArrayList<MapPolygon> hullHoles = new ArrayList<MapPolygon>();
            Iterator iterator = holeAreas.iterator();
            while (iterator.hasNext()) {
                class_3545 holeArea = (class_3545)iterator.next();
                Area intersection = new Area(hullArea);
                intersection.intersect((Area)holeArea.method_15441());
                if (intersection.isEmpty()) continue;
                hullHoles.add((MapPolygon)holeArea.method_15442());
                iterator.remove();
            }
            result.add(new MapPolygonWithHoles(hull, hullHoles));
        }
        return result;
    }

    @Nonnull
    private static List<class_2338> simplify(@Nonnull List<class_2338> points) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        class_2338 prev2 = points.get(0);
        class_2338 prev1 = points.get(1);
        result.add(prev2);
        for (int index = 2; index < points.size(); ++index) {
            class_2338 next = points.get(index);
            if (prev2.method_10263() == prev1.method_10263() && prev1.method_10263() == next.method_10263()) {
                prev1 = next;
                continue;
            }
            if (prev2.method_10260() == prev1.method_10260() && prev1.method_10260() == next.method_10260()) {
                prev1 = next;
                continue;
            }
            result.add(prev1);
            prev2 = prev1;
            prev1 = next;
        }
        result.add(prev1);
        return result;
    }

    private static boolean isHole(@Nonnull MapPolygon polygon) {
        long sum = 0L;
        List<class_2338> points = polygon.getPoints();
        class_2338 a = points.get(points.size() - 1);
        for (class_2338 b : points) {
            sum += (long)(b.method_10263() - a.method_10263()) * (long)(b.method_10260() + a.method_10260());
            a = b;
        }
        return sum < 0L;
    }
}

