/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.event;

import java.awt.geom.Point2D;
import journeymap.api.v2.client.fullscreen.IBlockInfo;
import journeymap.api.v2.common.event.impl.ClientEvent;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class FullscreenMapEvent
extends ClientEvent {
    private final class_2338 location;

    private FullscreenMapEvent(boolean cancellable, class_2338 location, class_5321<class_1937> level) {
        super(cancellable, level);
        this.location = location;
    }

    public class_2338 getLocation() {
        return this.location;
    }

    public class_5321<class_1937> getLevel() {
        return this.dimension;
    }

    public static enum Stage {
        PRE,
        POST;

    }

    public static class MouseMoveEvent
    extends FullscreenMapEvent {
        private final Point2D.Double mousePosition;
        private final IBlockInfo info;

        public MouseMoveEvent(class_5321<class_1937> level, IBlockInfo info, Point2D.Double mousePosition) {
            super(false, info.getBlockPos(), level);
            this.mousePosition = mousePosition;
            this.info = info;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public IBlockInfo getInfo() {
            return this.info;
        }
    }

    public static class MouseDraggedEvent
    extends FullscreenMapEvent {
        private final int button;
        private final Point2D.Double mousePosition;
        private final Stage stage;

        public MouseDraggedEvent(Stage stage, class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
            super(true, location, level);
            this.stage = stage;
            this.mousePosition = mousePosition;
            this.button = button;
        }

        public Stage getStage() {
            return this.stage;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public int getButton() {
            return this.button;
        }

        @Override
        public boolean isCancellable() {
            return this.stage == Stage.PRE;
        }
    }

    public static class ClickEvent
    extends FullscreenMapEvent {
        private final int button;
        private final Point2D.Double mousePosition;
        private final Stage stage;

        public ClickEvent(Stage stage, class_2338 location, class_5321<class_1937> level, Point2D.Double mousePosition, int button) {
            super(true, location, level);
            this.stage = stage;
            this.mousePosition = mousePosition;
            this.button = button;
        }

        public Stage getStage() {
            return this.stage;
        }

        public double getMouseX() {
            return this.mousePosition.x;
        }

        public double getMouseY() {
            return this.mousePosition.y;
        }

        public Point2D.Double getMousePosition() {
            return this.mousePosition;
        }

        public int getButton() {
            return this.button;
        }

        @Override
        public boolean isCancellable() {
            return this.stage == Stage.PRE;
        }
    }
}

