/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.v2.client.ui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class LayeredScreen
extends Screen {
    protected Minecraft minecraft = Minecraft.getInstance();
    protected Screen backgroundScreen;

    protected LayeredScreen(Component component) {
        super(component);
    }

    public void display() {
        if (this.minecraft.screen != null) {
            this.backgroundScreen = this.minecraft.screen;
            this.minecraft.screen = this;
            this.added();
            super.init(this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.minecraft.getNarrator().saySystemNow(this.getNarrationMessage());
        } else {
            this.minecraft.setScreen((Screen)this);
        }
    }

    @Deprecated(forRemoval=true)
    public void resize(Minecraft minecraft, int width, int height) {
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        if (this.backgroundScreen != null) {
            this.backgroundScreen.resize(this.width, this.height);
        }
    }

    @Deprecated
    public final void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backgroundScreen != null) {
            this.backgroundScreen.renderWithTooltipAndSubtitles(graphics, -1, -1, partialTicks);
        }
        graphics.nextStratum();
        this.renderPopupScreenBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.nextStratum();
        this.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public final void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void onClose() {
        this.popLayer();
    }

    public void popLayer() {
        if (this.minecraft.screen != null) {
            this.minecraft.screen.removed();
        }
        if (this.backgroundScreen != null) {
            this.minecraft.screen = this.backgroundScreen;
        } else {
            this.minecraft.setScreen(null);
        }
    }

    public Screen getBackgroundScreen() {
        return this.backgroundScreen;
    }
}

