/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug.core.api;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.Iota;
import gay.object.hexdebug.core.api.debugging.DebugOutputCategory;
import gay.object.hexdebug.core.api.debugging.env.DebugEnvironment;
import gay.object.hexdebug.core.api.exceptions.IllegalDebugSessionException;
import gay.object.hexdebug.core.api.exceptions.IllegalDebugThreadException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HexDebugCoreAPI {
    public static final HexDebugCoreAPI INSTANCE = HexDebugCoreAPI.findInstance();

    @Contract(pure=true)
    @Nullable
    default public DebugEnvironment getDebugEnv(@NotNull CastingEnvironment env) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public DebugEnvironment getDebugEnv(@NotNull ServerPlayer caster, @NotNull UUID sessionId) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public DebugEnvironment getDebugEnv(@NotNull ServerPlayer caster, int threadId) {
        return null;
    }

    default public void createDebugThread(@NotNull DebugEnvironment debugEnv, @Nullable Integer threadId) throws IllegalDebugSessionException, IllegalDebugThreadException {
        throw new IllegalDebugThreadException();
    }

    default public void startDebuggingIotas(@NotNull DebugEnvironment debugEnv, @NotNull CastingEnvironment env, @NotNull List<Iota> iotas, @Nullable CastingImage image) throws IllegalDebugSessionException {
        throw new IllegalDebugSessionException();
    }

    default public void removeDebugThread(@NotNull DebugEnvironment debugEnv) {
    }

    default public void terminateDebugThread(@NotNull DebugEnvironment debugEnv) {
    }

    default public void printDebugMessage(@NotNull ServerPlayer caster, @NotNull UUID sessionId, @NotNull Component message, @NotNull DebugOutputCategory category, boolean withSource) {
    }

    @Contract(pure=true)
    default public boolean isSessionDebugging(@NotNull DebugEnvironment debugEnv) {
        return this.getDebugEnv(debugEnv.getCaster(), debugEnv.getSessionId()) != null;
    }

    private static HexDebugCoreAPI findInstance() {
        List<ServiceLoader.Provider<HexDebugCoreAPI>> providers = ServiceLoader.load(HexDebugCoreAPI.class).stream().toList();
        if (providers.size() > 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("Expected at most one HexDebugCoreAPI implementation on the classpath. Found: " + names);
        }
        if (providers.size() == 1) {
            return providers.get(0).get();
        }
        return new HexDebugCoreAPI(){};
    }
}

