package gay.object.hexdebug.api.client.splicing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import net.minecraft.class_7919;

public final class SplicingTableIotaTooltipBuilder {
    private final class_2561 name;
    private final ArrayList<class_2561> body;
    private final ArrayList<class_2561> details;
    private final ArrayList<class_2561> advanced;
    @Nullable
    private class_2561 narration;

    public SplicingTableIotaTooltipBuilder(@NotNull class_2561 name) {
        this.name = name;
        body = new ArrayList<>();
        details = new ArrayList<>();
        advanced = new ArrayList<>();
    }

    @NotNull
    public class_2561 getName() {
        return name;
    }

    @NotNull
    public ArrayList<class_2561> getBodyLines() {
        return body;
    }

    @NotNull
    public ArrayList<class_2561> getDetailsLines() {
        return details;
    }

    @NotNull
    public ArrayList<class_2561> getAdvancedLines() {
        return advanced;
    }

    @Nullable
    public class_2561 getNarration() {
        return narration;
    }

    /** Append a line to the tooltip's body. */
    @NotNull
    public SplicingTableIotaTooltipBuilder addBodyLine(@NotNull class_2561 line) {
        body.add(line);
        return this;
    }

    /** Append a line to the tooltip's details. */
    @NotNull
    public SplicingTableIotaTooltipBuilder addDetailsLine(@NotNull class_2561 line) {
        details.add(line);
        return this;
    }

    /** Append a line to the tooltip's "advanced tooltips" section. */
    @NotNull
    public SplicingTableIotaTooltipBuilder addAdvancedLine(@NotNull class_2561 line) {
        advanced.add(line);
        return this;
    }

    /** Set the tooltip's narration. */
    @NotNull
    public SplicingTableIotaTooltipBuilder setNarration(@Nullable class_2561 narration) {
        this.narration = narration;
        return this;
    }

    @NotNull
    public class_7919 build() {
        var lines = new ArrayList<class_2561>();
        lines.add(name);
        lines.addAll(body);
        for (var line : details) {
            lines.add(line.method_27661().method_27692(class_124.field_1080));
        }
        if (class_310.method_1551().field_1690.field_1827) {
            for (var line : advanced) {
                lines.add(line.method_27661().method_27692(class_124.field_1063));
            }
        }

        var tooltipText = class_2564.method_37112(lines, class_2561.method_43470("\n"));
        if (narration != null) {
            return class_7919.method_47408(tooltipText, narration);
        }
        return class_7919.method_47407(tooltipText);
    }
}
