package gay.object.hexdebug.api.client.splicing;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import gay.object.hexdebug.api.splicing.SplicingTableIotaClientView;
import gay.object.hexdebug.config.HexDebugClientConfig;
import gay.object.hexdebug.gui.splicing.SplicingTableScreen;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7919;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplicingTableIotaRenderer {
    @NotNull
    private final IotaType<?> type;
    @NotNull
    private final SplicingTableIotaClientView iota;
    private int x;
    private int y;

    @Nullable
    private class_7919 tooltip;

    public SplicingTableIotaRenderer(
        @NotNull IotaType<?> type,
        @NotNull SplicingTableIotaClientView iota,
        int x,
        int y
    ) {
        this.type = type;
        this.iota = iota;
        this.x = x;
        this.y = y;
    }

    @NotNull
    public final IotaType<?> getType() {
        return type;
    }

    @NotNull
    public final SplicingTableIotaClientView getIota() {
        return iota;
    }

    public final int getX() {
        return x;
    }

    @ApiStatus.OverrideOnly
    public void setX(int x) {
        this.x = x;
    }

    public final int getY() {
        return y;
    }

    @ApiStatus.OverrideOnly
    public void setY(int y) {
        this.y = y;
    }

    /**
     * Returns the current tooltip for this renderer. This is called every frame, immediately after
     * {@link SplicingTableIotaRenderer#render}.
     */
    @Nullable
    public class_7919 getTooltip() {
        return tooltip;
    }

    /**
     * Sets the cached tooltip for this renderer. By default, this is called only when the renderer
     * is moved to a new position, receiving the value returned by
     * {@link SplicingTableIotaRenderer#createTooltip}.
     */
    public void setTooltip(@Nullable class_7919 tooltip) {
        this.tooltip = tooltip;
    }

    /** Renders one frame of this iota. */
    public abstract void render(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick);

    /** Returns the background type for this renderer. */
    @NotNull
    public SplicingTableIotaBackgroundType getBackgroundType() {
        return SplicingTableIotaBackgroundType.GOLD;
    }

    /**
     * Creates and returns a new {@link class_7919} for the provided iota. By default, this is called
     * only when the renderer is moved to a new position.
     * <br>
     * In most cases, you'll likely want to override
     * {@link SplicingTableIotaRenderer#buildTooltip} instead.
     */
    @NotNull
    public class_7919 createTooltip() {
        return buildTooltip().build();
    }

    /**
     * Creates and returns a new {@link SplicingTableIotaTooltipBuilder} for the provided iota.
     * <br>
     * If you want to provide a tooltip directly instead of using this builder, you can override
     * {@link SplicingTableIotaRenderer#createTooltip} instead.
     */
    @NotNull
    protected SplicingTableIotaTooltipBuilder buildTooltip() {
        class_2561 name;
        if (
            type == HexIotaTypes.PATTERN
            || HexDebugClientConfig.getConfig().getSplicingTable().getShowNestedPatternNames()
        ) {
            name = iota.display();
        } else {
            name = type.display(iota.getData());
        }

        var builder = new SplicingTableIotaTooltipBuilder(name)
            .addDetailsLine(SplicingTableScreen.tooltipText("index", iota.index()));

        var typeKey = HexIotaTypes.REGISTRY.method_10221(type);
        if (typeKey != null) {
            builder.addAdvancedLine(class_2561.method_43470(typeKey.toString()));
        }

        return builder.addAdvancedLine(SplicingTableScreen.tooltipText("depth", iota.depth()));
    }
}
