package gay.object.hexdebug.mixin;

import at.petrak.hexcasting.common.msgs.MsgShiftScrollC2S;
import gay.object.hexdebug.items.DebuggerItem;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// server side
@Mixin(MsgShiftScrollC2S.class)
public class MixinMsgShiftScrollC2S {
    @Inject(method = "handleForHand", at = @At("HEAD"))
    private void hexdebug$handleForHand(class_3222 sender, class_1268 hand, double delta, CallbackInfo ci) {
        if (delta != 0) {
            var stack = sender.method_5998(hand);
            var item = stack.method_7909();
            if (item instanceof DebuggerItem debugger) {
                debugger.handleShiftScroll(sender, stack, delta);
            }
        }
    }
}
