/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug.items;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTHelper;
import gay.object.hexdebug.HexDebug;
import gay.object.hexdebug.blocks.focusholder.FocusHolderBlockEntity;
import gay.object.hexdebug.items.FocusHolderBlockItem;
import gay.object.hexdebug.items.base.ItemPredicateProvider;
import gay.object.hexdebug.items.base.ModelPredicateEntry;
import gay.object.hexdebug.registry.HexDebugBlockEntities;
import gay.object.hexdebug.utils.ExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u0003:\u00013B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ7\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ?\u0010(\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J/\u0010*\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b-\u0010.J!\u0010/\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b1\u00102\u00a8\u00064"}, d2={"Lgay/object/hexdebug/items/FocusHolderBlockItem;", "Lnet/minecraft/world/item/BlockItem;", "Lat/petrak/hexcasting/api/item/IotaHolderItem;", "Lgay/object/hexdebug/items/base/ItemPredicateProvider;", "Lnet/minecraft/world/level/block/Block;", "block", "Lnet/minecraft/world/item/Item$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "level", "", "Lnet/minecraft/network/chat/Component;", "tooltipComponents", "Lnet/minecraft/world/item/TooltipFlag;", "isAdvanced", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "iota", "", "canWrite", "(Lnet/minecraft/world/item/ItemStack;Lat/petrak/hexcasting/api/casting/iota/Iota;)Z", "", "Lgay/object/hexdebug/items/base/ModelPredicateEntry;", "getModelPredicates", "()Ljava/util/List;", "other", "Lnet/minecraft/world/inventory/Slot;", "slot", "Lnet/minecraft/world/inventory/ClickAction;", "action", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/SlotAccess;", "access", "overrideOtherStackedOnMe", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/SlotAccess;)Z", "overrideStackedOnOther", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/nbt/CompoundTag;", "readIotaTag", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/nbt/CompoundTag;", "writeDatum", "(Lnet/minecraft/world/item/ItemStack;Lat/petrak/hexcasting/api/casting/iota/Iota;)V", "writeable", "(Lnet/minecraft/world/item/ItemStack;)Z", "Companion", "hexdebug-common"})
public final class FocusHolderBlockItem
extends BlockItem
implements IotaHolderItem,
ItemPredicateProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation HAS_ITEM = HexDebug.id("has_item");

    public FocusHolderBlockItem(@NotNull Block block, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(block, properties);
    }

    @Nullable
    public CompoundTag readIotaTag(@NotNull ItemStack stack) {
        IotaHolderItem iotaHolder;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Pair<ItemStack, IotaHolderItem> pair = Companion.getIotaStack(stack);
        ItemStack iotaStack = (ItemStack)pair.component1();
        IotaHolderItem iotaHolderItem = iotaHolder = (IotaHolderItem)pair.component2();
        return iotaHolderItem != null ? iotaHolderItem.readIotaTag(iotaStack) : null;
    }

    public boolean writeable(@NotNull ItemStack stack) {
        IotaHolderItem iotaHolder;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IotaHolderItem iotaHolderItem = iotaHolder = (IotaHolderItem)Companion.getIotaStack(stack).component2();
        return iotaHolderItem != null ? iotaHolderItem.writeable(stack) : false;
    }

    public boolean canWrite(@NotNull ItemStack stack, @Nullable Iota iota) {
        IotaHolderItem iotaHolder;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Pair<ItemStack, IotaHolderItem> pair = Companion.getIotaStack(stack);
        ItemStack iotaStack = (ItemStack)pair.component1();
        IotaHolderItem iotaHolderItem = iotaHolder = (IotaHolderItem)pair.component2();
        return iotaHolderItem != null ? iotaHolderItem.canWrite(iotaStack, iota) : false;
    }

    public void writeDatum(@NotNull ItemStack stack, @Nullable Iota iota) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Pair<ItemStack, IotaHolderItem> pair = Companion.getIotaStack(stack);
        ItemStack iotaStack = (ItemStack)pair.component1();
        IotaHolderItem iotaHolder = (IotaHolderItem)pair.component2();
        if (iotaHolder != null) {
            iotaHolder.writeDatum(iotaStack, iota);
            Companion.setIotaStack(stack, iotaStack);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)isAdvanced, (String)"isAdvanced");
        Pair<ItemStack, IotaHolderItem> pair = Companion.getIotaStack(stack);
        ItemStack iotaStack = (ItemStack)pair.component1();
        IotaHolderItem iotaHolder = (IotaHolderItem)pair.component2();
        if (iotaHolder != null) {
            Collection collection = tooltipComponents;
            Object[] objectArray = new Object[]{ExtensionsKt.getStyledHoverName(iotaStack)};
            collection.add(HexUtils.asTranslatedComponent((String)"hexdebug.tooltip.focus_holder.item", (Object[])objectArray));
            IotaHolderItem.appendHoverText((IotaHolderItem)iotaHolder, (ItemStack)iotaStack, tooltipComponents, (TooltipFlag)isAdvanced);
        }
    }

    @NotNull
    public List<ModelPredicateEntry> getModelPredicates() {
        return CollectionsKt.listOf((Object)new ModelPredicateEntry(HAS_ITEM, (Function4<? super ItemStack, ? super ClientLevel, ? super LivingEntity, ? super Integer, Float>)((Function4)getModelPredicates.1.INSTANCE)));
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack other = slot.getItem();
        if (action != ClickAction.SECONDARY || stack.getCount() != 1 || other.getCount() > 1) {
            return false;
        }
        if (other.isEmpty()) {
            ItemStack iotaStack = (ItemStack)Companion.getIotaStack(stack).component1();
            if (ExtensionsKt.isNotEmpty(iotaStack)) {
                ItemStack itemStack = slot.safeInsert(iotaStack);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"safeInsert(...)");
                Companion.setIotaStack(stack, itemStack);
            }
        } else {
            Intrinsics.checkNotNull((Object)other);
            if (FocusHolderBlockEntity.Companion.isValidItem(other) && !Companion.getHasIotaStack(stack)) {
                ItemStack itemStack = slot.safeTake(1, 1, player);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"safeTake(...)");
                Companion.setIotaStack(stack, itemStack);
            }
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (action != ClickAction.SECONDARY || stack.getCount() != 1 || other.getCount() > 1 || !slot.allowModification(player)) {
            return false;
        }
        if (other.isEmpty()) {
            ItemStack iotaStack = (ItemStack)Companion.getIotaStack(stack).component1();
            if (ExtensionsKt.isNotEmpty(iotaStack)) {
                access.set(iotaStack);
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                Companion.setIotaStack(stack, itemStack);
            }
        } else if (FocusHolderBlockEntity.Companion.isValidItem(other) && !Companion.getHasIotaStack(stack)) {
            Companion.setIotaStack(stack, other);
            other.shrink(1);
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0014\u001a\u00020\u0011*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lgay/object/hexdebug/items/FocusHolderBlockItem$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "Lkotlin/Pair;", "Lat/petrak/hexcasting/api/item/IotaHolderItem;", "getIotaStack", "(Lnet/minecraft/world/item/ItemStack;)Lkotlin/Pair;", "iotaStack", "setIotaStack", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/resources/ResourceLocation;", "HAS_ITEM", "Lnet/minecraft/resources/ResourceLocation;", "getHAS_ITEM", "()Lnet/minecraft/resources/ResourceLocation;", "", "getHasIotaStack", "(Lnet/minecraft/world/item/ItemStack;)Z", "hasIotaStack", "hexdebug-common"})
    @SourceDebugExtension(value={"SMAP\nFocusHolderBlockItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusHolderBlockItem.kt\ngay/object/hexdebug/items/FocusHolderBlockItem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getHAS_ITEM() {
            return HAS_ITEM;
        }

        public final boolean getHasIotaStack(@NotNull ItemStack $this$hasIotaStack) {
            boolean bl;
            ListTag listTag;
            Intrinsics.checkNotNullParameter((Object)$this$hasIotaStack, (String)"<this>");
            CompoundTag compoundTag = BlockItem.getBlockEntityData((ItemStack)$this$hasIotaStack);
            if (compoundTag != null && (listTag = NBTHelper.getListByByte((CompoundTag)compoundTag, (String)"Items", (byte)10)) != null) {
                ListTag it = listTag;
                boolean bl2 = false;
                bl = it.size() > 0;
            } else {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final Pair<ItemStack, IotaHolderItem> getIotaStack(@NotNull ItemStack $this$getIotaStack) {
            Intrinsics.checkNotNullParameter((Object)$this$getIotaStack, (String)"<this>");
            CompoundTag compoundTag = BlockItem.getBlockEntityData((ItemStack)$this$getIotaStack);
            if (compoundTag == null) {
                compoundTag = new CompoundTag();
            }
            CompoundTag blockEntityTag = compoundTag;
            NonNullList containerStacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)blockEntityTag, (NonNullList)containerStacks);
            Intrinsics.checkNotNull((Object)containerStacks);
            ItemStack iotaStack = (ItemStack)CollectionsKt.first((List)((List)containerStacks));
            Item item = iotaStack.getItem();
            return new Pair((Object)iotaStack, (Object)(item instanceof IotaHolderItem ? (IotaHolderItem)item : null));
        }

        @NotNull
        public final ItemStack setIotaStack(@NotNull ItemStack $this$setIotaStack, @NotNull ItemStack iotaStack) {
            CompoundTag compoundTag;
            Intrinsics.checkNotNullParameter((Object)$this$setIotaStack, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)iotaStack, (String)"iotaStack");
            if (iotaStack.isEmpty()) {
                compoundTag = new CompoundTag();
            } else {
                Object[] objectArray = new ItemStack[]{iotaStack};
                NonNullList containerStacks = NonNullList.of((Object)ItemStack.EMPTY, (Object[])objectArray);
                CompoundTag compoundTag2 = BlockItem.getBlockEntityData((ItemStack)$this$setIotaStack);
                if (compoundTag2 == null) {
                    compoundTag2 = new CompoundTag();
                }
                compoundTag = ContainerHelper.saveAllItems((CompoundTag)compoundTag2, (NonNullList)containerStacks);
            }
            CompoundTag tag = compoundTag;
            BlockItem.setBlockEntityData((ItemStack)$this$setIotaStack, HexDebugBlockEntities.FOCUS_HOLDER.getValue(), (CompoundTag)tag);
            return $this$setIotaStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

