/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.imgui.VeilLanguageDefinitions;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.compat.IrisShaderMap;
import foundry.veil.impl.compat.SodiumShaderMap;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import foundry.veil.mixin.accessor.LevelRendererAccessor;
import foundry.veil.mixin.accessor.PostChainAccessor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.ObjIntConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class ShaderEditor
extends SingleWindowEditor
implements ResourceManagerReloadListener {
    public static final Component TITLE = Component.translatable((String)"editor.veil.shader.title");
    private static final Component REFRESH = Component.translatable((String)"editor.veil.shader.button.refresh");
    private static final Component SEARCH = Component.translatable((String)"editor.veil.shader.search");
    private static final Component SHADER_PROGRAMS = Component.translatable((String)"editor.veil.shader.shader_programs");
    private static final Component SHADER_DEFINITIONS = Component.translatable((String)"editor.veil.shader.definitions");
    private static final Component SHADER_DEFINITIONS_HINT = Component.translatable((String)"editor.veil.shader.definitions.hint");
    private static final Component OPEN_SOURCE = Component.translatable((String)"editor.veil.shader.open_source");
    private final CodeEditor codeEditor;
    private final Object2IntMap<ResourceLocation> shaders = new Object2IntRBTreeMap((a, b) -> {
        int compare = a.getNamespace().compareTo(b.getNamespace());
        if (compare == 0) {
            return a.getPath().compareTo(b.getPath());
        }
        return compare;
    });
    private final ImString programFilterText;
    private Pattern programFilter;
    private SelectedProgram selectedProgram;
    private int selectedTab;
    private final ImString addDefinitionText;
    private final Set<String> removedDefinitions;
    private final ImBoolean editSourceOpen;

    public ShaderEditor() {
        this.codeEditor = new CodeEditor(null);
        this.codeEditor.getEditor().setLanguageDefinition(VeilLanguageDefinitions.glsl());
        this.programFilterText = new ImString(128);
        this.programFilter = null;
        this.selectedProgram = null;
        this.selectedTab = 0;
        this.addDefinitionText = new ImString(128);
        this.removedDefinitions = new HashSet<String>(1);
        this.editSourceOpen = new ImBoolean();
    }

    private void setSelectedProgram(@Nullable ResourceLocation name) {
        if (name != null && this.shaders.containsKey((Object)name)) {
            int program = this.shaders.getInt((Object)name);
            if (GL20C.glIsProgram((int)program)) {
                int[] attachedShaders = new int[GL20C.glGetProgrami((int)program, (int)35717)];
                GL20C.glGetAttachedShaders((int)program, null, (int[])attachedShaders);
                Int2IntArrayMap shaders = new Int2IntArrayMap(attachedShaders.length);
                for (int shader : attachedShaders) {
                    shaders.put(GL20C.glGetShaderi((int)shader, (int)35663), shader);
                }
                this.selectedProgram = new SelectedProgram(name, program, Collections.unmodifiableMap(shaders));
                return;
            }
            Veil.LOGGER.error("Compiled shader does not exist for program: {}", (Object)name);
        }
        this.selectedProgram = null;
    }

    private void setEditShaderSource(int shader) {
        this.editSourceOpen.set(true);
        this.codeEditor.show(null, GL20C.glGetShaderSource((int)shader));
    }

    private void reloadShaders() {
        this.shaders.clear();
        TabSource.values()[this.selectedTab].addShaders((arg_0, arg_1) -> this.shaders.put(arg_0, arg_1));
        if (this.selectedProgram != null && !this.shaders.containsKey((Object)this.selectedProgram.name)) {
            this.setSelectedProgram(null);
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        this.removedDefinitions.clear();
        ImGui.beginChild((String)"##shader_programs", (float)(ImGui.getContentRegionAvailX() * 2.0f / 3.0f), (float)0.0f);
        VeilImGuiUtil.component((FormattedText)SHADER_PROGRAMS);
        TabSource[] sources = TabSource.values();
        if (ImGui.beginTabBar((String)"##controls")) {
            if (ImGui.tabItemButton((String)REFRESH.getString())) {
                this.reloadShaders();
            }
            for (TabSource source : sources) {
                if (!source.visible.getAsBoolean()) continue;
                ImGui.beginDisabled((!source.active.getAsBoolean() ? 1 : 0) != 0);
                if (ImGui.beginTabItem((String)source.displayName.getString())) {
                    if (this.selectedTab != source.ordinal()) {
                        this.selectedTab = source.ordinal();
                        this.setSelectedProgram(null);
                        this.reloadShaders();
                    }
                    ImGui.endTabItem();
                }
                ImGui.endDisabled();
            }
            ImGui.endTabBar();
        }
        while (!sources[this.selectedTab].active.getAsBoolean() && this.selectedTab > 0) {
            --this.selectedTab;
            this.setSelectedProgram(null);
            this.reloadShaders();
        }
        ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
        if (ImGui.inputTextWithHint((String)"##search", (String)SEARCH.getString(), (ImString)this.programFilterText)) {
            String regex = this.programFilterText.get();
            this.programFilter = null;
            if (!regex.isBlank()) {
                try {
                    this.programFilter = Pattern.compile(regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (ImGui.beginListBox((String)"##programs", (float)ImGui.getContentRegionAvailX(), (float)-1.4E-45f)) {
            for (Object2IntMap.Entry entry : this.shaders.object2IntEntrySet()) {
                boolean selected;
                ResourceLocation name = (ResourceLocation)entry.getKey();
                boolean bl = selected = this.selectedProgram != null && name.equals((Object)this.selectedProgram.name);
                if (this.programFilter != null && !this.programFilter.matcher(name.toString()).find()) {
                    if (!selected) continue;
                    this.setSelectedProgram(null);
                    continue;
                }
                if (ImGui.selectable((String)("##" + name.toString()), (boolean)selected)) {
                    this.setSelectedProgram(name);
                }
                ImGui.sameLine();
                VeilImGuiUtil.resourceLocation(name);
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)ImGui.getStyle().getItemSpacingY());
                ImGui.sameLine();
                ImGui.text((String)(" (" + entry.getIntValue() + ")"));
                ImGui.popStyleVar();
            }
            ImGui.endListBox();
        }
        ImGui.endChild();
        ShaderPreDefinitions definitions = VeilRenderSystem.renderer().getShaderDefinitions();
        ImGui.sameLine();
        if (ImGui.beginChild((String)"##panel", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
            if (ImGui.beginChild((String)"##open_source", (float)0.0f, (float)(ImGui.getContentRegionAvailY() / 2.0f))) {
                VeilImGuiUtil.component((FormattedText)OPEN_SOURCE);
                this.openShaderButton(35632);
                this.openShaderButton(35633);
                this.openShaderButton(37305);
                this.openShaderButton(36313);
                this.openShaderButton(36488);
                this.openShaderButton(36487);
            }
            ImGui.endChild();
            if (ImGui.beginChild((String)"##shader_definitions", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
                VeilImGuiUtil.component((FormattedText)SHADER_DEFINITIONS);
                ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
                if (ImGui.inputTextWithHint((String)"##add_definition", (String)SHADER_DEFINITIONS_HINT.getString(), (ImString)this.addDefinitionText, (int)32)) {
                    definitions.define(this.addDefinitionText.get().trim());
                    this.addDefinitionText.clear();
                }
                if (ImGui.beginListBox((String)"##definitions", (float)-1.4E-45f, (float)ImGui.getContentRegionAvailY())) {
                    for (Map.Entry<String, String> entry : definitions.getDefinitions().entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        ImGui.pushID((String)name);
                        ImGui.text((String)value);
                        float size = ImGui.getTextLineHeightWithSpacing();
                        ImGui.sameLine();
                        ImGui.dummy((float)(ImGui.getContentRegionAvailX() - ImGui.getStyle().getCellPaddingX() * 2.0f - size), (float)0.0f);
                        ImGui.sameLine();
                        if (ImGui.button((String)"X", (float)size, (float)size)) {
                            this.removedDefinitions.add(name);
                        }
                        ImGui.popID();
                    }
                    ImGui.endListBox();
                }
            }
            ImGui.endChild();
        }
        ImGui.endChild();
        for (String name : this.removedDefinitions) {
            definitions.remove(name);
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints((float)600.0f, (float)400.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        super.render();
        this.codeEditor.renderWindow();
    }

    private void openShaderButton(int type) {
        boolean disabled = this.selectedProgram == null || !this.selectedProgram.shaders.containsKey(type);
        ImGui.beginDisabled((boolean)disabled);
        if (disabled) {
            ImGui.pushStyleColor((int)21, (int)ImGui.getColorU32((int)7));
        }
        if (ImGui.button((String)DeviceInfoViewer.getShaderName(type).getString())) {
            this.setEditShaderSource(this.selectedProgram.shaders.get(type));
        }
        if (disabled) {
            ImGui.popStyleColor();
        }
        ImGui.endDisabled();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.reloadShaders();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.shaders.clear();
    }

    @Override
    public void free() {
        super.free();
        this.codeEditor.free();
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        if (this.isOpen()) {
            this.reloadShaders();
        }
    }

    private record SelectedProgram(ResourceLocation name, int programId, Map<Integer, Integer> shaders) {
    }

    private static enum TabSource {
        VANILLA((Component)Component.translatable((String)"editor.veil.shader.source.vanilla")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                GameRendererAccessor gameRenderer = (GameRendererAccessor)Minecraft.getInstance().gameRenderer;
                Map<String, ShaderInstance> shaders = gameRenderer.getShaders();
                for (ShaderInstance shader : shaders.values()) {
                    String name = shader.getName().isBlank() ? Integer.toString(shader.getId()) : shader.getName();
                    registry.accept(ResourceLocation.parse((String)name), shader.getId());
                }
                ShaderInstance blitShader = gameRenderer.getBlitShader();
                registry.accept(ResourceLocation.parse((String)blitShader.getName()), blitShader.getId());
            }
        }
        ,
        VANILLA_POST((Component)Component.translatable((String)"editor.veil.shader.source.vanilla_post")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                LevelRendererAccessor levelRenderer = (LevelRendererAccessor)Minecraft.getInstance().levelRenderer;
                this.addChainPasses(registry, levelRenderer.getEntityEffect());
                this.addChainPasses(registry, levelRenderer.getTransparencyChain());
                GameRendererAccessor gameRenderer = (GameRendererAccessor)Minecraft.getInstance().gameRenderer;
                this.addChainPasses(registry, gameRenderer.getPostEffect());
            }

            private void addChainPasses(ObjIntConsumer<ResourceLocation> registry, @Nullable PostChain chain) {
                if (chain == null) {
                    return;
                }
                List<PostPass> passes = ((PostChainAccessor)chain).getPasses();
                for (PostPass pass : passes) {
                    EffectInstance effect = pass.getEffect();
                    registry.accept(ResourceLocation.parse((String)effect.getName()), effect.getId());
                }
            }
        }
        ,
        VEIL((Component)Component.translatable((String)"editor.veil.shader.source.veil")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                Map<ResourceLocation, ShaderProgram> shaders = VeilRenderSystem.renderer().getShaderManager().getShaders();
                for (ShaderProgram shader : shaders.values()) {
                    registry.accept(shader.getId(), shader.getProgram());
                }
                VeilImGuiImpl.get().addImguiShaders(registry);
            }
        }
        ,
        IRIS((Component)Component.translatable((String)"editor.veil.shader.source.iris"), IrisShaderMap::isEnabled, IrisShaderMap::isEnabled){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                for (ShaderInstance shader : IrisShaderMap.getLoadedShaders()) {
                    String name = shader.getName().isBlank() ? Integer.toString(shader.getId()) : shader.getName();
                    registry.accept(ResourceLocation.parse((String)name), shader.getId());
                }
            }
        }
        ,
        SODIUM((Component)Component.translatable((String)"editor.veil.shader.source.sodium"), SodiumShaderMap::isEnabled, SodiumShaderMap::isEnabled){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                for (Object2IntMap.Entry entry : SodiumShaderMap.getLoadedShaders().object2IntEntrySet()) {
                    registry.accept((ResourceLocation)entry.getKey(), entry.getIntValue());
                }
            }
        }
        ,
        OTHER((Component)Component.translatable((String)"editor.veil.shader.source.unknown")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                IntOpenHashSet programs = new IntOpenHashSet();
                for (int i = 1; i < 10000; ++i) {
                    if (!GL20C.glIsProgram((int)i)) continue;
                    programs.add(i);
                }
                for (TabSource value : TabSource.values()) {
                    if (value == this) continue;
                    value.addShaders((arg_0, arg_1) -> 6.lambda$addShaders$0((IntSet)programs, arg_0, arg_1));
                }
                IntIterator intIterator = programs.iterator();
                while (intIterator.hasNext()) {
                    int program = (Integer)intIterator.next();
                    registry.accept(ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)Integer.toString(program)), program);
                }
            }

            private static /* synthetic */ void lambda$addShaders$0(IntSet programs, ResourceLocation name, int id) {
                programs.remove(id);
            }
        };

        private final Component displayName;
        private final BooleanSupplier active;
        private final BooleanSupplier visible;

        private TabSource(Component displayName) {
            this(displayName, () -> true, () -> true);
        }

        private TabSource(Component displayName, BooleanSupplier active, BooleanSupplier visible) {
            this.displayName = displayName;
            this.active = active;
            this.visible = visible;
        }

        public abstract void addShaders(ObjIntConsumer<ResourceLocation> var1);
    }
}

