/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.expression;

import com.google.common.collect.Streams;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.node.GlslNode;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class GlslAssignmentNode
implements GlslNode {
    private GlslNode first;
    private GlslNode second;
    private Operand operand;

    public GlslAssignmentNode(GlslNode first, GlslNode second, Operand operand) {
        this.first = first;
        this.second = second;
        this.operand = operand;
    }

    @Override
    @Nullable
    public GlslSpecifiedType getType() {
        return this.first.getType();
    }

    public GlslNode getFirst() {
        return this.first;
    }

    public GlslNode getSecond() {
        return this.second;
    }

    public Operand getOperand() {
        return this.operand;
    }

    public GlslAssignmentNode setFirst(GlslNode first) {
        this.first = first;
        return this;
    }

    public GlslAssignmentNode setSecond(GlslNode second) {
        this.second = second;
        return this;
    }

    public GlslAssignmentNode setOperand(Operand operand) {
        this.operand = operand;
        return this;
    }

    @Override
    public String getSourceString() {
        return this.first.getSourceString() + " " + this.operand.getDelimiter() + " " + this.second.getSourceString();
    }

    @Override
    public Stream<GlslNode> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.first.stream(), this.second.stream()});
    }

    public String toString() {
        return "GlslAssignmentNode{first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", operand=" + String.valueOf((Object)this.operand) + "]";
    }

    public static enum Operand {
        EQUAL("="),
        MUL_ASSIGN("*="),
        DIV_ASSIGN("/="),
        MOD_ASSIGN("%="),
        ADD_ASSIGN("+="),
        SUB_ASSIGN("-="),
        LEFT_ASSIGN("<<="),
        RIGHT_ASSIGN(">>="),
        AND_ASSIGN("&="),
        XOR_ASSIGN("^="),
        OR_ASSIGN("|=");

        private final String delimiter;

        private Operand(String delimiter) {
            this.delimiter = delimiter;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

