/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.Veil;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class FramebufferManager
extends CodecReloadListener<FramebufferDefinition>
implements NativeResource {
    private static final ResourceLocation MAIN = ResourceLocation.withDefaultNamespace((String)"main");
    public static final Codec<ResourceLocation> FRAMEBUFFER_CODEC = Codec.STRING.comapFlatMap(name -> {
        try {
            if (!name.contains(":")) {
                ResourceLocation id = ResourceLocation.tryBuild((String)"temp", (String)name);
                return id != null ? DataResult.success((Object)id) : DataResult.error(() -> "Invalid path: " + name);
            }
            ResourceLocation id = ResourceLocation.tryParse((String)name);
            return id != null ? DataResult.success((Object)id) : DataResult.error(() -> "Invalid path: " + name);
        }
        catch (ResourceLocationException e) {
            return DataResult.error(() -> "Not a valid resource location: " + name + ". " + e.getMessage());
        }
    }, location -> "temp".equals(location.getNamespace()) ? location.getPath() : location.toString()).stable();
    public static final FileToIdConverter FRAMEBUFFER_LISTER = FileToIdConverter.json((String)"pinwheel/framebuffers");
    private final Map<ResourceLocation, FramebufferDefinition> framebufferDefinitions = new HashMap<ResourceLocation, FramebufferDefinition>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffersView = Collections.unmodifiableMap(this.framebuffers);
    private final Set<ResourceLocation> screenFramebuffers = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> manualFramebuffers = new HashSet<ResourceLocation>();

    public FramebufferManager() {
        super(FramebufferDefinition.CODEC, FRAMEBUFFER_LISTER);
    }

    private void initFramebuffer(ResourceLocation name, FramebufferDefinition definition, MolangEnvironment runtime) {
        try {
            AdvancedFbo fbo = definition.createBuilder(runtime).build(true);
            fbo.bindDraw(false);
            fbo.clear();
            this.framebuffers.put(name, fbo);
            if (!definition.autoClear()) {
                this.manualFramebuffers.add(name);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to initialize framebuffer: {}", (Object)name, (Object)e);
        }
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)width).setQuery("screen_height", (float)height).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        for (ResourceLocation name : this.screenFramebuffers) {
            FramebufferDefinition definition;
            this.manualFramebuffers.remove(name);
            AdvancedFbo fbo = this.framebuffers.remove(name);
            if (fbo != null) {
                fbo.free();
            }
            if ((definition = this.framebufferDefinitions.get(name)) == null) continue;
            this.initFramebuffer(name, definition, (MolangEnvironment)runtime);
        }
        AdvancedFbo.unbind();
    }

    @ApiStatus.Internal
    public void clear() {
        this.framebuffers.forEach((name, fbo) -> {
            if (this.manualFramebuffers.contains(name)) {
                return;
            }
            fbo.bindDraw(false);
            fbo.clear();
        });
    }

    public void setFramebuffer(ResourceLocation name, AdvancedFbo fbo) {
        AdvancedFbo oldBuffer;
        if (this.manualFramebuffers.add(name) && (oldBuffer = this.framebuffers.remove(name)) != null) {
            oldBuffer.free();
            Veil.LOGGER.warn("Replaced defined framebuffer {} with manual buffer", (Object)name);
        }
        this.framebuffers.put(name, fbo);
    }

    @Nullable
    public AdvancedFbo removeFramebuffer(ResourceLocation name) {
        if (this.manualFramebuffers.remove(name)) {
            return this.framebuffers.remove(name);
        }
        return null;
    }

    @Nullable
    public AdvancedFbo getFramebuffer(ResourceLocation name) {
        return this.framebuffers.get(name);
    }

    public Map<ResourceLocation, AdvancedFbo> getFramebuffers() {
        return this.framebuffersView;
    }

    protected void apply(@NotNull Map<ResourceLocation, FramebufferDefinition> data, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.framebufferDefinitions.clear();
        this.framebufferDefinitions.putAll(data);
        Veil.LOGGER.info("Loaded {} framebuffers", (Object)this.framebufferDefinitions.size());
        this.free();
        Window window = Minecraft.getInstance().getWindow();
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)window.getWidth()).setQuery("screen_height", (float)window.getHeight()).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebufferDefinitions.forEach((name, definition) -> {
            this.initFramebuffer((ResourceLocation)name, (FramebufferDefinition)definition, (MolangEnvironment)runtime);
            if (!definition.width().isConstant() || !definition.height().isConstant()) {
                this.screenFramebuffers.add((ResourceLocation)name);
            }
        });
        AdvancedFbo.unbind();
        this.setFramebuffer(MAIN, AdvancedFbo.getMainFramebuffer());
    }

    public void free() {
        this.framebuffers.keySet().removeAll(this.manualFramebuffers);
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
        this.manualFramebuffers.clear();
        this.screenFramebuffers.clear();
    }
}

