/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import foundry.veil.Veil;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.DirectionalLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.deferred.light.renderer.IndirectLightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.impl.client.render.light.AreaLightRenderer;
import foundry.veil.impl.client.render.light.DirectionalLightRenderer;
import foundry.veil.impl.client.render.light.IndirectPointLightRenderer;
import foundry.veil.impl.client.render.light.InstancedPointLightRenderer;
import foundry.veil.platform.registry.RegistrationProvider;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LightTypeRegistry {
    public static final ResourceKey<Registry<LightType<?>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath("light_type"));
    private static final RegistrationProvider<LightType<?>> PROVIDER = RegistrationProvider.get(REGISTRY_KEY, "veil");
    public static final Registry<LightType<?>> REGISTRY = PROVIDER.asVanillaRegistry();
    public static final Supplier<LightType<DirectionalLight>> DIRECTIONAL = LightTypeRegistry.register("directional", DirectionalLightRenderer::new, (level, camera) -> new DirectionalLight().setTo(camera).setDirection(0.0f, -1.0f, 0.0f));
    public static final Supplier<LightType<PointLight>> POINT = LightTypeRegistry.register("point", () -> {
        boolean supported = IndirectLightRenderer.isSupported();
        if (supported) {
            Veil.LOGGER.info("Using Indirect Point Light Renderer");
            return new IndirectPointLightRenderer();
        }
        Veil.LOGGER.info("Using Instanced Point Light Renderer");
        return new InstancedPointLightRenderer();
    }, (level, camera) -> new PointLight().setTo(camera).setRadius(15.0f));
    public static final Supplier<LightType<AreaLight>> AREA = LightTypeRegistry.register("area", AreaLightRenderer::new, (level, camera) -> new AreaLight().setDistance(15.0f).setTo(camera));

    @ApiStatus.Internal
    public static void bootstrap() {
    }

    private static <T extends Light> Supplier<LightType<T>> register(String name, RendererFactory<T> factory, @Nullable DebugLightFactory debugFactory) {
        return PROVIDER.register(name, () -> new LightType(factory, debugFactory));
    }

    @FunctionalInterface
    public static interface RendererFactory<T extends Light> {
        public LightTypeRenderer<T> createRenderer();
    }

    @FunctionalInterface
    public static interface DebugLightFactory {
        public Light createDebugLight(ClientLevel var1, Camera var2);
    }

    public record LightType<T extends Light>(RendererFactory<T> rendererFactory, @Nullable DebugLightFactory debugLightFactory) {
    }
}

