/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.visitor;

import foundry.veil.impl.glsl.grammar.GlslVersion;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.variable.GlslDeclaration;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.node.variable.GlslStructNode;
import foundry.veil.impl.glsl.visitor.GlslFunctionVisitor;
import foundry.veil.impl.glsl.visitor.GlslTreeVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GlslStringWriter
implements GlslTreeVisitor {
    private final Map<GlslNode, String> markedNodes = new HashMap<GlslNode, String>();
    private final StringBuilder builder = new StringBuilder();
    private String value = "";

    private String formatExpression(GlslNode node) {
        return node.getSourceString();
    }

    @Override
    public void visitMarkers(Map<String, GlslNode> markers) {
        for (Map.Entry<String, GlslNode> entry : markers.entrySet()) {
            this.markedNodes.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void visitVersion(GlslVersion version) {
        this.builder.append("#version ").append(version.getVersionStatement()).append("\n\n");
    }

    @Override
    public void visitDirective(String directive) {
        this.builder.append(directive).append('\n');
    }

    @Override
    public void visitField(GlslNewNode newNode) {
        String marker = this.markedNodes.get(newNode);
        if (marker != null) {
            this.builder.append("/* #").append(marker).append(" */\n");
        }
        this.builder.append(this.formatExpression(newNode)).append(";\n");
    }

    @Override
    public void visitStruct(GlslStructNode structSpecifier) {
        String marker = this.markedNodes.get(structSpecifier);
        if (marker != null) {
            this.builder.append("/* #").append(marker).append(" */\n");
        }
        this.builder.append(this.formatExpression(structSpecifier)).append(";\n");
    }

    @Override
    public void visitDeclaration(GlslDeclaration declaration) {
        String marker = this.markedNodes.get(declaration);
        if (marker != null) {
            this.builder.append("/* #").append(marker).append(" */\n");
        }
        this.builder.append(this.formatExpression(declaration)).append(";\n");
    }

    @Override
    @Nullable
    public GlslFunctionVisitor visitFunction(GlslFunctionNode node) {
        String marker = this.markedNodes.get(node);
        if (marker != null) {
            this.builder.append("/* #").append(marker).append(" */\n");
        }
        this.builder.append(node.getSourceString());
        return null;
    }

    @Override
    public void visitTreeEnd() {
        this.markedNodes.clear();
        this.value = this.builder.toString();
        this.builder.setLength(0);
    }

    public String toString() {
        return this.value;
    }
}

