/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl;

import foundry.veil.impl.glsl.GlslLexer;
import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.GlslTokenReader;
import foundry.veil.impl.glsl.grammar.GlslFunctionHeader;
import foundry.veil.impl.glsl.grammar.GlslParameterDeclaration;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.grammar.GlslStructField;
import foundry.veil.impl.glsl.grammar.GlslStructSpecifier;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.grammar.GlslTypeSpecifier;
import foundry.veil.impl.glsl.grammar.GlslVersion;
import foundry.veil.impl.glsl.node.GlslEmptyNode;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.branch.ForLoopNode;
import foundry.veil.impl.glsl.node.branch.GlslCaseLabelNode;
import foundry.veil.impl.glsl.node.branch.GlslReturnNode;
import foundry.veil.impl.glsl.node.branch.GlslSelectionNode;
import foundry.veil.impl.glsl.node.branch.GlslSwitchNode;
import foundry.veil.impl.glsl.node.branch.JumpNode;
import foundry.veil.impl.glsl.node.branch.WhileLoopNode;
import foundry.veil.impl.glsl.node.expression.GlslAndNode;
import foundry.veil.impl.glsl.node.expression.GlslAssignmentNode;
import foundry.veil.impl.glsl.node.expression.GlslCompareNode;
import foundry.veil.impl.glsl.node.expression.GlslConditionalNode;
import foundry.veil.impl.glsl.node.expression.GlslExclusiveOrNode;
import foundry.veil.impl.glsl.node.expression.GlslInclusiveOrNode;
import foundry.veil.impl.glsl.node.expression.GlslLogicalAndNode;
import foundry.veil.impl.glsl.node.expression.GlslLogicalOrNode;
import foundry.veil.impl.glsl.node.expression.GlslLogicalXorNode;
import foundry.veil.impl.glsl.node.expression.GlslOperationNode;
import foundry.veil.impl.glsl.node.expression.GlslPrecisionNode;
import foundry.veil.impl.glsl.node.expression.GlslUnaryNode;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.function.GlslInvokeFunctionNode;
import foundry.veil.impl.glsl.node.function.GlslPrimitiveConstructorNode;
import foundry.veil.impl.glsl.node.primary.GlslBoolConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslFloatConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslIntConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslIntFormat;
import foundry.veil.impl.glsl.node.variable.GlslArrayNode;
import foundry.veil.impl.glsl.node.variable.GlslDeclaration;
import foundry.veil.impl.glsl.node.variable.GlslFieldNode;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.node.variable.GlslStructNode;
import foundry.veil.impl.glsl.node.variable.GlslVariableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class GlslParser {
    public static GlslTree parse(String input) throws GlslSyntaxException {
        GlslTokenReader reader = new GlslTokenReader(input);
        GlslVersion version = new GlslVersion(110, true);
        GlslLexer.Token token = reader.peek();
        if (token != null && token.type() == GlslLexer.TokenType.DIRECTIVE && token.value().startsWith("#version ")) {
            reader.skip();
            String[] parts = token.value().substring(9).split(" +", 2);
            try {
                int ver = Integer.parseInt(parts[0]);
                boolean core = parts.length == 1 || parts[1].equals("core");
                version.setVersion(ver);
                version.setCore(core);
            }
            catch (NumberFormatException e) {
                throw reader.error("Invalid Version: " + token.value() + ". " + e.getMessage());
            }
        }
        ArrayList<String> directives = new ArrayList<String>();
        ArrayList<GlslNode> body = new ArrayList<GlslNode>();
        while (reader.canRead()) {
            if (reader.tryConsume(GlslLexer.TokenType.DIRECTIVE)) {
                directives.add(reader.peek(-1).value());
                continue;
            }
            int cursor = reader.getCursor();
            GlslFunctionNode functionDefinition = GlslParser.parseFunctionDefinition(reader);
            if (functionDefinition != null) {
                reader.markNode(cursor, functionDefinition);
                body.add(functionDefinition);
                continue;
            }
            cursor = reader.getCursor();
            GlslNode declaration = GlslParser.parseDeclaration(reader);
            if (declaration != null) {
                reader.markNode(cursor, declaration);
                body.add(declaration);
                continue;
            }
            if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) continue;
            reader.throwError();
        }
        return new GlslTree(version, body, directives, reader.getMarkedNodes());
    }

    public static GlslNode parseExpression(String input) throws GlslSyntaxException {
        return GlslParser.parseExpression(GlslLexer.createTokens(input + ";"));
    }

    public static GlslNode parseExpression(GlslLexer.Token[] tokens) throws GlslSyntaxException {
        GlslTokenReader reader = new GlslTokenReader(tokens);
        GlslNode expression = GlslParser.parseStatement(reader);
        if (expression == null) {
            reader.throwError();
        }
        while (reader.canRead() && reader.peek().type() == GlslLexer.TokenType.SEMICOLON) {
            reader.skip();
        }
        if (reader.canRead()) {
            throw reader.error("Too many tokens provided");
        }
        return expression;
    }

    public static List<GlslNode> parseExpressionList(String input) throws GlslSyntaxException {
        return GlslParser.parseExpressionList(GlslLexer.createTokens(input));
    }

    public static List<GlslNode> parseExpressionList(GlslLexer.Token[] tokens) throws GlslSyntaxException {
        GlslTokenReader reader = new GlslTokenReader(tokens);
        List<GlslNode> expressions = GlslParser.parseStatementList(reader);
        if (reader.canRead()) {
            throw reader.error("Too many tokens provided");
        }
        return expressions;
    }

    @Nullable
    private static GlslNode parsePrimaryExpression(GlslTokenReader reader) {
        GlslNode condition;
        if (reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
            String variableName = reader.peek(-1).value();
            return new GlslVariableNode(variableName);
        }
        if (reader.tryConsume(GlslLexer.TokenType.INTEGER_DECIMAL_CONSTANT)) {
            return new GlslIntConstantNode(GlslIntFormat.DECIMAL, true, Integer.parseUnsignedInt(reader.peek(-1).value(), 10));
        }
        if (reader.tryConsume(GlslLexer.TokenType.INTEGER_HEXADECIMAL_CONSTANT)) {
            return new GlslIntConstantNode(GlslIntFormat.HEXADECIMAL, true, Integer.parseUnsignedInt(reader.peek(-1).value(), 16));
        }
        if (reader.tryConsume(GlslLexer.TokenType.INTEGER_OCTAL_CONSTANT)) {
            return new GlslIntConstantNode(GlslIntFormat.OCTAL, true, Integer.parseUnsignedInt(reader.peek(-1).value(), 8));
        }
        if (reader.tryConsume(GlslLexer.TokenType.UINTEGER_DECIMAL_CONSTANT)) {
            String value = reader.peek(-1).value();
            if (value.endsWith("u")) {
                value = value.substring(0, value.length() - 1);
            }
            return new GlslIntConstantNode(GlslIntFormat.DECIMAL, false, Integer.parseUnsignedInt(value, 10));
        }
        if (reader.tryConsume(GlslLexer.TokenType.UINTEGER_HEXADECIMAL_CONSTANT)) {
            String value = reader.peek(-1).value();
            if (value.endsWith("u")) {
                value = value.substring(0, value.length() - 1);
            }
            return new GlslIntConstantNode(GlslIntFormat.HEXADECIMAL, false, Integer.parseUnsignedInt(value, 16));
        }
        if (reader.tryConsume(GlslLexer.TokenType.UINTEGER_OCTAL_CONSTANT)) {
            String value = reader.peek(-1).value();
            if (value.endsWith("u")) {
                value = value.substring(0, value.length() - 1);
            }
            return new GlslIntConstantNode(GlslIntFormat.OCTAL, false, Integer.parseUnsignedInt(value, 8));
        }
        if (reader.tryConsume(GlslLexer.TokenType.FLOATING_CONSTANT)) {
            return new GlslFloatConstantNode(Float.parseFloat(reader.peek(-1).value()));
        }
        if (reader.tryConsume(GlslLexer.TokenType.BOOL_CONSTANT)) {
            return new GlslBoolConstantNode(Boolean.parseBoolean(reader.peek(-1).value()));
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.LEFT_PAREN) && (condition = GlslParser.parseCondition(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            return condition;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parsePostfixExpression(boolean allowFunction, GlslTokenReader reader) {
        GlslNode primaryExpression;
        int cursor = reader.getCursor();
        if (allowFunction) {
            GlslNode functionCall = GlslParser.parseFunctionCallGeneric(reader);
            if (functionCall != null) {
                GlslNode integerExpression;
                int functionCursor = reader.getCursor();
                if (reader.tryConsume(GlslLexer.TokenType.LEFT_BRACKET) && (integerExpression = GlslParser.parseIntegerExpression(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACKET)) {
                    functionCall = new GlslArrayNode(functionCall, integerExpression);
                    functionCursor = reader.getCursor();
                }
                reader.setCursor(functionCursor);
                if (reader.tryConsume(GlslLexer.TokenType.DOT, GlslLexer.TokenType.IDENTIFIER)) {
                    StringBuilder fieldSelection = new StringBuilder(reader.peek(-1).value());
                    while (reader.tryConsume(GlslLexer.TokenType.DOT, GlslLexer.TokenType.IDENTIFIER)) {
                        fieldSelection.append('.').append(reader.peek(-1).value());
                    }
                    return new GlslFieldNode(functionCall, fieldSelection.toString());
                }
                reader.setCursor(functionCursor);
                if (reader.tryConsume(GlslLexer.TokenType.INC_OP)) {
                    return new GlslUnaryNode(functionCall, GlslUnaryNode.Operand.POST_INCREMENT);
                }
                reader.setCursor(functionCursor);
                if (reader.tryConsume(GlslLexer.TokenType.DEC_OP)) {
                    return new GlslUnaryNode(functionCall, GlslUnaryNode.Operand.POST_DECREMENT);
                }
                reader.setCursor(functionCursor);
                return functionCall;
            }
            reader.setCursor(cursor);
        }
        if ((primaryExpression = GlslParser.parsePrimaryExpression(reader)) != null) {
            GlslNode integerExpression;
            int expressionCursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.LEFT_BRACKET) && (integerExpression = GlslParser.parseIntegerExpression(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACKET)) {
                primaryExpression = new GlslArrayNode(primaryExpression, integerExpression);
                expressionCursor = reader.getCursor();
            }
            reader.setCursor(expressionCursor);
            if (reader.tryConsume(GlslLexer.TokenType.DOT, GlslLexer.TokenType.IDENTIFIER)) {
                StringBuilder fieldSelection = new StringBuilder(reader.peek(-1).value());
                while (reader.tryConsume(GlslLexer.TokenType.DOT, GlslLexer.TokenType.IDENTIFIER)) {
                    fieldSelection.append('.').append(reader.peek(-1).value());
                }
                return new GlslFieldNode(primaryExpression, fieldSelection.toString());
            }
            reader.setCursor(expressionCursor);
            if (reader.tryConsume(GlslLexer.TokenType.INC_OP)) {
                return new GlslUnaryNode(primaryExpression, GlslUnaryNode.Operand.POST_INCREMENT);
            }
            reader.setCursor(expressionCursor);
            if (reader.tryConsume(GlslLexer.TokenType.DEC_OP)) {
                return new GlslUnaryNode(primaryExpression, GlslUnaryNode.Operand.POST_DECREMENT);
            }
            reader.setCursor(expressionCursor);
            return primaryExpression;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseIntegerExpression(GlslTokenReader reader) {
        return GlslParser.parseExpression(reader);
    }

    @Nullable
    private static GlslNode parseFunctionCallGeneric(GlslTokenReader reader) {
        GlslNode functionCallHeader = GlslParser.parseFunctionCallHeader(reader);
        if (functionCallHeader == null) {
            return null;
        }
        int cursor = reader.getCursor();
        int parameterCursor = reader.getCursor();
        ArrayList<GlslNode> parameters = new ArrayList<GlslNode>();
        while (reader.canRead()) {
            GlslNode parameter = GlslParser.parseAssignmentExpression(reader);
            if (parameter == null) {
                reader.setCursor(parameterCursor);
                break;
            }
            parameters.add(parameter);
            reader.markNode(parameterCursor, parameter);
            parameterCursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        if (reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            return new GlslInvokeFunctionNode(functionCallHeader, parameters);
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.VOID, GlslLexer.TokenType.RIGHT_PAREN)) {
            return new GlslInvokeFunctionNode(functionCallHeader, Collections.emptyList());
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            return new GlslInvokeFunctionNode(functionCallHeader, Collections.emptyList());
        }
        reader.markError("Expected ')'");
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseFunctionCallHeader(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslTypeSpecifier typeSpecifier = GlslParser.parseTypeSpecifier(reader);
        if (typeSpecifier != null && !typeSpecifier.isNamed() && reader.tryConsume(GlslLexer.TokenType.LEFT_PAREN)) {
            return new GlslPrimitiveConstructorNode(typeSpecifier);
        }
        reader.setCursor(cursor);
        GlslNode expression = GlslParser.parsePostfixExpression(false, reader);
        if (expression != null && reader.tryConsume(GlslLexer.TokenType.LEFT_PAREN)) {
            return expression;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseUnaryExpression(GlslTokenReader reader) {
        GlslUnaryNode.Operand operator;
        GlslNode right;
        GlslNode expression = GlslParser.parsePostfixExpression(true, reader);
        if (expression != null) {
            return expression;
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.INC_OP) && (right = GlslParser.parseUnaryExpression(reader)) != null) {
            return new GlslUnaryNode(right, GlslUnaryNode.Operand.PRE_INCREMENT);
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.DEC_OP) && (right = GlslParser.parseUnaryExpression(reader)) != null) {
            return new GlslUnaryNode(right, GlslUnaryNode.Operand.PRE_DECREMENT);
        }
        reader.setCursor(cursor);
        if (reader.canRead() && (operator = reader.peek().type().asUnaryOperator()) != null) {
            reader.skip();
            GlslNode right2 = GlslParser.parseUnaryExpression(reader);
            if (right2 != null) {
                return new GlslUnaryNode(right2, operator);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseSimpleExpression(GlslTokenReader reader, Function<GlslTokenReader, GlslNode> parser, GlslLexer.TokenType operator, Function<List<GlslNode>, GlslNode> join) {
        int cursor = reader.getCursor();
        ArrayList<GlslNode> expressions = new ArrayList<GlslNode>();
        while (reader.canRead()) {
            GlslNode expression = parser.apply(reader);
            if (expression == null) {
                reader.setCursor(cursor);
                break;
            }
            expressions.add(expression);
            cursor = reader.getCursor();
            if (reader.tryConsume(operator)) continue;
            break;
        }
        if (expressions.isEmpty()) {
            return null;
        }
        if (expressions.size() == 1) {
            return (GlslNode)expressions.get(0);
        }
        return join.apply(expressions);
    }

    @Nullable
    private static GlslNode parseMultiplicativeExpression(GlslTokenReader reader) {
        GlslNode left = GlslParser.parseUnaryExpression(reader);
        if (left == null) {
            return null;
        }
        while (reader.canRead()) {
            GlslNode right;
            int cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.STAR)) {
                right = GlslParser.parseUnaryExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslOperationNode(left, right, GlslOperationNode.Operand.MULTIPLY);
                continue;
            }
            if (reader.tryConsume(GlslLexer.TokenType.SLASH)) {
                right = GlslParser.parseUnaryExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslOperationNode(left, right, GlslOperationNode.Operand.DIVIDE);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.PERCENT)) break;
            right = GlslParser.parseUnaryExpression(reader);
            if (right == null) {
                reader.setCursor(cursor);
                return left;
            }
            left = new GlslOperationNode(left, right, GlslOperationNode.Operand.MODULO);
        }
        return left;
    }

    @Nullable
    private static GlslNode parseAdditiveExpression(GlslTokenReader reader) {
        GlslNode left = GlslParser.parseMultiplicativeExpression(reader);
        if (left == null) {
            return null;
        }
        while (reader.canRead()) {
            GlslNode right;
            int cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.PLUS)) {
                right = GlslParser.parseMultiplicativeExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslOperationNode(left, right, GlslOperationNode.Operand.ADD);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.DASH)) break;
            right = GlslParser.parseMultiplicativeExpression(reader);
            if (right == null) {
                reader.setCursor(cursor);
                return left;
            }
            left = new GlslOperationNode(left, right, GlslOperationNode.Operand.SUBTRACT);
        }
        return left;
    }

    @Nullable
    private static GlslNode parseShiftExpression(GlslTokenReader reader) {
        GlslNode left = GlslParser.parseAdditiveExpression(reader);
        if (left == null) {
            return null;
        }
        while (reader.canRead()) {
            GlslNode right;
            int cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.LEFT_OP)) {
                right = GlslParser.parseAdditiveExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslOperationNode(left, right, GlslOperationNode.Operand.LEFT_SHIFT);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_OP)) break;
            right = GlslParser.parseAdditiveExpression(reader);
            if (right == null) {
                reader.setCursor(cursor);
                return left;
            }
            left = new GlslOperationNode(left, right, GlslOperationNode.Operand.RIGHT_SHIFT);
        }
        return left;
    }

    @Nullable
    private static GlslNode parseRelationalExpression(GlslTokenReader reader) {
        GlslNode left = GlslParser.parseShiftExpression(reader);
        if (left == null) {
            return null;
        }
        while (reader.canRead()) {
            GlslNode right;
            int cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.LEFT_ANGLE)) {
                right = GlslParser.parseShiftExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslCompareNode(left, right, GlslCompareNode.Operand.LESS);
                continue;
            }
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_ANGLE)) {
                right = GlslParser.parseShiftExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslCompareNode(left, right, GlslCompareNode.Operand.GREATER);
                continue;
            }
            if (reader.tryConsume(GlslLexer.TokenType.LE_OP)) {
                right = GlslParser.parseShiftExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslCompareNode(left, right, GlslCompareNode.Operand.LEQUAL);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.GE_OP)) break;
            right = GlslParser.parseShiftExpression(reader);
            if (right == null) {
                reader.setCursor(cursor);
                return left;
            }
            left = new GlslCompareNode(left, right, GlslCompareNode.Operand.GEQUAL);
        }
        return left;
    }

    @Nullable
    private static GlslNode parseEqualityExpression(GlslTokenReader reader) {
        GlslNode left = GlslParser.parseRelationalExpression(reader);
        if (left == null) {
            return null;
        }
        while (reader.canRead()) {
            GlslNode right;
            int cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.EQ_OP)) {
                right = GlslParser.parseRelationalExpression(reader);
                if (right == null) {
                    reader.setCursor(cursor);
                    return left;
                }
                left = new GlslCompareNode(left, right, GlslCompareNode.Operand.EQUAL);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.NE_OP)) break;
            right = GlslParser.parseRelationalExpression(reader);
            if (right == null) {
                reader.setCursor(cursor);
                return left;
            }
            left = new GlslCompareNode(left, right, GlslCompareNode.Operand.NOT_EQUAL);
        }
        return left;
    }

    @Nullable
    private static GlslNode parseAndExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseEqualityExpression, GlslLexer.TokenType.AMPERSAND, GlslAndNode::new);
    }

    @Nullable
    private static GlslNode parseExclusiveOrExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseAndExpression, GlslLexer.TokenType.CARET, GlslExclusiveOrNode::new);
    }

    @Nullable
    private static GlslNode parseInclusiveOrExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseExclusiveOrExpression, GlslLexer.TokenType.VERTICAL_BAR, GlslInclusiveOrNode::new);
    }

    @Nullable
    private static GlslNode parseLogicalAndExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseInclusiveOrExpression, GlslLexer.TokenType.AND_OP, GlslLogicalAndNode::new);
    }

    @Nullable
    private static GlslNode parseLogicalXorExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseLogicalAndExpression, GlslLexer.TokenType.XOR_OP, GlslLogicalXorNode::new);
    }

    @Nullable
    private static GlslNode parseLogicalOrExpression(GlslTokenReader reader) {
        return GlslParser.parseSimpleExpression(reader, GlslParser::parseLogicalXorExpression, GlslLexer.TokenType.OR_OP, GlslLogicalOrNode::new);
    }

    @Nullable
    private static GlslNode parseConditionalExpression(GlslTokenReader reader) {
        GlslNode branch;
        GlslNode first;
        GlslNode logicalOr = GlslParser.parseLogicalOrExpression(reader);
        if (logicalOr == null) {
            return null;
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.QUESTION) && (first = GlslParser.parseExpression(reader)) != null && reader.tryConsume(GlslLexer.TokenType.COLON) && (branch = GlslParser.parseAssignmentExpression(reader)) != null) {
            return new GlslConditionalNode(logicalOr, first, branch);
        }
        reader.setCursor(cursor);
        return logicalOr;
    }

    @Nullable
    private static GlslNode parseAssignmentExpression(GlslTokenReader reader) {
        GlslAssignmentNode.Operand assignmentOperator;
        int cursor = reader.getCursor();
        GlslNode unaryExpression = GlslParser.parseUnaryExpression(reader);
        if (reader.canRead() && (assignmentOperator = reader.peek().type().asAssignmentOperator()) != null) {
            reader.skip();
            GlslNode right = GlslParser.parseAssignmentExpression(reader);
            return new GlslAssignmentNode(unaryExpression, right, assignmentOperator);
        }
        reader.setCursor(cursor);
        return GlslParser.parseConditionalExpression(reader);
    }

    @Nullable
    private static GlslNode parseExpression(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        ArrayList<GlslNode> expressions = new ArrayList<GlslNode>();
        while (reader.canRead()) {
            GlslNode expression = GlslParser.parseAssignmentExpression(reader);
            if (expression == null) {
                reader.setCursor(cursor);
                break;
            }
            expressions.add(expression);
            cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        if (expressions.isEmpty()) {
            return null;
        }
        return GlslNode.compound(expressions);
    }

    @Nullable
    private static GlslNode parseDeclaration(GlslTokenReader reader) {
        List<GlslTypeQualifier> typeQualifier;
        GlslNode initDeclaratorList;
        int cursor = reader.getCursor();
        GlslFunctionHeader functionPrototype = GlslParser.parseFunctionPrototype(reader);
        if (functionPrototype != null) {
            if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                return new GlslFunctionNode(functionPrototype, null);
            }
            reader.setCursor(cursor);
        }
        if ((initDeclaratorList = GlslParser.parseInitDeclaratorList(reader)) != null) {
            if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                return initDeclaratorList;
            }
            reader.setCursor(cursor);
        }
        if (reader.tryConsume(GlslLexer.TokenType.PRECISION)) {
            GlslTypeSpecifier typeSpecifier;
            GlslTypeQualifier.Precision precisionQualifier = GlslParser.parsePrecisionQualifier(reader);
            if (precisionQualifier != null && (typeSpecifier = GlslParser.parseTypeSpecifier(reader)) != null && reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                return new GlslPrecisionNode(precisionQualifier, typeSpecifier);
            }
            reader.setCursor(cursor);
        }
        if ((typeQualifier = GlslParser.parseTypeQualifiers(reader)) == null) {
            return null;
        }
        cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.IDENTIFIER, GlslLexer.TokenType.LEFT_BRACE)) {
            String identifier = reader.peek(-2).value();
            List<GlslStructField> structFields = GlslParser.parseStructDeclarationList(reader);
            if (structFields != null) {
                if (reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
                    GlslSpecifiedType structSpecifier = new GlslSpecifiedType((GlslTypeSpecifier)new GlslStructSpecifier(identifier, structFields), typeQualifier);
                    if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                        return new GlslStructNode(structSpecifier);
                    }
                    if (reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
                        String label = reader.peek(-1).value();
                        if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                            return new GlslNewNode(structSpecifier, label, null);
                        }
                        GlslSpecifiedType arraySpecifier = GlslParser.parseArraySpecifier(reader, structSpecifier);
                        if (arraySpecifier != null && reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                            return new GlslNewNode(arraySpecifier, label, null);
                        }
                    }
                }
                reader.markError("Expected '}'");
            }
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            return new GlslDeclaration(typeQualifier, Collections.emptyList());
        }
        List<String> identifiers = GlslParser.parseIdentifierList(reader);
        if (identifiers == null) {
            reader.markError("Expected ';'");
            reader.setCursor(cursor);
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            reader.markError("Expected ';'");
            reader.setCursor(cursor);
            return null;
        }
        return new GlslDeclaration(typeQualifier, identifiers);
    }

    @Nullable
    private static List<String> parseIdentifierList(GlslTokenReader reader) {
        ArrayList<String> identifiers = new ArrayList<String>();
        int cursor = reader.getCursor();
        while (reader.canRead()) {
            if (!reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
                reader.setCursor(cursor);
                break;
            }
            identifiers.add(reader.peek(-1).value());
            cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
        }
        if (identifiers.isEmpty()) {
            return null;
        }
        return identifiers;
    }

    @Nullable
    private static GlslFunctionHeader parseFunctionPrototype(GlslTokenReader reader) {
        GlslParameterDeclaration parameterDeclaration;
        int cursor = reader.getCursor();
        GlslSpecifiedType fullySpecifiedType = GlslParser.parseFullySpecifiedType(reader);
        if (fullySpecifiedType != null && reader.tryConsume(GlslLexer.TokenType.IDENTIFIER, GlslLexer.TokenType.LEFT_PAREN, GlslLexer.TokenType.RIGHT_PAREN)) {
            String name = reader.peek(-3).value();
            return new GlslFunctionHeader(name, fullySpecifiedType, new ArrayList<GlslParameterDeclaration>());
        }
        reader.setCursor(cursor);
        GlslFunctionHeader functionHeaderWithParameters = GlslParser.parseFunctionHeaderWithParameters(reader);
        if (functionHeaderWithParameters != null) {
            return functionHeaderWithParameters;
        }
        fullySpecifiedType = GlslParser.parseFullySpecifiedType(reader);
        if (fullySpecifiedType != null && reader.tryConsume(GlslLexer.TokenType.IDENTIFIER, GlslLexer.TokenType.LEFT_PAREN)) {
            String name = reader.peek(-2).value();
            GlslParameterDeclaration parameterDeclaration2 = GlslParser.parseParameterDeclaration(reader);
            if (parameterDeclaration2 != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
                return new GlslFunctionHeader(name, fullySpecifiedType, Collections.singletonList(parameterDeclaration2));
            }
        }
        reader.setCursor(cursor);
        functionHeaderWithParameters = GlslParser.parseFunctionHeaderWithParameters(reader);
        if (functionHeaderWithParameters != null && reader.tryConsume(GlslLexer.TokenType.COMMA) && (parameterDeclaration = GlslParser.parseParameterDeclaration(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            List<GlslParameterDeclaration> parameters = functionHeaderWithParameters.getParameters();
            parameters.add(parameterDeclaration);
            return functionHeaderWithParameters;
        }
        reader.setCursor(cursor);
        return null;
    }

    private static List<GlslParameterDeclaration> parseParameterList(GlslTokenReader reader) {
        ArrayList<GlslParameterDeclaration> parameters = new ArrayList<GlslParameterDeclaration>();
        int cursor = reader.getCursor();
        while (reader.canRead()) {
            GlslParameterDeclaration parameterDeclaration = GlslParser.parseParameterDeclaration(reader);
            if (parameterDeclaration == null) {
                reader.setCursor(cursor);
                break;
            }
            parameters.add(parameterDeclaration);
            cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        return parameters;
    }

    @Nullable
    private static GlslFunctionHeader parseFunctionHeaderWithParameters(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslSpecifiedType fullySpecifiedType = GlslParser.parseFullySpecifiedType(reader);
        if (fullySpecifiedType != null && reader.tryConsume(GlslLexer.TokenType.IDENTIFIER, GlslLexer.TokenType.LEFT_PAREN)) {
            String name = reader.peek(-2).value();
            List<GlslParameterDeclaration> parameters = GlslParser.parseParameterList(reader);
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
                return new GlslFunctionHeader(name, fullySpecifiedType, parameters);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslParameterDeclaration parseParameterDeclarator(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslTypeSpecifier typeSpecifier = GlslParser.parseTypeSpecifier(reader);
        if (typeSpecifier == null) {
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
            reader.setCursor(cursor);
            return null;
        }
        String name = reader.peek(-1).value();
        GlslTypeSpecifier arraySpecifier = GlslParser.parseArraySpecifier(reader, typeSpecifier);
        return new GlslParameterDeclaration(name, Objects.requireNonNullElse(arraySpecifier, typeSpecifier));
    }

    @Nullable
    private static GlslParameterDeclaration parseParameterDeclaration(GlslTokenReader reader) {
        GlslTypeSpecifier parameterTypeSpecifier;
        GlslParameterDeclaration parameterDeclarator;
        int cursor = reader.getCursor();
        List<GlslTypeQualifier> typeQualifiers = GlslParser.parseTypeQualifiers(reader);
        if (typeQualifiers != null) {
            parameterDeclarator = GlslParser.parseParameterDeclarator(reader);
            if (parameterDeclarator != null) {
                return parameterDeclarator.setQualifiers(typeQualifiers);
            }
            parameterTypeSpecifier = GlslParser.parseTypeSpecifier(reader);
            if (parameterTypeSpecifier != null) {
                return new GlslParameterDeclaration(null, new GlslSpecifiedType(parameterTypeSpecifier, typeQualifiers));
            }
        }
        reader.setCursor(cursor);
        parameterDeclarator = GlslParser.parseParameterDeclarator(reader);
        if (parameterDeclarator != null) {
            return parameterDeclarator;
        }
        parameterTypeSpecifier = GlslParser.parseTypeSpecifier(reader);
        if (parameterTypeSpecifier != null) {
            return new GlslParameterDeclaration(null, parameterTypeSpecifier);
        }
        return null;
    }

    @Nullable
    private static GlslNode parseInitDeclaratorList(GlslTokenReader reader) {
        GlslNode singleDeclaration;
        ArrayList<GlslNode> initDeclaratorList = new ArrayList<GlslNode>();
        while (reader.canRead() && (singleDeclaration = GlslParser.parseSingleDeclaration(reader)) != null) {
            initDeclaratorList.add(singleDeclaration);
        }
        if (initDeclaratorList.isEmpty()) {
            return null;
        }
        return GlslNode.compound(initDeclaratorList);
    }

    @Nullable
    private static GlslNode parseSingleDeclaration(GlslTokenReader reader) {
        GlslNode initializer;
        int cursor = reader.getCursor();
        GlslSpecifiedType fullySpecifiedType = GlslParser.parseFullySpecifiedType(reader);
        if (fullySpecifiedType == null) {
            reader.setCursor(cursor);
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
            if (fullySpecifiedType.getSpecifier().isStruct()) {
                return new GlslStructNode(fullySpecifiedType);
            }
            return new GlslNewNode(fullySpecifiedType, null, null);
        }
        cursor = reader.getCursor();
        String name = reader.peek(-1).value();
        GlslSpecifiedType arraySpecifier = GlslParser.parseArraySpecifier(reader, fullySpecifiedType);
        if (arraySpecifier != null) {
            if (!reader.tryConsume(GlslLexer.TokenType.EQUAL)) {
                return new GlslNewNode(arraySpecifier, name, null);
            }
            initializer = GlslParser.parseInitializer(reader);
            if (initializer != null) {
                return new GlslNewNode(arraySpecifier, name, initializer);
            }
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.EQUAL) && (initializer = GlslParser.parseInitializer(reader)) != null) {
            return new GlslNewNode(fullySpecifiedType, name, initializer);
        }
        reader.setCursor(cursor);
        return new GlslNewNode(fullySpecifiedType, name, null);
    }

    @Nullable
    private static GlslSpecifiedType parseFullySpecifiedType(GlslTokenReader reader) {
        GlslTypeSpecifier typeSpecifier = GlslParser.parseTypeSpecifier(reader);
        if (typeSpecifier != null) {
            return new GlslSpecifiedType(typeSpecifier);
        }
        int cursor = reader.getCursor();
        List<GlslTypeQualifier> typeQualifiers = GlslParser.parseTypeQualifiers(reader);
        if (typeQualifiers != null && (typeSpecifier = GlslParser.parseTypeSpecifier(reader)) != null) {
            return new GlslSpecifiedType(typeSpecifier, typeQualifiers);
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseInvariantQualifier(GlslTokenReader reader) {
        return null;
    }

    @Nullable
    private static GlslTypeQualifier.Interpolation parseInterpolationQualifier(GlslTokenReader reader) {
        GlslTypeQualifier.Interpolation interpolationQualifier;
        GlslLexer.TokenType type = reader.peekType(0);
        GlslTypeQualifier.Interpolation interpolation = interpolationQualifier = type != null ? type.asInterpolationQualifier() : null;
        if (interpolationQualifier != null) {
            reader.skip();
            return interpolationQualifier;
        }
        return null;
    }

    @Nullable
    private static GlslTypeQualifier parseLayoutQualifier(GlslTokenReader reader) {
        if (!reader.tryConsume(GlslLexer.TokenType.LAYOUT, GlslLexer.TokenType.LEFT_PAREN)) {
            return null;
        }
        int layoutCursor = reader.getCursor();
        ArrayList<GlslTypeQualifier.LayoutId> layoutQualifierIds = new ArrayList<GlslTypeQualifier.LayoutId>();
        while (reader.canRead()) {
            GlslTypeQualifier.LayoutId qualifier = null;
            if (reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
                String identifier = reader.peek(-1).value();
                GlslNode expression = null;
                int cursor = reader.getCursor();
                if (reader.tryConsume(GlslLexer.TokenType.EQUAL) && (expression = GlslParser.parseConditionalExpression(reader)) == null) {
                    reader.setCursor(cursor);
                }
                qualifier = GlslTypeQualifier.identifierLayoutId(identifier, expression);
            }
            if (qualifier == null && reader.tryConsume(GlslLexer.TokenType.SHARED)) {
                qualifier = GlslTypeQualifier.sharedLayoutId();
            }
            if (qualifier == null) break;
            layoutQualifierIds.add(qualifier);
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            reader.markError("Expected ')'");
            reader.setCursor(layoutCursor);
            return null;
        }
        return GlslTypeQualifier.layout(layoutQualifierIds);
    }

    @Nullable
    private static List<GlslTypeQualifier> parseTypeQualifiers(GlslTokenReader reader) {
        ArrayList<GlslTypeQualifier> typeQualifiers = new ArrayList<GlslTypeQualifier>();
        while (reader.canRead()) {
            GlslTypeQualifier storageQualifier = GlslParser.parseStorageQualifier(reader);
            if (storageQualifier != null) {
                typeQualifiers.add(storageQualifier);
                continue;
            }
            GlslTypeQualifier layoutQualifier = GlslParser.parseLayoutQualifier(reader);
            if (layoutQualifier != null) {
                typeQualifiers.add(layoutQualifier);
                continue;
            }
            GlslTypeQualifier.Precision precisionQualifier = GlslParser.parsePrecisionQualifier(reader);
            if (precisionQualifier != null) {
                typeQualifiers.add(precisionQualifier);
                continue;
            }
            GlslTypeQualifier.Interpolation interpolationQualifier = GlslParser.parseInterpolationQualifier(reader);
            if (interpolationQualifier != null) {
                typeQualifiers.add(interpolationQualifier);
                continue;
            }
            if (reader.tryConsume(GlslLexer.TokenType.INVARIANT)) {
                typeQualifiers.add(GlslTypeQualifier.Invariant.INVARIANT);
                continue;
            }
            if (!reader.tryConsume(GlslLexer.TokenType.PRECISE)) break;
            typeQualifiers.add(GlslTypeQualifier.Precise.PRECISE);
        }
        return typeQualifiers.isEmpty() ? null : typeQualifiers;
    }

    @Nullable
    private static GlslTypeQualifier parseStorageQualifier(GlslTokenReader reader) {
        GlslTypeQualifier.StorageType storageQualifier = reader.peek().type().asStorageQualifier();
        if (storageQualifier != null) {
            reader.skip();
            return storageQualifier;
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.SUBROUTINE)) {
            if (reader.tryConsume(GlslLexer.TokenType.LEFT_PAREN)) {
                ArrayList<String> typeNames = new ArrayList<String>();
                while (reader.canRead() && reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
                    typeNames.add(reader.peek(-1).value());
                    if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
                }
                if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
                    reader.markError("Expected ')'");
                    reader.setCursor(cursor);
                    return null;
                }
                return GlslTypeQualifier.storage((String[])typeNames.toArray(String[]::new));
            }
            return GlslTypeQualifier.storage(new String[0]);
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseTypeNameList(GlslTokenReader reader) {
        return null;
    }

    @Nullable
    private static GlslTypeSpecifier parseTypeSpecifier(GlslTokenReader reader) {
        GlslTypeSpecifier typeSpecifier;
        if (!reader.canRead()) {
            return null;
        }
        GlslLexer.Token token = reader.peek();
        GlslTypeSpecifier.BuiltinType type = token.type().asBuiltinType();
        if (type != null) {
            typeSpecifier = type;
            reader.skip();
        } else {
            GlslStructSpecifier structSpecifier = GlslParser.parseStructSpecifier(reader);
            if (structSpecifier != null) {
                typeSpecifier = structSpecifier;
            } else if (token.type() == GlslLexer.TokenType.IDENTIFIER) {
                reader.skip();
                typeSpecifier = GlslTypeSpecifier.named(token.value());
            } else {
                return null;
            }
        }
        GlslTypeSpecifier arraySpecifier = GlslParser.parseArraySpecifier(reader, typeSpecifier);
        if (arraySpecifier != null) {
            return arraySpecifier;
        }
        return typeSpecifier;
    }

    @Nullable
    private static GlslSpecifiedType parseArraySpecifier(GlslTokenReader reader, GlslSpecifiedType type) {
        GlslTypeSpecifier arraySpecifier = GlslParser.parseArraySpecifier(reader, type.getSpecifier());
        if (arraySpecifier != null) {
            return new GlslSpecifiedType(arraySpecifier, type.getQualifiers());
        }
        return null;
    }

    @Nullable
    private static GlslTypeSpecifier parseArraySpecifier(GlslTokenReader reader, GlslTypeSpecifier type) {
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.LEFT_BRACKET)) {
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACKET)) {
                return GlslTypeSpecifier.array(type, null);
            }
            GlslNode conditionalExpression = GlslParser.parseConditionalExpression(reader);
            if (conditionalExpression != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACKET)) {
                return GlslTypeSpecifier.array(type, conditionalExpression);
            }
            reader.setCursor(cursor);
        }
        return null;
    }

    @Nullable
    private static GlslTypeQualifier.Precision parsePrecisionQualifier(GlslTokenReader reader) {
        GlslTypeQualifier.Precision precisionQualifier;
        GlslLexer.TokenType type = reader.peekType(0);
        GlslTypeQualifier.Precision precision = precisionQualifier = type != null ? type.asPrecisionQualifier() : null;
        if (precisionQualifier != null) {
            reader.skip();
            return precisionQualifier;
        }
        return null;
    }

    @Nullable
    private static GlslStructSpecifier parseStructSpecifier(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        if (!reader.tryConsume(GlslLexer.TokenType.STRUCT)) {
            return null;
        }
        String name = null;
        if (reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
            name = reader.peek(-1).value();
        }
        if (!reader.tryConsume(GlslLexer.TokenType.LEFT_BRACE)) {
            reader.setCursor(cursor);
            return null;
        }
        List<GlslStructField> fields = GlslParser.parseStructDeclarationList(reader);
        if (fields == null) {
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
            reader.markError("Expected '}'");
            reader.setCursor(cursor);
            return null;
        }
        return new GlslStructSpecifier(name, fields);
    }

    @Nullable
    private static List<GlslStructField> parseStructDeclarationList(GlslTokenReader reader) {
        List<GlslStructField> fields;
        ArrayList<GlslStructField> declarations = new ArrayList<GlslStructField>();
        while (reader.canRead() && (fields = GlslParser.parseStructDeclaration(reader)) != null) {
            declarations.addAll(fields);
        }
        if (declarations.isEmpty()) {
            return null;
        }
        return declarations;
    }

    @Nullable
    private static List<GlslStructField> parseStructDeclaration(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslSpecifiedType fullySpecifiedType = GlslParser.parseFullySpecifiedType(reader);
        if (fullySpecifiedType == null) {
            return null;
        }
        List<GlslStructField> structDeclaration = GlslParser.parseStructDeclaratorList(fullySpecifiedType, reader);
        if (structDeclaration == null) {
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            reader.markError("Expected ';'");
            reader.setCursor(cursor);
            return null;
        }
        return structDeclaration;
    }

    @Nullable
    private static List<GlslStructField> parseStructDeclaratorList(GlslSpecifiedType type, GlslTokenReader reader) {
        int cursor = reader.getCursor();
        ArrayList<GlslStructField> fields = new ArrayList<GlslStructField>();
        while (reader.canRead()) {
            GlslStructField field = GlslParser.parseStructDeclarator(type, reader);
            if (field == null) {
                reader.setCursor(cursor);
                break;
            }
            fields.add(field);
            cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        if (fields.isEmpty()) {
            return null;
        }
        return fields;
    }

    @Nullable
    private static GlslStructField parseStructDeclarator(GlslSpecifiedType type, GlslTokenReader reader) {
        if (!reader.tryConsume(GlslLexer.TokenType.IDENTIFIER)) {
            return null;
        }
        String name = reader.peek(-1).value();
        GlslSpecifiedType arraySpecifier = GlslParser.parseArraySpecifier(reader, type);
        return new GlslStructField(Objects.requireNonNullElse(arraySpecifier, type), name);
    }

    @Nullable
    private static GlslNode parseInitializer(GlslTokenReader reader) {
        GlslNode assignmentExpression = GlslParser.parseAssignmentExpression(reader);
        if (assignmentExpression != null) {
            return assignmentExpression;
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.LEFT_BRACE)) {
            List<GlslNode> initializerList = GlslParser.parseInitializerList(reader);
            reader.tryConsume(GlslLexer.TokenType.COMMA);
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
                return GlslNode.compound(initializerList);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    private static List<GlslNode> parseInitializerList(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        ArrayList<GlslNode> initializers = new ArrayList<GlslNode>();
        while (reader.canRead()) {
            GlslNode statement = GlslParser.parseStatement(reader);
            if (statement == null) {
                reader.setCursor(cursor);
                break;
            }
            initializers.add(statement);
            cursor = reader.getCursor();
            if (reader.tryConsume(GlslLexer.TokenType.COMMA)) continue;
            break;
        }
        return initializers;
    }

    @Nullable
    private static GlslNode parseStatement(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslNode compoundStatement = GlslParser.parseCompoundStatement(reader);
        if (compoundStatement != null) {
            reader.markNode(cursor, compoundStatement);
            return compoundStatement;
        }
        reader.setCursor(cursor);
        GlslNode simpleStatement = GlslParser.parseSimpleStatement(reader);
        if (simpleStatement != null) {
            reader.markNode(cursor, simpleStatement);
            return simpleStatement;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseSimpleStatement(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslNode statement = GlslParser.parseDeclaration(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseExpressionStatement(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseSelectionStatement(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseSwitchStatement(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseCaseLabel(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseIterationStatement(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        statement = GlslParser.parseJumpStatement(reader);
        if (statement != null) {
            return statement;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseCompoundStatement(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        if (!reader.tryConsume(GlslLexer.TokenType.LEFT_BRACE)) {
            reader.setCursor(cursor);
            return null;
        }
        if (reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
            return GlslEmptyNode.INSTANCE;
        }
        List<GlslNode> statements = GlslParser.parseStatementList(reader);
        if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
            reader.setCursor(cursor);
            return null;
        }
        return GlslNode.compound(statements);
    }

    @Nullable
    private static GlslNode parseStatementNoNewScope(GlslTokenReader reader) {
        GlslNode statementNoNewScope = GlslParser.parseCompoundStatementNoNewScope(reader);
        if (statementNoNewScope != null) {
            return statementNoNewScope;
        }
        return GlslParser.parseSimpleStatement(reader);
    }

    @Nullable
    private static GlslNode parseCompoundStatementNoNewScope(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        if (!reader.tryConsume(GlslLexer.TokenType.LEFT_BRACE)) {
            return null;
        }
        List<GlslNode> statements = GlslParser.parseStatementList(reader);
        if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
            reader.markError("Expected '}'");
            reader.setCursor(cursor);
            return null;
        }
        return GlslNode.compound(statements);
    }

    private static List<GlslNode> parseStatementList(GlslTokenReader reader) {
        GlslNode statement;
        ArrayList<GlslNode> statements = new ArrayList<GlslNode>();
        while (reader.canRead() && (statement = GlslParser.parseStatement(reader)) != null) {
            statements.add(statement);
        }
        return statements;
    }

    @Nullable
    private static GlslNode parseExpressionStatement(GlslTokenReader reader) {
        if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            return GlslEmptyNode.INSTANCE;
        }
        int cursor = reader.getCursor();
        GlslNode condition = GlslParser.parseCondition(reader);
        if (condition != null && reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            return condition;
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseSelectionStatement(GlslTokenReader reader) {
        if (!reader.tryConsume(GlslLexer.TokenType.IF)) {
            return null;
        }
        int cursor = reader.getCursor();
        if (!reader.tryConsume(GlslLexer.TokenType.LEFT_PAREN)) {
            reader.markError("Expected '('");
            reader.setCursor(cursor);
            return null;
        }
        GlslNode expression = GlslParser.parseCondition(reader);
        if (expression == null) {
            reader.setCursor(cursor);
            return null;
        }
        if (!reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN)) {
            reader.markError("Expected ')'");
            reader.setCursor(cursor);
            return null;
        }
        GlslNode statement = GlslParser.parseStatement(reader);
        if (statement == null) {
            reader.setCursor(cursor);
            return null;
        }
        cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.ELSE)) {
            GlslNode otherStatement = GlslParser.parseStatement(reader);
            if (otherStatement != null) {
                return new GlslSelectionNode(expression, statement, otherStatement);
            }
            reader.setCursor(cursor);
            return null;
        }
        reader.setCursor(cursor);
        return new GlslSelectionNode(expression, statement, GlslEmptyNode.INSTANCE);
    }

    @Nullable
    private static GlslNode parseCondition(GlslTokenReader reader) {
        GlslNode expression = GlslParser.parseExpression(reader);
        if (expression != null) {
            return expression;
        }
        int cursor = reader.getCursor();
        GlslSpecifiedType type = GlslParser.parseFullySpecifiedType(reader);
        if (type != null && reader.tryConsume(GlslLexer.TokenType.IDENTIFIER, GlslLexer.TokenType.EQUAL)) {
            String name = reader.peek(-2).value();
            GlslNode initializer = GlslParser.parseInitializer(reader);
            if (initializer != null) {
                return new GlslNewNode(type, name, initializer);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseSwitchStatement(GlslTokenReader reader) {
        GlslNode condition;
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.SWITCH, GlslLexer.TokenType.LEFT_PAREN) && (condition = GlslParser.parseCondition(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN, GlslLexer.TokenType.LEFT_BRACE)) {
            List<GlslNode> statements = GlslParser.parseStatementList(reader);
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_BRACE)) {
                return new GlslSwitchNode(condition, statements);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslCaseLabelNode parseCaseLabel(GlslTokenReader reader) {
        GlslNode condition;
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.CASE) && (condition = GlslParser.parseCondition(reader)) != null && reader.tryConsume(GlslLexer.TokenType.COLON)) {
            return new GlslCaseLabelNode(condition);
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.DEFAULT, GlslLexer.TokenType.COLON)) {
            return new GlslCaseLabelNode(null);
        }
        return null;
    }

    @Nullable
    private static GlslNode parseIterationStatement(GlslTokenReader reader) {
        GlslNode init;
        GlslNode condition;
        GlslNode body;
        GlslNode body2;
        GlslNode condition2;
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.WHILE, GlslLexer.TokenType.LEFT_PAREN) && (condition2 = GlslParser.parseCondition(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN) && (body2 = GlslParser.parseStatementNoNewScope(reader)) != null) {
            return new WhileLoopNode(condition2, body2, WhileLoopNode.Type.WHILE);
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.DO) && (body = GlslParser.parseStatement(reader)) != null && reader.tryConsume(GlslLexer.TokenType.WHILE, GlslLexer.TokenType.LEFT_PAREN) && (condition = GlslParser.parseCondition(reader)) != null && reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN, GlslLexer.TokenType.SEMICOLON)) {
            return new WhileLoopNode(condition, body, WhileLoopNode.Type.DO);
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.FOR, GlslLexer.TokenType.LEFT_PAREN) && (init = GlslParser.parseForInitStatement(reader)) != null && (condition = GlslParser.parseConditionopt(reader)) != null && reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
            GlslNode body3;
            GlslNode increment = GlslParser.parseCondition(reader);
            if (reader.tryConsume(GlslLexer.TokenType.RIGHT_PAREN) && (body3 = GlslParser.parseStatementNoNewScope(reader)) != null) {
                return new ForLoopNode(init, condition, increment, body3);
            }
        }
        reader.setCursor(cursor);
        return null;
    }

    @Nullable
    private static GlslNode parseForInitStatement(GlslTokenReader reader) {
        GlslNode expressionStatement = GlslParser.parseExpressionStatement(reader);
        if (expressionStatement != null) {
            return expressionStatement;
        }
        return GlslParser.parseDeclaration(reader);
    }

    private static GlslNode parseConditionopt(GlslTokenReader reader) {
        GlslNode condition = GlslParser.parseCondition(reader);
        return condition != null ? condition : GlslEmptyNode.INSTANCE;
    }

    @Nullable
    private static GlslNode parseJumpStatement(GlslTokenReader reader) {
        if (reader.tryConsume(GlslLexer.TokenType.CONTINUE, GlslLexer.TokenType.SEMICOLON)) {
            return JumpNode.CONTINUE;
        }
        if (reader.tryConsume(GlslLexer.TokenType.BREAK, GlslLexer.TokenType.SEMICOLON)) {
            return JumpNode.BREAK;
        }
        int cursor = reader.getCursor();
        if (reader.tryConsume(GlslLexer.TokenType.RETURN)) {
            if (reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                return new GlslReturnNode(null);
            }
            GlslNode condition = GlslParser.parseCondition(reader);
            if (condition != null && reader.tryConsume(GlslLexer.TokenType.SEMICOLON)) {
                return new GlslReturnNode(condition);
            }
        }
        reader.setCursor(cursor);
        if (reader.tryConsume(GlslLexer.TokenType.DISCARD, GlslLexer.TokenType.SEMICOLON)) {
            return JumpNode.DISCARD;
        }
        return null;
    }

    @Nullable
    private static GlslFunctionNode parseFunctionDefinition(GlslTokenReader reader) {
        int cursor = reader.getCursor();
        GlslFunctionHeader functionPrototype = GlslParser.parseFunctionPrototype(reader);
        if (functionPrototype == null) {
            return null;
        }
        GlslNode statement = GlslParser.parseCompoundStatementNoNewScope(reader);
        if (statement == null) {
            reader.setCursor(cursor);
            return null;
        }
        return new GlslFunctionNode(functionPrototype, statement);
    }
}

