/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VanillaLightRenderer
implements NativeResource {
    private final VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);

    public VanillaLightRenderer() {
        this.vbo.bind();
        this.vbo.upload(VanillaLightRenderer.createMesh());
        VertexBuffer.unbind();
    }

    private static MeshData createMesh() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        LightTypeRenderer.createQuad((VertexConsumer)bufferBuilder);
        return bufferBuilder.buildOrThrow();
    }

    public void render(LightRenderer lightRenderer, ClientLevel level) {
        VeilRenderSystem.setShader(VeilShaders.LIGHT_VANILLA_LIGHTMAP);
        lightRenderer.applyShader();
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            shader.setFloat("LightShading" + direction.ordinal(), level.getShade(direction, true));
        }
        this.vbo.bind();
        this.vbo.draw();
        VertexBuffer.unbind();
    }

    @Override
    public void free() {
        this.vbo.close();
    }
}

