/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.deferred.light.renderer.IndirectLightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.VeilShaders;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public class IndirectPointLightRenderer
extends IndirectLightRenderer<PointLight> {
    public IndirectPointLightRenderer() {
        super(28, 4, 0, 6);
    }

    @Override
    protected MeshData createMesh() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        LightTypeRenderer.createInvertedCube((VertexConsumer)bufferBuilder);
        float sqrt2 = (float)Math.sqrt(2.0);
        bufferBuilder.addVertex(-sqrt2, -sqrt2, 0.0f);
        bufferBuilder.addVertex(sqrt2, -sqrt2, 0.0f);
        bufferBuilder.addVertex(-sqrt2, sqrt2, 0.0f);
        bufferBuilder.addVertex(sqrt2, sqrt2, 0.0f);
        return bufferBuilder.buildOrThrow();
    }

    @Override
    protected void setupBufferState() {
        GL20C.glEnableVertexAttribArray((int)1);
        GL20C.glEnableVertexAttribArray((int)2);
        GL20C.glEnableVertexAttribArray((int)3);
        GL20C.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)this.lightSize, (long)0L);
        GL20C.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)this.lightSize, (long)12L);
        GL20C.glVertexAttribPointer((int)3, (int)1, (int)5126, (boolean)false, (int)this.lightSize, (long)24L);
        GL33C.glVertexAttribDivisor((int)1, (int)1);
        GL33C.glVertexAttribDivisor((int)2, (int)1);
        GL33C.glVertexAttribDivisor((int)3, (int)1);
    }

    @Override
    protected void setupRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<PointLight> lights) {
        VeilRenderSystem.setShader(VeilShaders.LIGHT_POINT);
    }

    @Override
    protected void clearRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<PointLight> lights) {
    }
}

