/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class LightEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.translatable((String)"editor.veil.light.title");
    private static final Component ADD = Component.translatable((String)"editor.veil.light.button.add");
    private static final Component REMOVE = Component.translatable((String)"editor.veil.light.button.remove");
    private static final Component REMOVE_ALL = Component.translatable((String)"editor.veil.light.button.remove_all");
    private static final Component REMOVE_ALL_DESC = Component.translatable((String)"editor.veil.light.button.remove_all.desc");
    private static final Component SET_POSITION = Component.translatable((String)"editor.veil.light.button.set_position");
    private static final Component ATTRIBUTES = Component.translatable((String)"editor.veil.light.attributes");
    private static final Component ENABLE_AO = Component.translatable((String)"editor.veil.light.toggle.ao");
    private final List<ResourceKey<LightTypeRegistry.LightType<?>>> lightTypes = new ArrayList();
    private ResourceKey<LightTypeRegistry.LightType<?>> selectedTab;
    private final ImBoolean enableAmbientOcclusion = new ImBoolean();

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    @Nullable
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return Minecraft.getInstance().level != null && LightTypeRegistry.REGISTRY.size() > 0;
    }

    @Override
    protected void renderComponents() {
        LightTypeRegistry.LightType lightType;
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();
        if (this.selectedTab == null || !LightTypeRegistry.REGISTRY.containsKey(this.selectedTab)) {
            this.selectedTab = this.lightTypes.get(0);
        }
        ImGui.beginDisabled((lightType = (LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.get(this.selectedTab)) == null || lightType.debugLightFactory() == null);
        if (ImGui.button(ADD.getString()) && lightType != null && lightType.debugLightFactory() != null) {
            LightTypeRegistry.DebugLightFactory factory = lightType.debugLightFactory();
            Minecraft minecraft = Minecraft.getInstance();
            Camera mainCamera = minecraft.gameRenderer.getMainCamera();
            lightRenderer.addLight(factory.createDebugLight(minecraft.level, mainCamera));
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered(0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.translatable((String)"editor.veil.light.button.add.desc", (Object[])new Object[]{this.selectedTab.location().toString()}));
        }
        ImGui.sameLine();
        ImGui.beginDisabled(lightType == null);
        if (ImGui.button(REMOVE.getString()) && lightType != null) {
            for (Light light : lightRenderer.getLights(lightType)) {
                lightRenderer.removeLight(light);
            }
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered(0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.translatable((String)"editor.veil.light.button.remove.desc", (Object[])new Object[]{this.selectedTab.location().toString()}));
        }
        ImGui.sameLine();
        if (ImGui.button(REMOVE_ALL.getString())) {
            lightRenderer.free();
        }
        if (ImGui.isItemHovered(0)) {
            VeilImGuiUtil.setTooltip((FormattedText)REMOVE_ALL_DESC);
        }
        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox(ENABLE_AO.getString(), this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }
        ImGui.beginTabBar("##lights");
        for (ResourceKey resourceKey : this.lightTypes) {
            ResourceLocation id = resourceKey.location();
            if (!ImGui.beginTabItem(id.toString())) continue;
            this.selectedTab = resourceKey;
            List lights = lightRenderer.getLights((LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.get(resourceKey));
            for (int i = 0; i < lights.size(); ++i) {
                ImGui.pushID("light" + i);
                LightEditor.renderLightComponents((Light)lights.get(i));
                ImGui.popID();
            }
            ImGui.endTabItem();
        }
        ImGui.endTabBar();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.lightTypes.clear();
        this.lightTypes.addAll(LightTypeRegistry.REGISTRY.registryKeySet().stream().sorted(Comparator.comparing(ResourceKey::location)).toList());
    }

    private static void renderLightComponents(Light light) {
        ImBoolean visible = new ImBoolean(true);
        ImGui.pushID(light.hashCode());
        if (ImGui.collapsingHeader(DebugEntityNameGenerator.getEntityName((UUID)new UUID(light.hashCode(), 0L)), visible)) {
            LightEditor.renderLightAttributeComponents(light);
        }
        ImGui.popID();
        if (!visible.get()) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light) {
        Vector3fc lightColor = light.getColor();
        ImFloat editBrightness = new ImFloat(light.getBrightness());
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};
        ImGui.indent();
        if (ImGui.dragScalar("brightness", 8, editBrightness, 0.02f)) {
            light.setBrightness(editBrightness.get());
        }
        if (ImGui.colorEdit3("color", editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        if (ImGui.button(SET_POSITION.getString())) {
            light.setTo(Minecraft.getInstance().gameRenderer.getMainCamera());
        }
        ImGui.newLine();
        VeilImGuiUtil.component((FormattedText)ATTRIBUTES);
        if (light instanceof EditorAttributeProvider) {
            EditorAttributeProvider editorAttributeProvider = (EditorAttributeProvider)((Object)light);
            editorAttributeProvider.renderImGuiAttributes();
        }
        ImGui.unindent();
    }
}

