/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import foundry.veil.Veil;
import foundry.veil.api.quasar.data.module.ModuleType;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.data.module.collision.CollisionSubEmitterData;
import foundry.veil.api.quasar.data.module.collision.DieOnCollisionModuleData;
import foundry.veil.api.quasar.data.module.force.DragForceData;
import foundry.veil.api.quasar.data.module.force.GravityForceData;
import foundry.veil.api.quasar.data.module.force.PointAttractorForceData;
import foundry.veil.api.quasar.data.module.force.PointForceData;
import foundry.veil.api.quasar.data.module.force.VectorFieldForceData;
import foundry.veil.api.quasar.data.module.force.VortexForceData;
import foundry.veil.api.quasar.data.module.force.WindForceData;
import foundry.veil.api.quasar.data.module.init.BlockParticleModuleData;
import foundry.veil.api.quasar.data.module.init.InitSizeParticleModuleData;
import foundry.veil.api.quasar.data.module.init.InitSubEmitterModuleData;
import foundry.veil.api.quasar.data.module.init.InitialVelocityModuleData;
import foundry.veil.api.quasar.data.module.init.LightModuleData;
import foundry.veil.api.quasar.data.module.render.ColorParticleModuleData;
import foundry.veil.api.quasar.data.module.render.TrailParticleModuleData;
import foundry.veil.api.quasar.data.module.update.TickSizeParticleModuleData;
import foundry.veil.api.quasar.data.module.update.TickSubEmitterModuleData;
import foundry.veil.api.quasar.emitters.module.init.InitRandomRotationModuleData;
import foundry.veil.api.util.CodecUtil;
import foundry.veil.platform.registry.RegistrationProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class ParticleModuleTypeRegistry {
    public static final ResourceKey<Registry<ModuleType<?>>> INIT_MODULES_KEY = ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath("quasar/module_type/init"));
    public static final ResourceKey<Registry<ModuleType<?>>> UPDATE_MODULES_KEY = ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath("quasar/module_type/update"));
    public static final ResourceKey<Registry<ModuleType<?>>> RENDER_MODULES_KEY = ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath("quasar/module_type/render"));
    private static final RegistrationProvider<ModuleType<?>> INIT_MODULES_PROVIDER = RegistrationProvider.get(INIT_MODULES_KEY, "veil");
    private static final RegistrationProvider<ModuleType<?>> UPDATE_MODULES_PROVIDER = RegistrationProvider.get(UPDATE_MODULES_KEY, "veil");
    private static final RegistrationProvider<ModuleType<?>> RENDER_MODULES_PROVIDER = RegistrationProvider.get(RENDER_MODULES_KEY, "veil");
    public static final Registry<ModuleType<?>> INIT_MODULES_REGISTRY = INIT_MODULES_PROVIDER.asVanillaRegistry();
    public static final Registry<ModuleType<?>> UPDATE_MODULES_REGISTRY = UPDATE_MODULES_PROVIDER.asVanillaRegistry();
    public static final Registry<ModuleType<?>> RENDER_MODULES_REGISTRY = RENDER_MODULES_PROVIDER.asVanillaRegistry();
    public static final Codec<ModuleType<?>> INIT_MODULE_CODEC = CodecUtil.registryOrLegacyCodec(INIT_MODULES_REGISTRY);
    public static final Codec<ModuleType<?>> UPDATE_MODULE_CODEC = CodecUtil.registryOrLegacyCodec(UPDATE_MODULES_REGISTRY);
    public static final Codec<ModuleType<?>> RENDER_MODULE_CODEC = CodecUtil.registryOrLegacyCodec(RENDER_MODULES_REGISTRY);
    public static final ModuleType<InitialVelocityModuleData> INITIAL_VELOCITY = ParticleModuleTypeRegistry.registerInitModule("initial_velocity", InitialVelocityModuleData.CODEC);
    public static final ModuleType<ColorParticleModuleData> INIT_COLOR = ParticleModuleTypeRegistry.registerInitModule("init_color", ColorParticleModuleData.CODEC);
    public static final ModuleType<InitSubEmitterModuleData> INIT_SUB_EMITTER = ParticleModuleTypeRegistry.registerInitModule("init_sub_emitter", InitSubEmitterModuleData.CODEC);
    public static final ModuleType<InitSizeParticleModuleData> INIT_SIZE = ParticleModuleTypeRegistry.registerInitModule("init_size", InitSizeParticleModuleData.CODEC);
    public static final ModuleType<InitRandomRotationModuleData> INIT_RANDOM_ROTATION = ParticleModuleTypeRegistry.registerInitModule("init_random_rotation", InitRandomRotationModuleData.CODEC);
    public static final ModuleType<LightModuleData> LIGHT = ParticleModuleTypeRegistry.registerInitModule("light", LightModuleData.CODEC);
    public static final ModuleType<BlockParticleModuleData> BLOCK_PARTICLE = ParticleModuleTypeRegistry.registerInitModule("block", BlockParticleModuleData.CODEC);
    public static final ModuleType<TrailParticleModuleData> TRAIL = ParticleModuleTypeRegistry.registerRenderModule("trail", TrailParticleModuleData.CODEC);
    public static final ModuleType<ColorParticleModuleData> COLOR = ParticleModuleTypeRegistry.registerRenderModule("color", ColorParticleModuleData.CODEC);
    public static final ModuleType<TickSizeParticleModuleData> TICK_SIZE = ParticleModuleTypeRegistry.registerUpdateModule("tick_size", TickSizeParticleModuleData.CODEC);
    public static final ModuleType<TickSubEmitterModuleData> TICK_SUB_EMITTER = ParticleModuleTypeRegistry.registerUpdateModule("tick_sub_emitter", TickSubEmitterModuleData.CODEC);
    public static final ModuleType<DieOnCollisionModuleData> DIE_ON_COLLISION = ParticleModuleTypeRegistry.registerUpdateModule("die_on_collision", DieOnCollisionModuleData.CODEC);
    public static final ModuleType<CollisionSubEmitterData> SUB_EMITTER_COLLISION = ParticleModuleTypeRegistry.registerUpdateModule("sub_emitter_collision", CollisionSubEmitterData.CODEC);
    public static final ModuleType<GravityForceData> GRAVITY = ParticleModuleTypeRegistry.registerUpdateModule("gravity", GravityForceData.CODEC);
    public static final ModuleType<VortexForceData> VORTEX = ParticleModuleTypeRegistry.registerUpdateModule("vortex", VortexForceData.CODEC);
    public static final ModuleType<PointAttractorForceData> POINT_ATTRACTOR = ParticleModuleTypeRegistry.registerUpdateModule("point_attractor", PointAttractorForceData.CODEC);
    public static final ModuleType<VectorFieldForceData> VECTOR_FIELD = ParticleModuleTypeRegistry.registerUpdateModule("vector_field", VectorFieldForceData.CODEC);
    public static final ModuleType<DragForceData> DRAG = ParticleModuleTypeRegistry.registerUpdateModule("drag", DragForceData.CODEC);
    public static final ModuleType<WindForceData> WIND = ParticleModuleTypeRegistry.registerUpdateModule("wind", WindForceData.CODEC);
    public static final ModuleType<PointForceData> POINT = ParticleModuleTypeRegistry.registerUpdateModule("point_force", PointForceData.CODEC);

    @ApiStatus.Internal
    public static void bootstrap() {
    }

    private static <T extends ParticleModuleData> ModuleType<T> registerUpdateModule(String name, MapCodec<T> codec) {
        ModuleType type = () -> codec;
        UPDATE_MODULES_PROVIDER.register(name, () -> type);
        return type;
    }

    private static <T extends ParticleModuleData> ModuleType<T> registerRenderModule(String name, MapCodec<T> codec) {
        ModuleType type = () -> codec;
        RENDER_MODULES_PROVIDER.register(name, () -> type);
        return type;
    }

    private static <T extends ParticleModuleData> ModuleType<T> registerInitModule(String name, MapCodec<T> codec) {
        ModuleType type = () -> codec;
        INIT_MODULES_PROVIDER.register(name, () -> type);
        return type;
    }
}

