/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.FramebufferSource;
import foundry.veil.api.client.render.shader.texture.LocationSource;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public sealed interface ShaderTextureSource
permits LocationSource, FramebufferSource {
    public static final Codec<Type> TYPE_CODEC = Codec.STRING.flatXmap(name -> Optional.ofNullable(Type.byName(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown post texture source: " + name)), object -> DataResult.success((Object)object.name().toLowerCase(Locale.ROOT)));
    public static final Codec<ShaderTextureSource> CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)TYPE_CODEC.dispatch(ShaderTextureSource::getType, Type::getCodec)).xmap(either -> (ShaderTextureSource)either.map(LocationSource::new, right -> right), source -> {
        Either either;
        if (source instanceof LocationSource) {
            LocationSource l = (LocationSource)source;
            either = Either.left((Object)l.location());
        } else {
            either = Either.right((Object)source);
        }
        return either;
    });
    public static final Context GLOBAL_CONTEXT = new Context(){};

    public int getId(Context var1);

    public Type getType();

    public static enum Type {
        LOCATION(LocationSource.CODEC),
        FRAMEBUFFER(FramebufferSource.CODEC);

        private final MapCodec<? extends ShaderTextureSource> codec;

        private Type(MapCodec<? extends ShaderTextureSource> codec) {
            this.codec = codec;
        }

        public MapCodec<? extends ShaderTextureSource> getCodec() {
            return this.codec;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static interface Context {
        @Nullable
        default public AdvancedFbo getFramebuffer(ResourceLocation name) {
            return VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(name);
        }

        default public int getTexture(ResourceLocation name) {
            if ("veil".equals(name.getNamespace()) && name.getPath().startsWith("dynamic_buffer")) {
                DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
                int activeBuffers = bufferManger.getActiveBuffers();
                if (name.equals((Object)VeilRenderer.ALBEDO_BUFFER_TEXTURE) && (activeBuffers & DynamicBufferType.ALBEDO.getMask()) != 0) {
                    return bufferManger.getBufferTexture(DynamicBufferType.ALBEDO);
                }
                if (name.equals((Object)VeilRenderer.NORMAL_BUFFER_TEXTURE) && (activeBuffers & DynamicBufferType.NORMAL.getMask()) != 0) {
                    return bufferManger.getBufferTexture(DynamicBufferType.NORMAL);
                }
                if (name.equals((Object)VeilRenderer.LIGHT_UV_BUFFER_TEXTURE) && (activeBuffers & DynamicBufferType.LIGHT_UV.getMask()) != 0) {
                    return bufferManger.getBufferTexture(DynamicBufferType.LIGHT_UV);
                }
                if (name.equals((Object)VeilRenderer.LIGHT_COLOR_BUFFER_TEXTURE) && (activeBuffers & DynamicBufferType.LIGHT_COLOR.getMask()) != 0) {
                    return bufferManger.getBufferTexture(DynamicBufferType.LIGHT_COLOR);
                }
                if (name.equals((Object)VeilRenderer.DEBUG_BUFFER_TEXTURE) && (activeBuffers & DynamicBufferType.DEBUG.getMask()) != 0) {
                    return bufferManger.getBufferTexture(DynamicBufferType.DEBUG);
                }
            }
            return Minecraft.getInstance().getTextureManager().getTexture(name).getId();
        }
    }
}

