/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred;

import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilDeferredRenderer
implements PreparableReloadListener,
NativeResource {
    public static final ResourceLocation PACK_ID = Veil.veilPath("deferred");
    public static final String DISABLE_VANILLA_ENTITY_LIGHT_KEY = "DISABLE_VANILLA_ENTITY_LIGHT";
    public static final ResourceLocation OPAQUE_POST = Veil.veilPath("core/opaque");
    public static final ResourceLocation LIGHT_POST = Veil.veilPath("core/light");
    public static final ResourceLocation OPAQUE_MIX = Veil.veilPath("core/mix_opaque");
    public static final ResourceLocation TRANSPARENT_MIX = Veil.veilPath("core/mix_transparent");
    public static final ResourceLocation TRANSPARENT_POST = Veil.veilPath("core/transparent");
    public static final ResourceLocation SCREEN_POST = Veil.veilPath("core/screen");
    public static final MutableComponent UNSUPPORTED_TITLE = Component.translatable((String)"veil.deferred.unsupported.title");
    public static final MutableComponent UNSUPPORTED_SODIUM_DESC = Component.translatable((String)"veil.deferred.unsupported.sodium_desc");
    public static final MutableComponent UNSUPPORTED_FABULOUS_DESC = Component.translatable((String)"veil.deferred.unsupported.fabulous_desc");
    private final ShaderManager deferredShaderManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private boolean enabled;
    private RendererState state;

    public VeilDeferredRenderer(ShaderManager deferredShaderManager, ShaderPreDefinitions shaderPreDefinitions, FramebufferManager framebufferManager, PostProcessingManager postProcessingManager) {
        this.deferredShaderManager = deferredShaderManager;
        this.shaderPreDefinitions = shaderPreDefinitions;
        this.framebufferManager = framebufferManager;
        this.postProcessingManager = postProcessingManager;
        this.enabled = false;
        this.state = RendererState.INACTIVE;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            boolean active;
            boolean selected = Minecraft.getInstance().getResourcePackRepository().getSelectedIds().contains(PACK_ID.toString()) || resourceManager.listPacks().anyMatch(pack -> pack.packId().equals(PACK_ID.toString()));
            boolean bl = active = selected && VeilDeferredRenderer.isSupported();
            if (selected && Minecraft.useShaderTransparency()) {
                SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)VeilClient.UNSUPPORTED_NOTIFICATION, (Component)UNSUPPORTED_TITLE, (Component)UNSUPPORTED_FABULOUS_DESC);
            }
            if (this.enabled != active) {
                this.enabled = active;
                if (active) {
                    Veil.LOGGER.info("Deferred Renderer Enabled");
                } else {
                    Veil.LOGGER.info("Deferred Renderer Disabled");
                    return preparationBarrier.wait(null).thenRunAsync(this::free, gameExecutor);
                }
            }
            if (this.enabled) {
                return this.deferredShaderManager.reload(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }
            return preparationBarrier.wait(null);
        }, gameExecutor).thenCompose(future -> future);
    }

    public void free() {
        this.enabled = false;
        this.state = RendererState.INACTIVE;
        this.deferredShaderManager.close();
    }

    @ApiStatus.Internal
    public void setup() {
    }

    @ApiStatus.Internal
    public void clear() {
    }

    @ApiStatus.Internal
    public void beginOpaque() {
    }

    @ApiStatus.Internal
    public void beginTranslucent() {
    }

    private void run(ProfilerFiller profiler, AdvancedFbo deferred, AdvancedFbo light, ResourceLocation post, ResourceLocation mix) {
        PostPipeline mixPipeline;
        PostPipeline postPipeline = this.postProcessingManager.getPipeline(post);
        if (postPipeline != null) {
            profiler.push("post");
            this.postProcessingManager.runPipeline(postPipeline, false);
            profiler.pop();
        }
        profiler.push("draw_lights");
        light.bind(true);
        profiler.pop();
        PostPipeline lightPipeline = this.postProcessingManager.getPipeline(LIGHT_POST);
        if (lightPipeline != null) {
            profiler.push("light_post");
            this.postProcessingManager.runPipeline(lightPipeline, false);
            profiler.pop();
        }
        if ((mixPipeline = this.postProcessingManager.getPipeline(mix)) != null) {
            profiler.push("mix");
            this.postProcessingManager.runPipeline(mixPipeline, false);
            profiler.pop();
        }
    }

    @ApiStatus.Internal
    public void end() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.INACTIVE;
    }

    public void enable() {
        this.state = RendererState.INACTIVE;
    }

    public void disable() {
        this.state = RendererState.DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled && VeilDeferredRenderer.isSupported();
    }

    public static boolean isSupported() {
        return !Minecraft.useShaderTransparency() && !Veil.SODIUM;
    }

    public boolean isActive() {
        return this.isEnabled() && this.state.isActive();
    }

    public RendererState getRendererState() {
        return this.state;
    }

    public ShaderManager getDeferredShaderManager() {
        return this.deferredShaderManager;
    }

    public static enum RendererState {
        DISABLED,
        INACTIVE,
        OPAQUE,
        TRANSLUCENT;


        public boolean isActive() {
            return this == OPAQUE || this == TRANSLUCENT;
        }
    }
}

