/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.dynamicbuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import foundry.veil.mixin.accessor.ProgramAccessor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public abstract class ShaderInstanceMixin
implements Shader,
ShaderInstanceExtension {
    @Mutable
    @Shadow
    @Final
    private Program vertexProgram;
    @Mutable
    @Shadow
    @Final
    private Program fragmentProgram;
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private VertexFormat vertexFormat;
    @Shadow
    @Final
    public Map<String, Uniform> uniformMap;
    @Shadow
    @Final
    private List<Integer> uniformLocations;
    @Shadow
    @Final
    private List<Integer> samplerLocations;
    @Shadow
    @Final
    private String name;
    @Unique
    private String veil$vertexSource;
    @Unique
    private String veil$fragmentSource;

    @Shadow
    private static Program getOrCreate(ResourceProvider resourceProvider, Program.Type programType, String name) throws IOException {
        return null;
    }

    @Shadow
    protected abstract void updateLocations();

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void apply(CallbackInfo ci) {
        SimpleShaderProcessor.markRendered(this.name);
        if (this.veil$vertexSource != null && this.veil$fragmentSource != null) {
            try {
                ProgramAccessor vertexAccessor = (ProgramAccessor)this.vertexProgram;
                ProgramAccessor fragmentAccessor = (ProgramAccessor)this.fragmentProgram;
                GL20C.glDetachShader((int)this.programId, (int)vertexAccessor.getId());
                GL20C.glDetachShader((int)this.programId, (int)fragmentAccessor.getId());
                GlStateManager.glShaderSource((int)vertexAccessor.getId(), List.of(this.veil$vertexSource));
                GlStateManager.glCompileShader((int)vertexAccessor.getId());
                if (GlStateManager.glGetShaderi((int)vertexAccessor.getId(), (int)35713) == 0) {
                    String error = StringUtils.trim((String)GL20C.glGetShaderInfoLog((int)vertexAccessor.getId()));
                    throw new IOException("Couldn't compile vertex program (" + this.vertexProgram.getName() + ", " + this.name + ") : " + error);
                }
                GlStateManager.glShaderSource((int)fragmentAccessor.getId(), List.of(this.veil$fragmentSource));
                GlStateManager.glCompileShader((int)fragmentAccessor.getId());
                if (GlStateManager.glGetShaderi((int)fragmentAccessor.getId(), (int)35713) == 0) {
                    String error = StringUtils.trim((String)GL20C.glGetShaderInfoLog((int)fragmentAccessor.getId()));
                    throw new IOException("Couldn't compile fragment program (" + this.fragmentProgram.getName() + ", " + this.name + ") : " + error);
                }
                int i = 0;
                for (String name : this.vertexFormat.getElementAttributeNames()) {
                    Uniform.glBindAttribLocation((int)this.programId, (int)i, (CharSequence)name);
                    ++i;
                }
                this.uniformLocations.clear();
                this.samplerLocations.clear();
                this.uniformMap.clear();
                ProgramManager.linkShader((Shader)this);
                this.updateLocations();
                this.markDirty();
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Failed to recompile vanilla shader: {}", (Object)this.name, (Object)t);
            }
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
    }

    @Override
    public Collection<ResourceLocation> veil$getShaderSources() {
        ResourceLocation vertexProgramName = ResourceLocation.parse((String)this.vertexProgram.getName());
        ResourceLocation fragmentProgramName = ResourceLocation.parse((String)this.fragmentProgram.getName());
        ResourceLocation vertexPath = ResourceLocation.fromNamespaceAndPath((String)vertexProgramName.getNamespace(), (String)("shaders/core/" + vertexProgramName.getPath() + Program.Type.VERTEX.getExtension()));
        ResourceLocation fragmentPath = ResourceLocation.fromNamespaceAndPath((String)fragmentProgramName.getNamespace(), (String)("shaders/core/" + fragmentProgramName.getPath() + Program.Type.FRAGMENT.getExtension()));
        return List.of(vertexPath, fragmentPath);
    }

    @Override
    public void veil$recompile(boolean vertex, String source) {
        if (vertex) {
            this.veil$vertexSource = source;
        } else {
            this.veil$fragmentSource = source;
        }
    }
}

