/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_buffer_region")
public class CLBufferRegion
extends Struct<CLBufferRegion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIGIN;
    public static final int SIZE;

    protected CLBufferRegion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CLBufferRegion create(long address, @Nullable ByteBuffer container) {
        return new CLBufferRegion(address, container);
    }

    public CLBufferRegion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLBufferRegion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long origin() {
        return CLBufferRegion.norigin(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return CLBufferRegion.nsize(this.address());
    }

    public CLBufferRegion origin(@NativeType(value="size_t") long value) {
        CLBufferRegion.norigin(this.address(), value);
        return this;
    }

    public CLBufferRegion size(@NativeType(value="size_t") long value) {
        CLBufferRegion.nsize(this.address(), value);
        return this;
    }

    public CLBufferRegion set(long origin, long size) {
        this.origin(origin);
        this.size(size);
        return this;
    }

    public CLBufferRegion set(CLBufferRegion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLBufferRegion malloc() {
        return new CLBufferRegion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CLBufferRegion calloc() {
        return new CLBufferRegion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CLBufferRegion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CLBufferRegion(MemoryUtil.memAddress(container), container);
    }

    public static CLBufferRegion create(long address) {
        return new CLBufferRegion(address, null);
    }

    @Nullable
    public static CLBufferRegion createSafe(long address) {
        return address == 0L ? null : new CLBufferRegion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CLBufferRegion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLBufferRegion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CLBufferRegion mallocStack() {
        return CLBufferRegion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBufferRegion callocStack() {
        return CLBufferRegion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBufferRegion mallocStack(MemoryStack stack) {
        return CLBufferRegion.malloc(stack);
    }

    @Deprecated
    public static CLBufferRegion callocStack(MemoryStack stack) {
        return CLBufferRegion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLBufferRegion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLBufferRegion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.calloc(capacity, stack);
    }

    public static CLBufferRegion malloc(MemoryStack stack) {
        return new CLBufferRegion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLBufferRegion calloc(MemoryStack stack) {
        return new CLBufferRegion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long norigin(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ORIGIN);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void norigin(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ORIGIN, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = CLBufferRegion.__struct(CLBufferRegion.__member(POINTER_SIZE), CLBufferRegion.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIGIN = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBufferRegion, Buffer>
    implements NativeResource {
        private static final CLBufferRegion ELEMENT_FACTORY = CLBufferRegion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLBufferRegion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long origin() {
            return CLBufferRegion.norigin(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return CLBufferRegion.nsize(this.address());
        }

        public Buffer origin(@NativeType(value="size_t") long value) {
            CLBufferRegion.norigin(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            CLBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

