/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import imgui.ImGui;
import imgui.type.ImInt;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PostEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.translatable((String)"editor.veil.post.title");
    private static final Component INACTIVE = Component.translatable((String)"editor.veil.post.inactive");
    private static final Component ACTIVE = Component.translatable((String)"editor.veil.post.active");
    private final Set<ResourceLocation> removedPipelines = new HashSet<ResourceLocation>(1);

    @Override
    public void render() {
        ImGui.setNextWindowSize(600.0f, 0.0f);
        super.render();
    }

    @Override
    public void renderComponents() {
        Object payload;
        this.removedPipelines.clear();
        PostProcessingManager postProcessingManager = VeilRenderSystem.renderer().getPostProcessingManager();
        float availableWidth = ImGui.getContentRegionAvailX();
        ImGui.setNextItemWidth(availableWidth / 2.0f);
        ImGui.beginGroup();
        VeilImGuiUtil.component((FormattedText)INACTIVE);
        if (ImGui.beginListBox("##available_pipelines", availableWidth / 2.0f, 0.0f)) {
            for (ResourceLocation resourceLocation : postProcessingManager.getPipelines()) {
                if (postProcessingManager.isActive(resourceLocation)) continue;
                VeilImGuiUtil.resourceLocation(resourceLocation);
                if (!ImGui.beginDragDropSource(8)) continue;
                ImGui.setDragDropPayload("POST_PIPELINE", resourceLocation, 2);
                VeilImGuiUtil.resourceLocation(resourceLocation);
                ImGui.endDragDropSource();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (ResourceLocation)ImGui.acceptDragDropPayload("POST_PIPELINE");
            if (payload != null) {
                this.removedPipelines.add((ResourceLocation)payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        ImGui.sameLine();
        ImGui.setNextItemWidth(availableWidth / 2.0f);
        ImGui.beginGroup();
        VeilImGuiUtil.component((FormattedText)ACTIVE);
        if (ImGui.beginListBox("##shaders", availableWidth / 2.0f, 0.0f)) {
            for (PostProcessingManager.ProfileEntry profileEntry : postProcessingManager.getActivePipelines()) {
                ResourceLocation id = profileEntry.getPipeline();
                ImGui.pushID(id.toString());
                VeilImGuiUtil.resourceLocation(id);
                if (ImGui.beginDragDropSource(8)) {
                    ImGui.setDragDropPayload("POST_PIPELINE", id, 2);
                    VeilImGuiUtil.resourceLocation(id);
                    ImGui.endDragDropSource();
                }
                float priorityWidth = ImGui.calcTextSize((String)"999999").x;
                ImGui.setItemAllowOverlap();
                ImGui.sameLine(ImGui.getContentRegionAvailX() - priorityWidth - 2.0f);
                ImGui.setNextItemWidth(priorityWidth);
                ImInt editPriority = new ImInt(profileEntry.getPriority());
                if (ImGui.dragScalar("##priority", 4, editPriority, 1.0f)) {
                    profileEntry.setPriority(editPriority.get());
                }
                ImGui.popID();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (ResourceLocation)ImGui.acceptDragDropPayload("POST_PIPELINE");
            if (payload != null) {
                postProcessingManager.add((ResourceLocation)payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        for (ResourceLocation resourceLocation : this.removedPipelines) {
            postProcessingManager.remove(resourceLocation);
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }
}

