/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilShaderLimits;
import foundry.veil.api.opencl.VeilOpenCL;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;

@ApiStatus.Internal
public class DeviceInfoViewer
extends SingleWindowEditor {
    public static final Component TITLE = Component.translatable((String)"editor.veil.device_info.title");
    private static final Component UNSUPPORTED = Component.translatable((String)"editor.veil.device_info.unsupported");
    private static final Component YES = CommonComponents.GUI_YES.copy().withStyle(style -> style.withColor(-16711936));
    private static final Component NO = CommonComponents.GUI_NO.copy().withStyle(style -> style.withColor(-16776961));
    private static final Component GL_FEATURE_FLAG = Component.translatable((String)"editor.veil.device_info.opengl.feature_flag");
    private static final Component GL_UNIFORM = Component.translatable((String)"editor.veil.device_info.opengl.uniform");
    private static final Component GL_TRANSFORM_FEEDBACK = Component.translatable((String)"editor.veil.device_info.opengl.transform_feedback");
    private static final Component GL_ATOMIC_COUNTER = Component.translatable((String)"editor.veil.device_info.opengl.atomic_counter");
    private static final Component GL_SHADER_STORAGE = Component.translatable((String)"editor.veil.device_info.opengl.shader_storage");
    private static final Component GL_TEXTURE = Component.translatable((String)"editor.veil.device_info.opengl.texture");
    private static final Component GL_FRAMEBUFFER = Component.translatable((String)"editor.veil.device_info.opengl.framebuffer");
    private static final Component CL_PLATFORMS = Component.translatable((String)"editor.veil.device_info.opencl.platforms");
    private static final Component CL_DEVICES = Component.translatable((String)"editor.veil.device_info.opencl.devices");
    private static final Component CL_DEVICE_DEFAULT = Component.translatable((String)"editor.veil.device_info.opencl.device.default");
    private static final Component CL_DEVICE_CPU = Component.translatable((String)"editor.veil.device_info.opencl.device.cpu");
    private static final Component CL_DEVICE_GPU = Component.translatable((String)"editor.veil.device_info.opencl.device.gpu");
    private static final Component CL_DEVICE_ACCELERATOR = Component.translatable((String)"editor.veil.device_info.opencl.device.accelerator");
    private static final Map<Integer, Component> SHADER_TYPES;
    private static final int TEXT_COLOR = -5592406;

    private static void text(String key, @Nullable Object value, @Nullable String tooltip) {
        if (value != null) {
            MutableComponent c;
            MutableComponent valueComponent = value instanceof MutableComponent ? (c = (MutableComponent)value) : Component.literal((String)value.toString());
            VeilImGuiUtil.component((FormattedText)Component.translatable((String)key, (Object[])new Object[]{valueComponent.withStyle(style -> style.withColor(-1))}));
        } else {
            int color = VeilImGuiUtil.getColor(1);
            VeilImGuiUtil.component((FormattedText)Component.translatable((String)key, (Object[])new Object[]{UNSUPPORTED}).withStyle(style -> style.withColor(color)));
        }
        if (tooltip != null) {
            ImGui.sameLine();
            VeilImGuiUtil.tooltip(tooltip);
        }
    }

    private static void flagText(String key, boolean supported, @Nullable String tooltip) {
        VeilImGuiUtil.component((FormattedText)Component.translatable((String)key, (Object[])new Object[]{supported ? YES : NO}));
        if (tooltip != null) {
            ImGui.sameLine();
            VeilImGuiUtil.tooltip(tooltip);
        }
    }

    private static void title(Component component) {
        ImGui.pushStyleColor(0, -1);
        VeilImGuiUtil.component((FormattedText)component);
        ImGui.popStyleColor();
    }

    private void renderOpenGL() {
        ImGui.pushStyleColor(0, -1);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.vendor", GL43C.glGetString((int)7936), null);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.renderer", GL43C.glGetString((int)7937), null);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.version", GL43C.glGetString((int)7938), null);
        ImGui.popStyleColor();
        ImGui.separator();
        DeviceInfoViewer.title(GL_FEATURE_FLAG);
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.compute", VeilRenderSystem.computeSupported(), "Whether compute shaders can be used");
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.atomic_counter", VeilRenderSystem.atomicCounterSupported(), "Whether atomic counters can be used in shaders");
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.transform_feedback", VeilRenderSystem.transformFeedbackSupported(), "Whether transform feedback can be used");
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.texture_multi_bind", VeilRenderSystem.textureMultibindSupported(), "Whether glBindTextures can be used instead of glBindTexture");
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.sparse_buffers", VeilRenderSystem.sparseBuffersSupported(), "Whether sparse buffers can be used");
        DeviceInfoViewer.flagText("editor.veil.device_info.opengl.feature_flag.direct_state_access", VeilRenderSystem.directStateAccessSupported(), "Whether direct state accesss can be used");
        ImGui.separator();
        GLCapabilities caps = GL.getCapabilities();
        ImGui.popStyleColor();
        for (Map.Entry<Integer, Component> entry : SHADER_TYPES.entrySet()) {
            if (!ImGui.collapsingHeader(entry.getValue().getString())) continue;
            ImGui.pushID(entry.getKey());
            ImGui.indent();
            ImGui.pushStyleColor(0, -5592406);
            VeilShaderLimits limits = VeilRenderSystem.shaderLimits(entry.getKey());
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_uniform_components", limits.maxUniformComponents(), "This is the number of active components of uniform variables that can be defined outside of a uniform block. The term \"component\" is meant as the basic component of a vector/matrix. So a vec3 takes up 3 components. The minimum value here is 1024, enough room for 256 vec4s.");
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_uniform_blocks", limits.maxUniformBlocks(), "The maximum number of uniform blocks that this shader stage can access. The OpenGL-required minimum is 12 in GL 3.3, and 14 in GL 4.3.");
            if (entry.getKey() != 37305) {
                DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_input_components", limits.maxInputComponents(), "The maximum number of components that this stage can take as input. The required minimum value differs from shader stage to shader stage.");
                DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_output_components", limits.maxOutputComponents(), "The maximum number of components that this stage can output. The required minimum value differs from shader stage to shader stage.");
            }
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_texture_image_units", limits.maxTextureImageUnits(), "The maximum number of texture image units that the sampler in this shader can access. The OpenGL-required minimum value is 16 for each stage.");
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_image_uniforms", limits.maxImageUniforms() > 0 ? Integer.valueOf(limits.maxImageUniforms()) : null, "The maximum number of image variables for this shader stage. The OpenGL-required minimum is 8 for fragment and compute shaders, and 0 for the rest. This means implementations may not allow you to use image variables in non-fragment or compute stages.");
            boolean atomicCounters = caps.OpenGL42 || caps.GL_ARB_shader_atomic_counters;
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_atomic_counters", atomicCounters ? Integer.valueOf(limits.maxAtomicCounters()) : null, "The maximum number of Atomic Counter variables that this stage can define. The OpenGL-required minimum is 8 for fragment and compute shaders, and 0 for the rest.");
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_atomic_counter_buffers", atomicCounters ? Integer.valueOf(limits.maxAtomicCountBuffers()) : null, "The maximum number of different buffers that the atomic counter variables can come from. The OpenGL-required minimum is 1 for fragment shaders, 8 for compute shaders (note: possible spec typo), and again 0 for the rest.");
            DeviceInfoViewer.text("editor.veil.device_info.opengl.shader.max_shader_storage_blocks", caps.OpenGL43 || caps.GL_ARB_shader_storage_buffer_object ? Integer.valueOf(limits.maxShaderStorageBlocks()) : null, "The maximum number of different shader storage blocks that a stage can use. For fragment and compute shaders, the OpenGL-required minimum is 8; for the rest, it is 0.");
            ImGui.popStyleColor();
            ImGui.unindent();
            ImGui.popID();
        }
        DeviceInfoViewer.title(GL_UNIFORM);
        ImGui.pushStyleColor(0, -5592406);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.uniform.max_uniform_buffer_bindings", VeilRenderSystem.maxUniformBuffersBindings(), "The limit on the number of uniform buffer binding points. This is the limit for glBindBufferRange when using GL_UNIFORM_BUFFER.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.uniform.max_combined_uniform_blocks", GL43C.glGetInteger((int)35374), "The maximum number of uniform blocks that all of the active programs can use. If two (or more) shader stages use the same block, they count separately towards this limit.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.uniform.max_combined_texture_image_units", VeilRenderSystem.maxCombinedTextureUnits(), "The total number of texture units that can be used from all active programs. This is the limit on glActiveTexture(GL_TEXTURE0 + i) and glBindSampler.");
        ImGui.separator();
        DeviceInfoViewer.title(GL_TRANSFORM_FEEDBACK);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.transform_feedback.max_separate_attributes", GL43C.glGetInteger((int)35979), "When doing separate mode Transform Feedback, this is the maximum number of varying variables that can be captured.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.transform_feedback.max_separate_components", GL43C.glGetInteger((int)35968), "When doing separate mode Transform Feedback, this is the maximum number of components for a single varying variable (note that varyings can be arrays or structs) that can be captured.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.transform_feedback.max_interleaved_components", GL43C.glGetInteger((int)35978), "When doing interleaved Transform Feedback, this is the total number of components that can be captured within a single buffer.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.transform_feedback.max_buffers", VeilRenderSystem.transformFeedbackSupported() ? Integer.valueOf(VeilRenderSystem.maxTransformFeedbackBindings()) : null, "The maximum number of buffers that can be written to in transform feedback operations.");
        ImGui.separator();
        boolean atomicCounters = caps.OpenGL42 || caps.GL_ARB_shader_atomic_counters;
        DeviceInfoViewer.title(GL_ATOMIC_COUNTER);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.atomic_counter.max_buffer_bindings", atomicCounters ? Integer.valueOf(VeilRenderSystem.maxAtomicCounterBufferBindings()) : null, "The total number of atomic counter buffer binding points. This is the limit for glBindBufferRange when using GL_ATOMIC_COUNTER_BUFFER.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.atomic_counter.max_combined_buffers", atomicCounters ? Integer.valueOf(GL43C.glGetInteger((int)37585)) : null, "The maximum number of atomic counter buffers variables across all active programs.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.atomic_counter.max_combined_counters", atomicCounters ? Integer.valueOf(GL43C.glGetInteger((int)37591)) : null, "The maximum number of atomic counter variables across all active programs.");
        ImGui.separator();
        boolean shaderStorageBuffers = caps.OpenGL43 || caps.GL_ARB_shader_storage_buffer_object;
        DeviceInfoViewer.title(GL_SHADER_STORAGE);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.shader_storage.max_bindings", atomicCounters ? Integer.valueOf(VeilRenderSystem.maxShaderStorageBufferBindings()) : null, "The total number of shader storage buffer binding points. This is the limit for glBindBufferRange when using GL_SHADER_STORAGE_BUFFER.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.shader_storage.max_combined_blocks", shaderStorageBuffers ? Integer.valueOf(GL43C.glGetInteger((int)37084)) : null, "The maximum number of shader storage blocks across all active programs. As with UBOs, blocks that are the same between stages are counted for each stage.");
        DeviceInfoViewer.text("editor.veil.device_info.opengl.shader_storage.max_output_resources", shaderStorageBuffers ? Integer.valueOf(GL43C.glGetInteger((int)36665)) : null, "The total number of shader storage blocks, image variables, and fragment shader outputs across all active programs cannot exceed this number. This is the \"amount of stuff\" that a sequence of shaders can write to (barring Transform Feedback).");
        ImGui.separator();
        DeviceInfoViewer.title(GL_TEXTURE);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.texture.max_texture_size", RenderSystem.maxSupportedTextureSize(), null);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.texture.max_array_texture_layers", VeilRenderSystem.maxArrayTextureLayers(), null);
        DeviceInfoViewer.title(GL_FRAMEBUFFER);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.framebuffer.max_color_attachments", VeilRenderSystem.maxColorAttachments(), null);
        DeviceInfoViewer.text("editor.veil.device_info.opengl.framebuffer.max_samples", VeilRenderSystem.maxSamples(), null);
    }

    private void renderOpenAL() {
        ImGui.pushStyleColor(0, -1);
        DeviceInfoViewer.text("editor.veil.device_info.openal.vendor", AL10.alGetString((int)45057), null);
        DeviceInfoViewer.text("editor.veil.device_info.openal.renderer", AL10.alGetString((int)45059), null);
        DeviceInfoViewer.text("editor.veil.device_info.openal.version", AL10.alGetString((int)45058), null);
        ImGui.popStyleColor();
    }

    private void renderOpenCL() {
        VeilOpenCL cl = VeilOpenCL.get();
        VeilOpenCL.PlatformInfo[] platforms = cl.getPlatforms();
        DeviceInfoViewer.title(CL_PLATFORMS);
        for (int i = 0; i < platforms.length; ++i) {
            VeilOpenCL.PlatformInfo platform = platforms[i];
            if (!ImGui.collapsingHeader(I18n.get((String)"editor.veil.device_info.opencl.platform", (Object[])new Object[]{platform.name(), platform.id()}), i == 0 ? 32 : 0)) continue;
            ImGui.pushStyleColor(0, -5592406);
            DeviceInfoViewer.text("editor.veil.device_info.opencl.profile", platform.profile(), null);
            DeviceInfoViewer.text("editor.veil.device_info.opencl.cl_version", platform.version(), null);
            DeviceInfoViewer.text("editor.veil.device_info.opencl.vendor", platform.vendor(), null);
            ImGui.popStyleColor();
            ImGui.separator();
            VeilOpenCL.DeviceInfo[] devices = platform.devices();
            DeviceInfoViewer.title(CL_DEVICES);
            for (int j = 0; j < devices.length; ++j) {
                VeilOpenCL.DeviceInfo device = devices[j];
                if (!ImGui.collapsingHeader(I18n.get((String)"editor.veil.device_info.opencl.device", (Object[])new Object[]{device.name(), device.id()}), j == 0 ? 32 : 0)) continue;
                ImGui.pushStyleColor(0, -5592406);
                ImGui.indent();
                ArrayList<Component> types = new ArrayList<Component>(1);
                if (device.isDefault()) {
                    types.add(CL_DEVICE_DEFAULT);
                }
                if (device.isCpu()) {
                    types.add(CL_DEVICE_CPU);
                }
                if (device.isGpu()) {
                    types.add(CL_DEVICE_GPU);
                }
                if (device.isAccelerator()) {
                    types.add(CL_DEVICE_ACCELERATOR);
                }
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.type", ComponentUtils.formatList(types, (Component)Component.literal((String)", ")), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.vendor_id", "0x%X".formatted(device.vendorId()), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.max_compute_units", device.maxComputeUnits(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.max_work_item_dimensions", device.maxWorkItemDimensions(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.max_work_group_size", device.maxWorkGroupSize(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.max_clock_frequency", device.maxClockFrequency(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.address_size", device.addressBits(), null);
                DeviceInfoViewer.flagText("editor.veil.device_info.opencl.device.available", device.available(), null);
                DeviceInfoViewer.flagText("editor.veil.device_info.opencl.device.compiler_available", device.compilerAvailable(), null);
                DeviceInfoViewer.flagText("editor.veil.device_info.opencl.device.require_manual_sync", device.requireManualInteropSync(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.vendor", device.vendor(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.version", device.version(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.driver_version", device.driverVersion(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.profile", device.profile(), null);
                DeviceInfoViewer.text("editor.veil.device_info.opencl.device.c_version", device.openclCVersion(), null);
                ImGui.unindent();
                ImGui.popStyleColor();
            }
        }
    }

    public static Component getShaderName(int shader) {
        return SHADER_TYPES.get(shader);
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return INFO_GROUP;
    }

    @Override
    protected void renderComponents() {
        if (ImGui.beginTabBar("##info")) {
            if (ImGui.beginTabItem(I18n.get((String)"editor.veil.device_info.opencl", (Object[])new Object[0]))) {
                this.renderOpenCL();
                ImGui.endTabItem();
            }
            if (ImGui.beginTabItem(I18n.get((String)"editor.veil.device_info.opengl", (Object[])new Object[0]))) {
                ImGui.pushStyleColor(0, -5592406);
                this.renderOpenGL();
                ImGui.popStyleColor();
                ImGui.endTabItem();
            }
            if (ImGui.beginTabItem(I18n.get((String)"editor.veil.device_info.openal", (Object[])new Object[0]))) {
                ImGui.pushStyleColor(0, -5592406);
                this.renderOpenAL();
                ImGui.popStyleColor();
                ImGui.endTabItem();
            }
            ImGui.endTabBar();
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints(400.0f, 460.0f, Float.MAX_VALUE, Float.MAX_VALUE);
        super.render();
    }

    static {
        LinkedHashMap<Integer, MutableComponent> map = new LinkedHashMap<Integer, MutableComponent>();
        map.put(35633, Component.translatable((String)"editor.veil.shader.vertex_shader"));
        map.put(36488, Component.translatable((String)"editor.veil.shader.tess_control_shader"));
        map.put(36487, Component.translatable((String)"editor.veil.shader.tess_eval_shader"));
        map.put(36313, Component.translatable((String)"editor.veil.shader.geometry_shader"));
        map.put(35632, Component.translatable((String)"editor.veil.shader.fragment_shader"));
        map.put(37305, Component.translatable((String)"editor.veil.shader.compute_shader"));
        SHADER_TYPES = Collections.unmodifiableMap(map);
    }
}

