/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLKernel;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.api.opencl.event.CLEventDispatcher;
import foundry.veil.api.opencl.event.CLLegacyEventDispatcher;
import foundry.veil.api.opencl.event.CLNativeEventDispatcher;
import foundry.veil.lib.opencl.CL10;
import foundry.veil.lib.opencl.CL20;
import foundry.veil.lib.opencl.CLCapabilities;
import foundry.veil.lib.opencl.CLContextCallback;
import foundry.veil.lib.opencl.CLContextCallbackI;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFWNativeGLX;
import org.lwjgl.glfw.GLFWNativeWGL;
import org.lwjgl.glfw.GLFWNativeX11;
import org.lwjgl.opengl.CGL;
import org.lwjgl.opengl.WGL;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;

public class CLEnvironment
implements NativeResource {
    private static final FileToIdConverter SHADERS = new FileToIdConverter("pinwheel/compute", ".cl");
    private final VeilOpenCL.DeviceInfo device;
    private final CLContextCallback errorCallback;
    private final long context;
    private final long commandQueue;
    private final boolean requireManualInteropSync;
    private final boolean openGLSupported;
    private final Map<ResourceLocation, ProgramData> programs;
    private final CLEventDispatcher eventDispatcher;

    public CLEnvironment(VeilOpenCL.DeviceInfo deviceInfo) throws CLException {
        this.device = deviceInfo;
        CLCapabilities caps = deviceInfo.capabilities();
        this.requireManualInteropSync = deviceInfo.requireManualInteropSync();
        boolean bl = this.openGLSupported = RenderSystem.isOnRenderThread() && (caps.cl_khr_gl_sharing || caps.cl_APPLE_gl_sharing);
        if (!this.openGLSupported && (caps.cl_khr_gl_sharing || caps.cl_APPLE_gl_sharing)) {
            VeilOpenCL.LOGGER.warn("Disabled OpenGL sharing because environment was created off-thread");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer ctxProps = stack.mallocPointer(this.openGLSupported ? 7 : 3);
            if (this.openGLSupported) {
                RenderSystem.assertOnRenderThread();
                long window = Minecraft.getInstance().getWindow().getWindow();
                switch (Platform.get()) {
                    case WINDOWS: {
                        ctxProps.put(8200L).put(GLFWNativeWGL.glfwGetWGLContext((long)window)).put(8203L).put(WGL.wglGetCurrentDC());
                        break;
                    }
                    case LINUX: {
                        ctxProps.put(8200L).put(GLFWNativeGLX.glfwGetGLXContext((long)window)).put(8202L).put(GLFWNativeX11.glfwGetX11Display());
                        break;
                    }
                    case MACOSX: {
                        ctxProps.put(0x10000000L).put(CGL.CGLGetShareGroup((long)CGL.CGLGetCurrentContext()));
                    }
                }
            }
            ctxProps.put(4228L).put(deviceInfo.platform()).put(0L).flip();
            this.errorCallback = CLContextCallback.create((errinfo, private_info, cb, user_data) -> {
                VeilOpenCL.LOGGER.error("[LWJGL] cl_context_callback");
                VeilOpenCL.LOGGER.error("\tInfo: " + MemoryUtil.memUTF8(errinfo));
            });
            IntBuffer errcode_ret = stack.callocInt(1);
            long device = deviceInfo.id();
            try {
                this.context = CL10.clCreateContext(ctxProps, device, (CLContextCallbackI)this.errorCallback, 0L, errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                this.commandQueue = CL20.clCreateCommandQueueWithProperties(this.context, device, null, errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                if (this.commandQueue == 0L) {
                    throw new IllegalStateException("Failed to create OpenCL queue");
                }
            }
            catch (Exception e) {
                this.free();
                throw e;
            }
        }
        this.programs = new HashMap<ResourceLocation, ProgramData>();
        this.eventDispatcher = caps.clSetEventCallback != 0L ? new CLNativeEventDispatcher() : new CLLegacyEventDispatcher();
    }

    public void loadProgram(ResourceLocation name, CharSequence source) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long program = 0L;
            IntBuffer errcode_ret = stack.callocInt(1);
            try {
                program = CL10.clCreateProgramWithSource(this.context, source, errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                long device = this.device.id();
                int programStatus = CL10.clBuildProgram(program, device, (CharSequence)"", null, 0L);
                if (programStatus != 0) {
                    System.err.println(VeilOpenCL.getProgramBuildInfo(program, device, 4483));
                    throw new CLException("Failed to compile program", programStatus);
                }
                ProgramData oldProgram = this.programs.put(name, new ProgramData(program));
                if (oldProgram != null) {
                    VeilOpenCL.LOGGER.info("Deleting old program: {}", (Object)name);
                    oldProgram.free();
                }
            }
            catch (Exception e) {
                VeilOpenCL.LOGGER.error("Failed to load program from source: {}", (Object)name, (Object)e);
                if (program != 0L) {
                    CL10.clReleaseProgram(program);
                }
            }
        }
    }

    public void loadProgram(ResourceLocation name, ResourceProvider provider) throws IOException {
        Resource resource = provider.getResourceOrThrow(SHADERS.idToFile(name));
        try (InputStream stream = resource.open();){
            this.loadProgram(name, IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        }
    }

    public CLKernel createKernel(ResourceLocation program, String kernelName) throws CLException {
        ProgramData programData = this.programs.get(program);
        if (programData == null) {
            throw new CLException("Unknown program: " + kernelName, -44);
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer errcode_ret = stack.callocInt(1);
            long kernelId = CL10.clCreateKernel(programData.id, (CharSequence)kernelName, errcode_ret);
            if (errcode_ret.get(0) == -46) {
                throw new CLException("Failed to find kernel: " + kernelName, errcode_ret.get(0));
            }
            VeilOpenCL.checkCLError(errcode_ret);
            CLKernel kernel = new CLKernel(this, program, kernelId);
            programData.kernels.add(kernel);
            CLKernel cLKernel = kernel;
            return cLKernel;
        }
    }

    public void finish() throws CLException {
        VeilOpenCL.checkCLError(CL10.clFinish(this.commandQueue));
    }

    public void freeProgram(ResourceLocation program) {
        ProgramData programData = this.programs.remove(program);
        if (programData != null) {
            VeilOpenCL.LOGGER.info("Deleting kernel program: {}", (Object)program);
            programData.free();
        }
    }

    public boolean isOpenGLSupported() {
        return this.openGLSupported;
    }

    public boolean requireManualInteropSync() {
        return this.requireManualInteropSync;
    }

    @Override
    @ApiStatus.Internal
    public void free() {
        CLEventDispatcher cLEventDispatcher;
        if (this.commandQueue != 0L) {
            try {
                this.finish();
            }
            catch (CLException cLException) {
                // empty catch block
            }
        }
        if (this.errorCallback != null) {
            this.errorCallback.free();
        }
        if (this.commandQueue != 0L) {
            CL10.clReleaseCommandQueue(this.commandQueue);
        }
        if (this.context != 0L) {
            CL10.clReleaseContext(this.context);
        }
        if (this.programs != null) {
            this.programs.values().forEach(NativeResource::free);
            this.programs.clear();
        }
        if ((cLEventDispatcher = this.eventDispatcher) instanceof CLLegacyEventDispatcher) {
            CLLegacyEventDispatcher legacyEventDispatcher = (CLLegacyEventDispatcher)cLEventDispatcher;
            try {
                legacyEventDispatcher.close();
            }
            catch (InterruptedException e) {
                VeilOpenCL.LOGGER.error("Failed to stop event dispatcher", (Throwable)e);
            }
        }
    }

    @ApiStatus.Internal
    void free(CLKernel clKernel) {
        ResourceLocation name = clKernel.getProgram();
        ProgramData programData = this.programs.get(name);
        if (programData == null) {
            return;
        }
        programData.kernels.remove(clKernel);
        if (programData.kernels.isEmpty()) {
            this.freeProgram(name);
        }
    }

    public VeilOpenCL.DeviceInfo getDevice() {
        return this.device;
    }

    public CLEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public long getContext() {
        return this.context;
    }

    public long getCommandQueue() {
        return this.commandQueue;
    }

    private record ProgramData(long id, Set<CLKernel> kernels) implements NativeResource
    {
        private ProgramData(long id) {
            this(id, new HashSet<CLKernel>());
        }

        @Override
        public void free() {
            CL10.clReleaseProgram(this.id);
            this.kernels.clear();
        }
    }
}

