/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class FramebufferEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.translatable((String)"editor.veil.framebuffer.title");
    private static final Component SAVE = Component.translatable((String)"gui.veil.save");
    private final Set<ResourceLocation> framebuffers = new TreeSet<ResourceLocation>();
    private AdvancedFbo downloadBuffer;

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        if (ImGui.beginTabBar((String)"##framebuffers")) {
            this.framebuffers.clear();
            this.framebuffers.addAll(renderer.getFramebufferManager().getFramebuffers().keySet());
            for (ResourceLocation id : this.framebuffers) {
                FramebufferEditor.drawBuffers(id, fbo -> {
                    this.downloadBuffer = fbo;
                });
            }
            ImGui.endTabBar();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadBuffer != null) {
            try {
                Minecraft client = Minecraft.getInstance();
                Path outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out").resolve("deferred");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < this.downloadBuffer.getColorAttachments(); ++i) {
                    if (!this.downloadBuffer.isColorTextureAttachment(i)) continue;
                    AdvancedFboTextureAttachment attachment = this.downloadBuffer.getColorTextureAttachment(i);
                    Object name = attachment.getName() != null ? attachment.getName() : "Attachment " + i;
                    result.add(TextureDownloader.save((String)name, outputFolder, attachment.getId(), true));
                }
                if (this.downloadBuffer.isDepthTextureAttachment()) {
                    AdvancedFboTextureAttachment attachment = this.downloadBuffer.getDepthTextureAttachment();
                    String name = attachment.getName() != null ? attachment.getName() : "Depth Attachment";
                    result.add(TextureDownloader.save(name, outputFolder, attachment.getId(), true));
                }
                CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download framebuffer", (Throwable)e);
            }
            this.downloadBuffer = null;
        }
    }

    public static void drawBuffers(ResourceLocation id, @Nullable Consumer<AdvancedFbo> saveCallback) {
        AdvancedFbo buffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(id);
        ImGui.beginDisabled((buffer == null ? 1 : 0) != 0);
        if (ImGui.beginTabItem((String)id.toString())) {
            if (buffer != null) {
                AdvancedFboTextureAttachment attachment;
                int i;
                int columns = (int)Math.ceil(Math.sqrt(buffer.getColorAttachments() + (buffer.isDepthTextureAttachment() ? 1 : 0)));
                float width = ImGui.getContentRegionAvailX() / (float)columns - ImGui.getStyle().getItemSpacingX();
                float height = width * (float)buffer.getHeight() / (float)buffer.getWidth();
                for (i = 0; i < buffer.getColorAttachments(); ++i) {
                    if (!buffer.isColorTextureAttachment(i)) continue;
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getColorTextureAttachment(i);
                    ImGui.text((String)FramebufferEditor.getAttachmentName(i, attachment));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    ImGui.endGroup();
                }
                if (buffer.isDepthTextureAttachment()) {
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getDepthTextureAttachment();
                    ImGui.text((String)FramebufferEditor.getAttachmentName(-1, attachment));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    ImGui.endGroup();
                }
                if (saveCallback != null && ImGui.button((String)SAVE.getString(), (float)(ImGui.getContentRegionAvailX() - 4.0f), (float)0.0f)) {
                    saveCallback.accept(buffer);
                }
            }
            ImGui.endTabItem();
        }
        ImGui.endDisabled();
    }

    private static String getAttachmentName(int index, AdvancedFboTextureAttachment attachment) {
        RenderSystem.bindTexture((int)attachment.getId());
        StringBuilder attachmentName = new StringBuilder(attachment.getName() != null ? attachment.getName() : (index == -1 ? I18n.get((String)"editor.veil.framebuffer.depth_attachment", (Object[])new Object[0]) : I18n.get((String)"editor.veil.framebuffer.color_attachment", (Object[])new Object[]{index})));
        int internalFormat = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        for (FramebufferAttachmentDefinition.Format format : FramebufferAttachmentDefinition.Format.values()) {
            if (internalFormat != format.getInternalId()) continue;
            attachmentName.append(" (").append(format.name()).append(")");
            return attachmentName.toString();
        }
        attachmentName.append(" (0x%X)".formatted(internalFormat));
        return attachmentName.toString();
    }
}

