/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.VeilShaderSource;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderBindingProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPredefinitionProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderVersionProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferProcessor;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class ShaderManager
implements PreparableReloadListener,
Closeable {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ProgramDefinition.class, (Object)new ProgramDefinition.Deserializer()).create();
    public static final FileToIdConverter INCLUDE_LISTER = new FileToIdConverter("pinwheel/shaders/include", ".glsl");
    public static final ShaderSourceSet PROGRAM_SET = new ShaderSourceSet("pinwheel/shaders/program");
    public static final ShaderSourceSet DEFERRED_SET = new ShaderSourceSet("pinwheel/shaders/deferred");
    private static final Map<Integer, String> TYPES = Map.of(35633, "vertex", 36488, "tesselation_control", 36487, "tesselation_evaluation", 36313, "geometry", 35632, "fragment", 37305, "compute");
    private final DynamicBufferManger dynamicBufferManager;
    private final ShaderSourceSet sourceSet;
    private final ShaderPreDefinitions definitions;
    private final Map<ResourceLocation, ShaderProgram> shaders;
    private final Map<ResourceLocation, ShaderProgram> shadersView;
    private final Set<ResourceLocation> dirtyShaders;
    private final List<ShaderPreProcessor> processors;
    private final List<ShaderPreProcessor> importProcessors;
    private ShaderPreProcessor processor;
    private ShaderPreProcessor importProcessor;
    private CompletableFuture<Void> reloadFuture;
    private CompletableFuture<Void> recompileFuture;
    private CompletableFuture<Void> updateBuffersFuture;

    public ShaderManager(ShaderSourceSet sourceSet, ShaderPreDefinitions shaderPreDefinitions, DynamicBufferManger dynamicBufferManager) {
        this.dynamicBufferManager = dynamicBufferManager;
        this.sourceSet = sourceSet;
        this.definitions = shaderPreDefinitions;
        this.definitions.addListener(this::onDefinitionChanged);
        this.shaders = new HashMap<ResourceLocation, ShaderProgram>();
        this.shadersView = Collections.unmodifiableMap(this.shaders);
        this.dirtyShaders = new HashSet<ResourceLocation>();
        this.processors = new LinkedList<ShaderPreProcessor>();
        this.importProcessors = new LinkedList<ShaderPreProcessor>();
        this.processor = null;
        this.importProcessor = null;
        this.reloadFuture = CompletableFuture.completedFuture(null);
        this.recompileFuture = CompletableFuture.completedFuture(null);
        this.updateBuffersFuture = CompletableFuture.completedFuture(null);
    }

    private ShaderPreProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = ShaderPreProcessor.allOf(this.processors);
        }
        return this.processor;
    }

    private ShaderPreProcessor getImportProcessor() {
        if (this.importProcessor == null) {
            this.importProcessor = ShaderPreProcessor.allOf(this.importProcessors);
        }
        return this.importProcessor;
    }

    private void onDefinitionChanged(String definition) {
        this.shaders.values().forEach(shader -> {
            if (shader.getDefinitionDependencies().contains(definition)) {
                Veil.LOGGER.debug("{} changed, recompiling {}", (Object)definition, (Object)shader.getId());
                this.scheduleRecompile(shader.getId());
            }
        });
    }

    private ProgramDefinition parseDefinition(ResourceLocation id, ResourceProvider provider) throws IOException {
        ProgramDefinition programDefinition;
        block9: {
            BufferedReader reader = provider.openAsReader(this.sourceSet.getShaderDefinitionLister().idToFile(id));
            try {
                ProgramDefinition definition = (ProgramDefinition)GsonHelper.fromJson((Gson)GSON, (Reader)reader, ProgramDefinition.class);
                if (definition.vertex() == null && definition.tesselationControl() == null && definition.tesselationEvaluation() == null && definition.geometry() == null && definition.fragment() == null && definition.compute() == null) {
                    throw new JsonSyntaxException("Shader programs must define at least 1 shader type");
                }
                programDefinition = definition;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    throw new IOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return programDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readShader(ResourceManager resourceManager, Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, VeilShaderSource> shaderSources, ResourceLocation definitionId, int flags) {
        HashSet<ResourceLocation> checkedSources = new HashSet<ResourceLocation>();
        ShaderPreProcessor processor = this.getProcessor();
        ShaderPreProcessor importProcessor = this.getImportProcessor();
        try {
            ProgramDefinition definition = this.parseDefinition(definitionId, (ResourceProvider)resourceManager);
            if (definitions.put(definitionId, definition) != null) {
                throw new IllegalStateException("Duplicate shader ignored with ID " + String.valueOf(definitionId));
            }
            for (Int2ObjectMap.Entry shader : definition.shaders().int2ObjectEntrySet()) {
                int type = shader.getIntKey();
                ResourceLocation shaderId = ((ProgramDefinition.ShaderSource)shader.getValue()).location();
                FileToIdConverter typeConverter = this.sourceSet.getTypeConverter(type);
                ResourceLocation location = typeConverter.idToFile(shaderId);
                if (!checkedSources.add(location)) continue;
                Resource resource = resourceManager.getResourceOrThrow(location);
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        String source = IOUtils.toString((Reader)reader);
                        processor.prepare();
                        importProcessor.prepare();
                        Object2IntArrayMap uniformBindings = new Object2IntArrayMap();
                        HashSet<String> dependencies = new HashSet<String>();
                        HashSet<ResourceLocation> includes = new HashSet<ResourceLocation>();
                        PreProcessorContext preProcessorContext = new PreProcessorContext(importProcessor, definition, this.definitions, type, (Map<String, Integer>)uniformBindings, dependencies, includes, shaderId, true);
                        String transformed = this.processor.modify(preProcessorContext, source);
                        if (flags != 0) {
                            DynamicBufferType[] types = DynamicBufferType.decode(flags);
                            DynamicBufferProcessor bufferProcessor = new DynamicBufferProcessor(types);
                            transformed = bufferProcessor.modify(preProcessorContext, transformed);
                        }
                        shaderSources.put(location, new VeilShaderSource(shaderId, transformed, (Object2IntMap<String>)uniformBindings, dependencies, includes));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable t) {
                    throw new IOException("Failed to load " + ShaderManager.getTypeName(type) + " shader", t);
                    return;
                }
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Veil.LOGGER.error("Couldn't parse shader {} from {}", new Object[]{definitionId, this.sourceSet.getShaderDefinitionLister().idToFile(definitionId), e});
        }
    }

    private void compile(ShaderProgram program, ProgramDefinition definition, ShaderCompiler compiler) {
        ResourceLocation id = program.getId();
        try {
            program.compile(new ShaderCompiler.Context(this.dynamicBufferManager.getActiveBuffers(), this.sourceSet, definition), compiler);
        }
        catch (ShaderException e) {
            Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
            String error = e.getGlError();
            if (error != null) {
                Veil.LOGGER.warn(error);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
        }
    }

    private void addProcessors(ResourceProvider provider) {
        if (provider != null) {
            this.addPreprocessor(new ShaderImportProcessor(provider));
        }
        this.addPreprocessor(new ShaderBindingProcessor());
        this.addPreprocessor(new ShaderPredefinitionProcessor(), false);
        this.addPreprocessor(new ShaderVersionProcessor(), false);
        this.addPreprocessor(new ShaderModifyProcessor(), false);
        this.addPreprocessor(new ShaderCustomProcessor(provider), false);
    }

    public void addPreprocessor(ShaderPreProcessor processor, boolean modifyImports) {
        this.processors.add(processor);
        this.processor = null;
        if (modifyImports) {
            this.importProcessors.add(processor);
            this.importProcessor = null;
        }
    }

    public void addPreprocessor(ShaderPreProcessor processor) {
        this.addPreprocessor(processor, true);
    }

    public void setGlobal(Consumer<ShaderProgram> setter) {
        this.shaders.values().forEach(setter);
    }

    @Nullable
    public ShaderProgram getShader(ResourceLocation id) {
        return this.shaders.get(id);
    }

    public Map<ResourceLocation, ShaderProgram> getShaders() {
        return this.shadersView;
    }

    public ShaderSourceSet getSourceSet() {
        return this.sourceSet;
    }

    private ReloadState prepare(ResourceManager resourceManager, Collection<ResourceLocation> shaders, int activeBuffers) {
        HashMap<ResourceLocation, ProgramDefinition> definitions = new HashMap<ResourceLocation, ProgramDefinition>();
        HashMap<ResourceLocation, VeilShaderSource> shaderSources = new HashMap<ResourceLocation, VeilShaderSource>();
        this.addProcessors((ResourceProvider)resourceManager);
        for (ResourceLocation key : shaders) {
            this.readShader(resourceManager, definitions, shaderSources, key, activeBuffers);
        }
        this.processors.clear();
        this.processor = null;
        this.importProcessors.clear();
        this.importProcessor = null;
        return new ReloadState(definitions, shaderSources);
    }

    private void apply(ReloadState reloadState) {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
        try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ResourceLocation id = entry.getKey();
                ShaderProgram program = ShaderProgram.create(id);
                this.compile(program, entry.getValue(), compiler);
                this.shaders.put(id, program);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Loaded {} shaders from: {}", (Object)this.shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void applyRecompile(ReloadState reloadState, Collection<ResourceLocation> shaders) {
        try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ResourceLocation id = entry.getKey();
                ShaderProgram program = this.getShader(id);
                if (program == null) {
                    Veil.LOGGER.warn("Failed to recompile shader: {}", (Object)id);
                    continue;
                }
                this.compile(program, entry.getValue(), compiler);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Recompiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void scheduleRecompile(int attempt) {
        Minecraft client = Minecraft.getInstance();
        client.tell(() -> {
            HashSet<ResourceLocation> shaders;
            if (!this.recompileFuture.isDone()) {
                return;
            }
            Set<ResourceLocation> set = this.dirtyShaders;
            synchronized (set) {
                shaders = new HashSet<ResourceLocation>(this.dirtyShaders);
                this.dirtyShaders.clear();
            }
            int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
            this.recompileFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(client.getResourceManager(), shaders, activeBuffers), Util.backgroundExecutor()).thenAcceptAsync(state -> this.applyRecompile((ReloadState)state, (Collection<ResourceLocation>)shaders), (Executor)client)).handle((value, e) -> {
                if (e != null) {
                    Veil.LOGGER.error("Error recompiling shaders", e);
                }
                Set<ResourceLocation> set = this.dirtyShaders;
                synchronized (set) {
                    if (this.dirtyShaders.isEmpty()) {
                        return value;
                    }
                }
                if (attempt >= 3) {
                    Veil.LOGGER.error("Failed to recompile shaders after {} attempts", (Object)attempt);
                    return value;
                }
                this.scheduleRecompile(attempt + 1);
                return value;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRecompile(ResourceLocation shader) {
        Set<ResourceLocation> set = this.dirtyShaders;
        synchronized (set) {
            this.dirtyShaders.add(shader);
        }
        if (!this.recompileFuture.isDone()) {
            return;
        }
        this.scheduleRecompile(0);
    }

    @ApiStatus.Internal
    public void setActiveBuffers(int activeBuffers) {
        ShaderProgram active = null;
        try {
            HashSet<ResourceLocation> shaders = new HashSet<ResourceLocation>();
            Iterator<ShaderProgram> iterator = this.shaders.values().iterator();
            while (iterator.hasNext()) {
                ShaderProgramImpl impl;
                ShaderProgram program;
                active = program = iterator.next();
                if (!(program instanceof ShaderProgramImpl) || !(impl = (ShaderProgramImpl)program).setActiveBuffers(activeBuffers)) continue;
                shaders.add(program.getId());
            }
            if (!shaders.isEmpty()) {
                this.updateBuffersFuture = ((CompletableFuture)this.updateBuffersFuture.thenApplyAsync(unused -> this.prepare(Minecraft.getInstance().getResourceManager(), shaders, activeBuffers), (Executor)Util.backgroundExecutor())).thenAcceptAsync(reloadState -> {
                    try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
                        for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                            ResourceLocation id = entry.getKey();
                            ShaderProgram program = this.getShader(id);
                            if (!(program instanceof ShaderProgramImpl)) {
                                Veil.LOGGER.warn("Failed to set shader active buffers: {}", (Object)id);
                                continue;
                            }
                            ShaderProgramImpl impl = (ShaderProgramImpl)program;
                            try {
                                impl.updateActiveBuffers(new ShaderCompiler.Context(activeBuffers, this.sourceSet, null), compiler);
                            }
                            catch (ShaderException e) {
                                Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
                                String error = e.getGlError();
                                if (error == null) continue;
                                Veil.LOGGER.warn(error);
                            }
                            catch (Exception e) {
                                Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
                            }
                        }
                    }
                    VeilRenderSystem.finalizeShaderCompilation();
                    Veil.LOGGER.info("Compiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
                }, (Executor)Minecraft.getInstance());
            }
        }
        catch (ShaderException e) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)e, (String)"Setting Active Buffers");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Linking Program");
            crashreportcategory.setDetail("Name", (Object)active.getId());
            String glError = e.getGlError();
            if (glError != null) {
                Veil.LOGGER.error(glError);
            }
            throw new ReportedException(crashreport);
        }
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        if (this.reloadFuture != null && !this.reloadFuture.isDone()) {
            return this.reloadFuture.thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
        }
        int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
        this.reloadFuture = CompletableFuture.allOf(this.recompileFuture, this.updateBuffersFuture).thenCompose(unused -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            FileToIdConverter lister = this.sourceSet.getShaderDefinitionLister();
            Set<ResourceLocation> shaderIds = lister.listMatchingResources(resourceManager).keySet().stream().map(arg_0 -> ((FileToIdConverter)lister).fileToId(arg_0)).collect(Collectors.toSet());
            return this.prepare(resourceManager, shaderIds, activeBuffers);
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(this::apply, gameExecutor));
        return this.reloadFuture;
    }

    public String getName() {
        return this.getClass().getSimpleName() + " " + this.getSourceSet().getFolder();
    }

    public CompletableFuture<Void> getReloadFuture() {
        return this.reloadFuture;
    }

    public CompletableFuture<Void> getRecompileFuture() {
        return this.recompileFuture;
    }

    public static String getTypeName(int type) {
        String value = TYPES.get(type);
        return value != null ? value : "0x" + Integer.toHexString(type);
    }

    @Override
    public void close() {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
    }

    private record PreProcessorContext(ShaderPreProcessor preProcessor, @Nullable ProgramDefinition definition, ShaderPreDefinitions preDefinitions, int type, Map<String, Integer> uniformBindings, Set<String> dependencies, Set<ResourceLocation> includes, @Nullable ResourceLocation name, boolean sourceFile) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable ResourceLocation name, String source) throws IOException {
            PreProcessorContext context = new PreProcessorContext(this.preProcessor, this.definition, this.preDefinitions, this.type, this.uniformBindings, this.dependencies, this.includes, name, false);
            return this.preProcessor.modify(context, source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put(name, binding);
        }

        @Override
        public void addDefinitionDependency(String name) {
            this.dependencies.add(name);
        }

        @Override
        public void addInclude(ResourceLocation name) {
            this.includes.add(name);
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }

        @Override
        @Nullable
        public String shaderInstance() {
            return null;
        }

        @Override
        @Nullable
        public VertexFormat vertexFormat() {
            return null;
        }
    }

    private record ReloadState(Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, VeilShaderSource> shaderSources) {
    }
}

