/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import foundry.veil.api.client.necromancer.Bone;
import foundry.veil.api.client.necromancer.SkeletonParent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Skeleton<P extends SkeletonParent> {
    public List<Bone> roots = new ArrayList<Bone>();
    public Map<String, Bone> bones = new HashMap<String, Bone>();

    public void tick() {
        for (Bone part : this.bones.values()) {
            part.updatePreviousPosition();
        }
        for (Bone bone : this.bones.values()) {
            bone.tick(0.05f);
        }
    }

    public void addBone(Bone part) {
        this.bones.put(part.identifier, part);
    }

    public void buildRoots() {
        for (Bone part : this.bones.values()) {
            if (part.parent == null) {
                this.roots.add(part);
                continue;
            }
            Bone parentBone = part.parent;
            while (parentBone != null) {
                part.parentChain.add(parentBone);
                parentBone = parentBone.parent;
            }
            Collections.reverse(part.parentChain);
        }
    }
}

