/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.necromancer.render.Skin;
import foundry.veil.api.client.necromancer.render.mesh.Mesh;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Bone {
    public float x;
    public float y;
    public float z;
    public float pX;
    public float pY;
    public float pZ;
    public Quaternionf rotation;
    public Quaternionf pRotation;
    protected Quaternionf currentRotation;
    public float xSize;
    public float ySize;
    public float zSize;
    public float pXSize;
    public float pYSize;
    public float pZSize;
    public float initialX;
    public float initialY;
    public float initialZ;
    public Quaternionf initialRotation;
    public float initialXSize;
    public float initialYSize;
    public float initialZSize;
    @Nullable
    public Bone parent;
    public List<Bone> children;
    public final String identifier;
    public boolean shouldRender = true;
    public List<Bone> parentChain;

    public Bone(String identifier) {
        this.identifier = identifier;
        this.rotation = new Quaternionf();
        this.pRotation = new Quaternionf();
        this.currentRotation = new Quaternionf();
        this.initialRotation = new Quaternionf();
        this.xSize = 1.0f;
        this.ySize = 1.0f;
        this.zSize = 1.0f;
        this.pXSize = 1.0f;
        this.pYSize = 1.0f;
        this.pZSize = 1.0f;
        this.initialXSize = 1.0f;
        this.initialYSize = 1.0f;
        this.initialZSize = 1.0f;
        this.children = new ArrayList<Bone>();
        this.parentChain = new ArrayList<Bone>();
    }

    public void setInitialTransform(float x, float y, float z, Quaternionf rotation) {
        this.initialX = x;
        this.initialY = y;
        this.initialZ = z;
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.pX = this.initialX;
        this.pY = this.initialY;
        this.pZ = this.initialZ;
        this.initialRotation.set((Quaternionfc)rotation);
        this.rotation.set((Quaternionfc)this.initialRotation);
        this.pRotation.set((Quaternionfc)this.initialRotation);
        this.currentRotation.set((Quaternionfc)this.initialRotation);
    }

    public void reset() {
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.rotation.set((Quaternionfc)this.initialRotation);
        this.xSize = this.initialXSize;
        this.ySize = this.initialYSize;
        this.zSize = this.initialZSize;
    }

    protected void updatePreviousPosition() {
        this.pX = this.x;
        this.pY = this.y;
        this.pZ = this.z;
        this.pRotation.set((Quaternionfc)this.rotation);
        this.pXSize = this.xSize;
        this.pYSize = this.ySize;
        this.pZSize = this.zSize;
    }

    public void setGlobalSpaceRotation(Quaternionf globalSpaceRotation) {
        Quaternionf parentRotation = new Quaternionf();
        for (Bone bone : this.parentChain) {
            parentRotation.mul((Quaternionfc)bone.rotation);
        }
        parentRotation.difference((Quaternionfc)globalSpaceRotation, this.rotation);
    }

    public void setModelSpaceTransform(Vector3f position, Quaternionf rotation) {
        Matrix4f parentTransform = new Matrix4f();
        for (Bone bone : this.parentChain) {
            parentTransform.translate(bone.x, bone.y, bone.z);
            parentTransform.rotate((Quaternionfc)bone.rotation);
            parentTransform.scale(bone.xSize, bone.ySize, bone.zSize);
        }
        Matrix4f modelSpaceBoneTransform = new Matrix4f().translate((Vector3fc)position).rotate((Quaternionfc)rotation);
        modelSpaceBoneTransform.mul((Matrix4fc)parentTransform.invert());
    }

    protected void tick(float deltaTime) {
    }

    public void transform(PoseStack pPoseStack, float partialTick) {
        pPoseStack.translate(Mth.lerp((float)partialTick, (float)this.pX, (float)this.x), Mth.lerp((float)partialTick, (float)this.pY, (float)this.y), Mth.lerp((float)partialTick, (float)this.pZ, (float)this.z));
        this.currentRotation = this.pRotation.slerp((Quaternionfc)this.rotation, partialTick, this.currentRotation);
        this.currentRotation.normalize();
        pPoseStack.mulPose(this.currentRotation);
        pPoseStack.scale(Mth.lerp((float)partialTick, (float)this.pXSize, (float)this.xSize), Mth.lerp((float)partialTick, (float)this.pYSize, (float)this.ySize), Mth.lerp((float)partialTick, (float)this.pZSize, (float)this.zSize));
    }

    public void transform(Matrix4f matrix4f, float partialTick) {
        matrix4f.translate(Mth.lerp((float)partialTick, (float)this.pX, (float)this.x), Mth.lerp((float)partialTick, (float)this.pY, (float)this.y), Mth.lerp((float)partialTick, (float)this.pZ, (float)this.z));
        this.currentRotation = this.pRotation.slerp((Quaternionfc)this.rotation, partialTick, this.currentRotation);
        this.currentRotation.normalize();
        matrix4f.rotate((Quaternionfc)this.currentRotation);
        matrix4f.scale(Mth.lerp((float)partialTick, (float)this.pXSize, (float)this.xSize), Mth.lerp((float)partialTick, (float)this.pYSize, (float)this.ySize), Mth.lerp((float)partialTick, (float)this.pZSize, (float)this.zSize));
    }

    public void render(Skin skin, float partialTick, PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha, boolean drawChildren) {
        if (!this.shouldRender) {
            return;
        }
        Mesh mesh = skin.getMesh(this);
        pPoseStack.pushPose();
        this.transform(pPoseStack, partialTick);
        mesh.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        if (drawChildren) {
            for (Bone child : this.children) {
                child.render(skin, partialTick, pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha, true);
            }
        }
        pPoseStack.popPose();
    }

    public void addChild(Bone children) {
        if (children.parent != null) {
            children.parent.children.remove(children);
        }
        this.children.add(children);
        children.parent = this;
    }

    public void setParent(Bone parent) {
        this.parent = parent;
        parent.children.add(this);
    }

    public Matrix4f getModelSpaceTransformMatrix(PoseStack pPoseStack, float partialTick) {
        Bone parent = this.parent;
        if (parent != null) {
            parent.getModelSpaceTransformMatrix(pPoseStack, partialTick);
        }
        this.transform(pPoseStack, partialTick);
        return pPoseStack.last().pose();
    }

    public void rotate(float angle, Direction.Axis axis) {
        switch (axis) {
            case X: {
                this.rotation.rotateX(angle);
                break;
            }
            case Y: {
                this.rotation.rotateY(angle);
                break;
            }
            case Z: {
                this.rotation.rotateZ(angle);
            }
        }
    }

    public void rotateDeg(float angle, Direction.Axis axis) {
        switch (axis) {
            case X: {
                this.rotation.rotateX(angle * ((float)Math.PI / 180));
                break;
            }
            case Y: {
                this.rotation.rotateY(angle * ((float)Math.PI / 180));
                break;
            }
            case Z: {
                this.rotation.rotateZ(angle * ((float)Math.PI / 180));
            }
        }
    }
}

