/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import foundry.veil.Veil;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.impl.glsl.GlslInjectionPoint;
import foundry.veil.impl.glsl.GlslParser;
import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.visitor.GlslStringWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamicBufferProcessor
implements ShaderPreProcessor {
    private final DynamicBufferType[] types;

    public DynamicBufferProcessor(DynamicBufferType[] types) {
        this.types = types;
    }

    @Override
    public String modify(ShaderPreProcessor.Context ctx, String source) throws IOException {
        try {
            GlslTree tree = GlslParser.parse(source);
            Map<String, GlslNode> markers = tree.getMarkers();
            GlslFunctionNode mainFunction = tree.mainFunction().orElseThrow();
            boolean modified = false;
            for (int i = 0; i < this.types.length; ++i) {
                Object type = this.types[i];
                GlslNode node2 = markers.get("veil:" + type.getName());
                if (node2 == null || ctx.type() != 35632) continue;
                modified = true;
                String fieldName = type.getSourceName();
                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("layout(location = " + (1 + i) + ") out " + type.getType() + " " + fieldName));
                if (!(node2 instanceof GlslNewNode)) continue;
                GlslNewNode newNode = (GlslNewNode)node2;
                mainFunction.getBody().add(GlslParser.parseExpression(fieldName + " = " + newNode.getName()));
            }
            if (modified) {
                ArrayList outputs = new ArrayList();
                tree.fields().forEach(node -> {
                    block10: {
                        GlslSpecifiedType type = node.getType();
                        boolean valid = false;
                        for (GlslTypeQualifier qualifier : type.getQualifiers()) {
                            if (qualifier != GlslTypeQualifier.StorageType.OUT) continue;
                            valid = true;
                            break;
                        }
                        if (!valid) {
                            return;
                        }
                        block5: for (GlslTypeQualifier qualifier : type.getQualifiers()) {
                            List<GlslTypeQualifier.LayoutId> patt1$temp;
                            if (!(qualifier instanceof GlslTypeQualifier.Layout)) continue;
                            GlslTypeQualifier.Layout $b$0 = (GlslTypeQualifier.Layout)qualifier;
                            List<GlslTypeQualifier.LayoutId> layoutIds = patt1$temp = $b$0.layoutIds();
                            for (GlslTypeQualifier.LayoutId layoutId : layoutIds) {
                                GlslNode expression;
                                if (!"location".equals(layoutId.identifier()) || (expression = layoutId.expression()) == null) continue;
                                try {
                                    int location = Integer.parseInt(expression.getSourceString());
                                    if (location == 0) {
                                        outputs.clear();
                                        return;
                                    }
                                    valid = false;
                                    continue block5;
                                }
                                catch (NumberFormatException numberFormatException) {
                                }
                            }
                        }
                        if (valid) {
                            outputs.add(node);
                        }
                        break block10;
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                });
                for (GlslNewNode output : outputs) {
                    output.getType().addLayoutId("location", GlslNode.intConstant(0));
                }
                GlslStringWriter writer = new GlslStringWriter();
                tree.visit(writer);
                return writer.toString();
            }
        }
        catch (GlslSyntaxException e) {
            Veil.LOGGER.error("Failed to transform shader: {}", (Object)ctx.name(), (Object)e);
        }
        return source;
    }
}

