/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.Window;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.molang.VeilMolang;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.FramebufferResource;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.exception.MolangSyntaxException;
import imgui.ImDrawList;
import imgui.ImFont;
import imgui.ImFontGlyph;
import imgui.ImGui;
import imgui.ImGuiStyle;
import imgui.ImVec4;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class FramebufferFileEditor
implements ResourceFileEditor<FramebufferResource> {
    private static final StringBuilder BUILDER = new StringBuilder();
    private final ImBoolean open;
    private FramebufferResource resource;
    private FramebufferDefinitionBuilder builder;
    private final ImString widthInput = new ImString();
    private final ImString heightInput = new ImString();
    private BitSet enabledBuffers;
    private int attachmentIndex;
    private FramebufferAttachmentDefinition.Type type;
    private FramebufferAttachmentDefinition.Format format;
    private FramebufferAttachmentDefinition.DataType dataType;
    private boolean linear;
    private int levels;
    private String name;

    public FramebufferFileEditor() {
        this.open = new ImBoolean(false);
    }

    @Override
    public void render() {
        if (this.resource == null || !this.open.get()) {
            return;
        }
        if (ImGui.begin("Framebuffer Editor: " + this.resource.resourceInfo().fileName() + "###framebuffer_editor")) {
            ResourceLocation id;
            FramebufferManager framebufferManager;
            AdvancedFbo fbo;
            Window window = Minecraft.getInstance().getWindow();
            MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", window.getWidth()).setQuery("screen_height", window.getHeight()).create();
            float definitionWidth = 1.0f;
            float definitionHeight = 1.0f;
            try {
                definitionWidth = runtime.resolve(this.builder.getWidth());
                definitionHeight = runtime.resolve(this.builder.getHeight());
            }
            catch (MolangRuntimeException e) {
                e.printStackTrace();
            }
            float aspectRatio = definitionHeight / definitionWidth;
            float lineHeight = ImGui.getTextLineHeightWithSpacing();
            float boxWidth = ImGui.getContentRegionAvailX() / 2.0f;
            float boxHeight = boxWidth * aspectRatio;
            ImGui.pushStyleVar(2, 0.0f, 0.0f);
            if (ImGui.beginChild("##size", boxWidth, boxHeight, true) && (fbo = (framebufferManager = VeilRenderSystem.renderer().getFramebufferManager()).getFramebuffer(id = FramebufferManager.FRAMEBUFFER_LISTER.fileToId(this.resource.resourceInfo().location()))) != null) {
                int textureId = 0;
                if (this.attachmentIndex == 0) {
                    if (fbo.isDepthTextureAttachment()) {
                        textureId = fbo.getDepthTextureAttachment().getId();
                    }
                } else if (fbo.isColorTextureAttachment(this.attachmentIndex - 1)) {
                    textureId = fbo.getColorTextureAttachment(this.attachmentIndex - 1).getId();
                }
                if (textureId > 0) {
                    ImGui.image(textureId, boxWidth, boxHeight, 0.0f, 1.0f, 1.0f, 0.0f);
                }
            }
            ImGui.endChild();
            ImGui.popStyleVar();
            VeilImGuiUtil.textCentered(Integer.toString((int)definitionWidth), boxWidth);
            if (ImGui.beginChild("##panel", ImGui.getContentRegionAvailX() / 2.0f, ImGui.getContentRegionAvailY())) {
                ImGui.text("Framebuffer Settings:");
                this.renderFramebufferSettings();
                ImGui.newLine();
                ImGui.text("Attachment Settings:");
                this.renderAttachmentSettings();
            }
            ImGui.endChild();
            String heightString = Integer.toString((int)definitionHeight);
            ImFont font = ImGui.getFont();
            float width = font.calcTextSizeAX(ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, heightString);
            ImGui.setCursorPos(ImGui.getCursorStartPosX() + boxWidth, ImGui.getCursorStartPosY() + boxHeight / 2.0f + width / 2.0f);
            FramebufferFileEditor.drawVerticalText(heightString);
            ImGui.setCursorPos(ImGui.getCursorStartPosX() + ImGui.getContentRegionMaxX() / 2.0f + lineHeight, ImGui.getCursorStartPosY());
            ImGui.beginGroup();
            if (ImGui.beginListBox("##buffers", ImGui.getContentRegionAvailX(), ImGui.getContentRegionAvailY() - ImGui.getFrameHeight() - ImGui.getStyle().getFramePaddingY() * 2.0f)) {
                float itemWidth = ImGui.getContentRegionAvailX();
                boolean useDepth = this.enabledBuffers.get(0);
                if (useDepth) {
                    if (ImGui.invisibleButton("##depth", itemWidth, lineHeight * 4.0f)) {
                        this.setAttachment(0);
                    }
                    if (this.builder.getDepthBuffer() == null) {
                        this.builder.setDepthBuffer(new FramebufferAttachmentDefinition(FramebufferAttachmentDefinition.Type.TEXTURE, FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT, FramebufferAttachmentDefinition.DataType.FLOAT, true, false, 0, null));
                    }
                    FramebufferFileEditor.drawBuffer("Depth Buffer", this.builder.getDepthBuffer(), itemWidth, this.attachmentIndex == 0);
                }
                for (int i = 0; i < this.enabledBuffers.size() - 1; ++i) {
                    FramebufferAttachmentDefinition[] colorBuffers;
                    boolean enabled = this.enabledBuffers.get(i + 1);
                    if (!enabled) continue;
                    if (ImGui.invisibleButton("##color" + i, itemWidth, lineHeight * 4.0f)) {
                        this.setAttachment(i + 1);
                    }
                    if ((colorBuffers = this.builder.getColorBuffers())[i] == null) {
                        this.builder.setColorBuffer(i, new FramebufferAttachmentDefinition(FramebufferAttachmentDefinition.Type.TEXTURE, FramebufferAttachmentDefinition.Format.RGBA8, FramebufferAttachmentDefinition.DataType.UNSIGNED_BYTE, false, false, 0, null));
                    }
                    FramebufferFileEditor.drawBuffer("Color Buffer " + i, colorBuffers[i], itemWidth, this.attachmentIndex == i + 1);
                }
                ImGui.endListBox();
            }
            if (ImGui.checkbox("Use Depth", this.enabledBuffers.get(0))) {
                this.enabledBuffers.flip(0);
                if (this.attachmentIndex == 0 && !this.enabledBuffers.get(0)) {
                    this.setAttachment(1);
                }
            }
            ImGui.endGroup();
        }
        ImGui.end();
    }

    private static void drawBuffer(String name, FramebufferAttachmentDefinition attachment, float width, boolean selected) {
        ImGuiStyle style = ImGui.getStyle();
        float lineHeight = ImGui.getTextLineHeightWithSpacing();
        boolean hovered = ImGui.isItemHovered();
        boolean active = selected || ImGui.isItemActive();
        ImGui.sameLine();
        ImGui.setCursorPosX(ImGui.getCursorStartPosX());
        ImVec4 col = new ImVec4();
        style.getColor(active ? 23 : (hovered ? 22 : 21), col);
        int colorU32 = ImGui.getColorU32(col.x, col.y, col.z, col.w);
        float x = ImGui.getCursorScreenPosX();
        float y = ImGui.getCursorScreenPosY();
        ImGui.getWindowDrawList().addRectFilled(x, y, x + width, y + lineHeight * 4.0f, colorU32);
        ImGui.setCursorPosX(ImGui.getCursorPosX() + style.getFramePaddingX());
        ImGui.beginGroup();
        boolean texture = attachment.type() == FramebufferAttachmentDefinition.Type.TEXTURE;
        FramebufferFileEditor.text(builder -> {
            builder.append(name);
            if (attachment.name() != null) {
                builder.append(" (").append(attachment.name()).append(")");
            }
        });
        FramebufferFileEditor.text(builder -> {
            builder.append(attachment.type().getDisplayName());
            if (texture) {
                builder.append(attachment.linear() ? " Linear" : " Nearest");
            }
        });
        FramebufferFileEditor.text(builder -> builder.append(attachment.format().name()).append(" ").append(attachment.dataType().name()));
        FramebufferFileEditor.text(builder -> builder.append(attachment.levels()).append(texture ? " Mipmaps" : " Samples"));
        ImGui.endGroup();
    }

    private static void text(Consumer<StringBuilder> text) {
        text.accept(BUILDER);
        ImGui.text(BUILDER.toString());
        BUILDER.setLength(0);
    }

    private static void drawVerticalText(String next) {
        ImFont font = ImGui.getFont();
        float pad = ImGui.getStyle().getFramePaddingX();
        float posX = ImGui.getCursorScreenPosX() + pad;
        float posY = ImGui.getCursorScreenPosY() + pad;
        ImDrawList drawList = ImGui.getWindowDrawList();
        for (int i = 0; i < next.length(); ++i) {
            int codePoint = next.codePointAt(i);
            ImFontGlyph glyph = font.findGlyph(codePoint);
            drawList.primReserve(6, 4);
            drawList.primQuadUV((int)(posX + glyph.getY1()), (int)((posY -= font.getCharAdvance(codePoint)) + glyph.getX0()), (int)(posX + glyph.getY1()), (int)(posY + glyph.getX1()), (int)(posX + glyph.getY0()), (int)(posY + glyph.getX1()), (int)(posX + glyph.getY0()), (int)(posY + glyph.getX0()), glyph.getU1(), glyph.getV1(), glyph.getU0(), glyph.getV1(), glyph.getU0(), glyph.getV0(), glyph.getU1(), glyph.getV0(), -1);
        }
    }

    private void renderFramebufferSettings() {
        if (ImGui.inputText("Width", this.widthInput, 32)) {
            try {
                this.builder.setWidth(VeilMolang.get().compile(this.widthInput.get()));
            }
            catch (MolangSyntaxException e) {
                e.printStackTrace();
            }
            this.updateSize();
        }
        if (ImGui.inputText("Height", this.heightInput, 32)) {
            try {
                this.builder.setHeight(VeilMolang.get().compile(this.heightInput.get()));
            }
            catch (MolangSyntaxException e) {
                e.printStackTrace();
            }
            this.updateSize();
        }
    }

    private void renderAttachmentSettings() {
        if (ImGui.beginCombo("Type", this.type.getDisplayName())) {
            for (FramebufferAttachmentDefinition.Type type : FramebufferAttachmentDefinition.Type.values()) {
                if (!ImGui.selectable(type.getDisplayName())) continue;
                this.type = type;
                this.saveAttachment();
            }
            ImGui.endCombo();
        }
    }

    private void updateSize() {
        String width = this.builder.getWidth().toString();
        if (width.startsWith("return")) {
            this.widthInput.set(width.substring(7));
        } else {
            this.widthInput.set(width);
        }
        String height = this.builder.getHeight().toString();
        if (height.startsWith("return")) {
            this.heightInput.set(height.substring(7));
        } else {
            this.heightInput.set(height);
        }
    }

    private void saveAttachment() {
        if (this.attachmentIndex == 0) {
            this.builder.setDepthBuffer(new FramebufferAttachmentDefinition(this.type, this.format, this.dataType, true, this.linear, this.levels, this.name));
        } else {
            this.builder.setColorBuffer(this.attachmentIndex - 1, new FramebufferAttachmentDefinition(this.type, this.format, this.dataType, false, this.linear, this.levels, this.name));
        }
    }

    private void setAttachment(int attachmentIndex) {
        FramebufferAttachmentDefinition buffer;
        this.attachmentIndex = attachmentIndex;
        if (this.attachmentIndex == 0) {
            buffer = this.builder.getDepthBuffer();
        } else {
            FramebufferAttachmentDefinition[] colorBuffers = this.builder.getColorBuffers();
            if (attachmentIndex < 1 || attachmentIndex >= colorBuffers.length + 1) {
                return;
            }
            buffer = colorBuffers[attachmentIndex - 1];
        }
        if (buffer != null) {
            this.type = buffer.type();
            this.format = buffer.format();
            this.dataType = buffer.dataType();
            this.linear = buffer.linear();
            this.levels = buffer.levels();
            this.name = buffer.name();
        }
    }

    @Override
    public void open(VeilEditorEnvironment environment, FramebufferResource resource) {
        this.open.set(true);
        this.resource = resource;
        ResourceManager resourceManager = environment.getResourceManager().clientResources();
        ResourceLocation location = resource.resourceInfo().location();
        try (BufferedReader reader = resourceManager.getResourceOrThrow(location).openAsReader();){
            DataResult result = FramebufferDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader));
            if (result.error().isPresent()) {
                throw new JsonParseException(((DataResult.Error)result.error().get()).message());
            }
            this.builder = new FramebufferDefinitionBuilder((FramebufferDefinition)result.result().orElseThrow());
        }
        catch (IOException e) {
            Veil.LOGGER.error("Failed to open resource: {}", (Object)location, (Object)e);
            this.builder = new FramebufferDefinitionBuilder();
        }
        if (this.enabledBuffers == null) {
            this.enabledBuffers = new BitSet(VeilRenderSystem.maxColorAttachments() + 1);
        }
        FramebufferAttachmentDefinition[] colorBuffers = this.builder.getColorBuffers();
        this.enabledBuffers.set(0, this.builder.getDepthBuffer() != null);
        for (int i = 0; i < colorBuffers.length; ++i) {
            this.enabledBuffers.set(i + 1, colorBuffers[i] != null);
        }
        this.updateSize();
        this.setAttachment(1);
    }

    private static class FramebufferDefinitionBuilder {
        private MolangExpression width;
        private MolangExpression height;
        private final FramebufferAttachmentDefinition[] colorBuffers;
        @Nullable
        private FramebufferAttachmentDefinition depthBuffer;
        private boolean autoClear;

        public FramebufferDefinitionBuilder() {
            this.width = FramebufferDefinition.DEFAULT_WIDTH;
            this.height = FramebufferDefinition.DEFAULT_HEIGHT;
            this.colorBuffers = new FramebufferAttachmentDefinition[VeilRenderSystem.maxColorAttachments()];
            this.depthBuffer = null;
            this.autoClear = true;
        }

        public FramebufferDefinitionBuilder(FramebufferDefinition definition) {
            this.width = definition.width();
            this.height = definition.height();
            this.colorBuffers = Arrays.copyOf(definition.colorBuffers(), VeilRenderSystem.maxColorAttachments());
            this.depthBuffer = definition.depthBuffer();
            this.autoClear = definition.autoClear();
        }

        public void setWidth(MolangExpression width) {
            this.width = width;
        }

        public void setHeight(MolangExpression height) {
            this.height = height;
        }

        public void setColorBuffer(int index, FramebufferAttachmentDefinition colorBuffer) {
            this.colorBuffers[index] = colorBuffer;
        }

        public void setDepthBuffer(@Nullable FramebufferAttachmentDefinition depthBuffer) {
            this.depthBuffer = depthBuffer;
        }

        public void setAutoClear(boolean autoClear) {
            this.autoClear = autoClear;
        }

        public MolangExpression getWidth() {
            return this.width;
        }

        public MolangExpression getHeight() {
            return this.height;
        }

        public FramebufferAttachmentDefinition[] getColorBuffers() {
            return this.colorBuffers;
        }

        @Nullable
        public FramebufferAttachmentDefinition getDepthBuffer() {
            return this.depthBuffer;
        }

        public boolean isAutoClear() {
            return this.autoClear;
        }
    }
}

