/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import foundry.veil.Veil;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.impl.glsl.GlslInjectionPoint;
import foundry.veil.impl.glsl.GlslParser;
import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.visitor.GlslStringWriter;
import java.io.IOException;
import java.util.Map;

public class DynamicBufferProcessor
implements ShaderPreProcessor {
    private final DynamicBufferType[] types;

    public DynamicBufferProcessor(DynamicBufferType[] types) {
        this.types = types;
    }

    @Override
    public String modify(ShaderPreProcessor.Context ctx, String source) throws IOException {
        try {
            GlslTree tree = GlslParser.parse(source);
            Map<String, GlslNode> markers = tree.getMarkers();
            GlslFunctionNode mainFunction = tree.mainFunction().orElseThrow();
            boolean modified = false;
            for (int i = 0; i < this.types.length; ++i) {
                DynamicBufferType type = this.types[i];
                GlslNode node = markers.get("veil:" + type.getName());
                if (node == null || ctx.type() != 35632) continue;
                modified = true;
                String fieldName = type.getSourceName();
                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("layout(location = " + (1 + i) + ") out " + type.getType() + " " + fieldName));
                if (!(node instanceof GlslNewNode)) continue;
                GlslNewNode newNode = (GlslNewNode)node;
                mainFunction.getBody().add(GlslParser.parseExpression(fieldName + " = " + newNode.getName()));
            }
            if (modified) {
                GlslStringWriter writer = new GlslStringWriter();
                tree.visit(writer);
                return writer.toString();
            }
        }
        catch (GlslSyntaxException e) {
            Veil.LOGGER.error("Failed to transform shader: {}", (Object)ctx.name(), (Object)e);
        }
        return source;
    }
}

