/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.program.MutableUniformAccess;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2f;
import org.joml.Matrix2fc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.joml.Vector4ic;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL41C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public interface ShaderProgram
extends NativeResource,
MutableUniformAccess,
TextureUniformAccess {
    default public void setup() {
        this.bind();
        this.applyRenderSystem();
        this.addRenderSystemTextures();
        this.applyShaderSamplers(0);
    }

    default public void bind() {
        GL41C.glUseProgram((int)this.getProgram());
    }

    public static void unbind() {
        GL41C.glUseProgram((int)0);
    }

    public void compile(ShaderCompiler.Context var1, ShaderCompiler var2) throws ShaderException, IOException;

    public int getProgram();

    @Override
    default public float getFloat(CharSequence name) {
        return GL41C.glGetUniformf((int)this.getProgram(), (int)this.getUniform(name));
    }

    @Override
    default public int getInt(CharSequence name) {
        return GL41C.glGetUniformi((int)this.getProgram(), (int)this.getUniform(name));
    }

    @Override
    default public void getFloats(CharSequence name, float[] values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i] = buffer.get(i);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector2f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 2);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 2, buffer);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector3f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 3);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 3, buffer);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector4f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 4);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 4, buffer);
            }
        }
    }

    @Override
    default public void getInts(CharSequence name, int[] values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length);
            GL41C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i] = buffer.get(i);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector2i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 2);
            GL41C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 2, buffer);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector3i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 3);
            GL41C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 3, buffer);
            }
        }
    }

    @Override
    default public void getVector(CharSequence name, Vector4i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 4);
            GL41C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 4, buffer);
            }
        }
    }

    @Override
    default public void getMatrix(CharSequence name, Matrix2f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(4);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    @Override
    default public void getMatrix(CharSequence name, Matrix3f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(9);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    @Override
    default public void getMatrix(CharSequence name, Matrix3x2f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(6);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    @Override
    default public void getMatrix(CharSequence name, Matrix4f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    @Override
    default public void getMatrix(CharSequence name, Matrix4x3f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(12);
            GL41C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    @Override
    default public void setUniformBlock(CharSequence name, int binding) {
        int index = this.getUniformBlock(name);
        if (index != -1) {
            GL31C.glUniformBlockBinding((int)this.getProgram(), (int)index, (int)binding);
        }
    }

    @Override
    default public void setStorageBlock(CharSequence name, int binding) {
        int index = this.getStorageBlock(name);
        if (index != -1) {
            GL43C.glShaderStorageBlockBinding((int)this.getProgram(), (int)index, (int)binding);
        }
    }

    @Override
    default public void setFloat(CharSequence name, float value) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1f((int)this.getProgram(), (int)location, (float)value);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform2f((int)this.getProgram(), (int)location, (float)x, (float)y);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y, float z) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform3f((int)this.getProgram(), (int)location, (float)x, (float)y, (float)z);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y, float z, float w) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform4f((int)this.getProgram(), (int)location, (float)x, (float)y, (float)z, (float)w);
        }
    }

    @Override
    default public void setInt(CharSequence name, int value) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1i((int)this.getProgram(), (int)location, (int)value);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform2i((int)this.getProgram(), (int)location, (int)x, (int)y);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y, int z) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform3i((int)this.getProgram(), (int)location, (int)x, (int)y, (int)z);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y, int z, int w) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform4i((int)this.getProgram(), (int)location, (int)x, (int)y, (int)z, (int)w);
        }
    }

    @Override
    default public void setFloats(CharSequence name, float ... values) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1fv((int)this.getProgram(), (int)location, (float[])values);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector2fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 2);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 2, buffer);
            }
            GL41C.glProgramUniform2fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector3fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 3);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 3, buffer);
            }
            GL41C.glProgramUniform3fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector4fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 4);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 4, buffer);
            }
            GL41C.glProgramUniform4fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setInts(CharSequence name, int ... values) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1iv((int)this.getProgram(), (int)location, (int[])values);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector2ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 2);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 2, buffer);
            }
            GL41C.glProgramUniform2iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector3ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 3);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 3, buffer);
            }
            GL41C.glProgramUniform3iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector4ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 4);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 4, buffer);
            }
            GL41C.glProgramUniform4iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix2fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(4);
            value.get(buffer);
            GL41C.glProgramUniformMatrix2fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix3fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(9);
            value.get(buffer);
            GL41C.glProgramUniformMatrix3fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix3x2fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(6);
            value.get(buffer);
            GL41C.glProgramUniformMatrix3x2fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix4fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            value.get(buffer);
            GL41C.glProgramUniformMatrix4fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix4x3fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(12);
            value.get(buffer);
            GL41C.glProgramUniformMatrix4x3fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Nullable
    public ProgramDefinition getDefinition();

    public Int2ObjectMap<CompiledShader> getShaders();

    default public boolean isCompute() {
        return this.getShaders().containsKey(37305);
    }

    default public boolean hasGeometry() {
        return this.getShaders().containsKey(36313);
    }

    default public boolean hasTesselation() {
        Int2ObjectMap<CompiledShader> shaders = this.getShaders();
        return shaders.containsKey(36488) && shaders.containsKey(36487);
    }

    public Set<String> getDefinitionDependencies();

    public ResourceLocation getId();

    public ShaderInstance toShaderInstance();

    public static ShaderProgram create(ResourceLocation id) {
        return new ShaderProgramImpl(id);
    }
}

