/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.deferred.light.VanillaLightRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class LightRenderer
implements NativeResource {
    private final Map<LightTypeRegistry.LightType<?>, LightData<?>> lights = new HashMap();
    private VanillaLightRenderer vanillaLightRenderer;
    private boolean vanillaLightEnabled = true;
    private boolean ambientOcclusionEnabled = true;
    private AdvancedFbo framebuffer;

    public void applyShader() {
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader == null) {
            return;
        }
        shader.bind();
        if (this.framebuffer != null) {
            shader.setFramebufferSamplers(this.framebuffer);
            shader.setVector("ScreenSize", this.framebuffer.getWidth(), this.framebuffer.getHeight());
        } else {
            shader.setVector("ScreenSize", 1.0f, 1.0f);
        }
        shader.applyShaderSamplers(0);
    }

    @ApiStatus.Internal
    public void setup(CullFrustum frustum) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.depthMask((boolean)false);
        for (Map.Entry<LightTypeRegistry.LightType<?>, LightData<?>> entry : this.lights.entrySet()) {
            entry.getValue().prepare(this, frustum);
        }
    }

    @ApiStatus.Internal
    public void clear() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    @ApiStatus.Internal
    public void render(AdvancedFbo framebuffer) {
        ClientLevel level;
        this.framebuffer = framebuffer;
        for (LightData<?> value : this.lights.values()) {
            value.render(this);
        }
        if (this.vanillaLightEnabled && (level = Minecraft.getInstance().level) != null) {
            if (this.vanillaLightRenderer == null) {
                this.vanillaLightRenderer = new VanillaLightRenderer();
            }
            this.vanillaLightRenderer.render(this, level);
        }
        this.framebuffer = null;
    }

    public void addLight(Light light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        this.lights.computeIfAbsent(light.getType(), LightData::new).addLight(light);
    }

    public <T extends Light> void removeLight(T light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        LightData<?> data = this.lights.get(light.getType());
        if (data != null) {
            data.removedLights.add(light);
        }
    }

    public <T extends Light> List<T> getLights(LightTypeRegistry.LightType<? extends T> type) {
        LightData<?> data = this.lights.get(type);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.lightsView;
    }

    public void enableVanillaLight() {
        this.vanillaLightEnabled = true;
    }

    public void disableVanillaLight() {
        this.vanillaLightEnabled = false;
        if (this.vanillaLightRenderer != null) {
            this.vanillaLightRenderer.free();
            this.vanillaLightRenderer = null;
        }
    }

    public void enableAmbientOcclusion() {
        if (!this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = true;
            Minecraft.getInstance().levelRenderer.allChanged();
        }
    }

    public void disableAmbientOcclusion() {
        if (this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = false;
            Minecraft.getInstance().levelRenderer.allChanged();
        }
    }

    @Nullable
    public AdvancedFbo getFramebuffer() {
        return this.framebuffer;
    }

    public boolean isVanillaLightEnabled() {
        return this.vanillaLightEnabled;
    }

    public boolean isAmbientOcclusionEnabled() {
        return this.ambientOcclusionEnabled;
    }

    @Override
    public void free() {
        this.lights.values().forEach(LightData::free);
        this.lights.clear();
        if (this.vanillaLightRenderer != null) {
            this.vanillaLightRenderer.free();
            this.vanillaLightRenderer = null;
        }
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        int visible = this.lights.values().stream().mapToInt(data -> data.renderer.getVisibleLights()).sum();
        int all = this.lights.values().stream().mapToInt(data -> data.lights.size()).sum();
        consumer.accept("Lights: " + visible + " / " + all);
    }

    @ApiStatus.Internal
    private static class LightData<T extends Light>
    implements NativeResource {
        private final LightTypeRenderer<T> renderer;
        private final List<T> lights;
        private final List<T> lightsView;
        private final Set<T> removedLights;

        private LightData(LightTypeRenderer<T> renderer) {
            this.renderer = renderer;
            this.lights = new ArrayList<T>();
            this.lightsView = Collections.unmodifiableList(this.lights);
            this.removedLights = new HashSet<T>();
        }

        public LightData(LightTypeRegistry.LightType<?> type) {
            this(Objects.requireNonNull(type, "type").rendererFactory().createRenderer());
        }

        private void prepare(LightRenderer lightRenderer, CullFrustum frustum) {
            this.lights.removeAll(this.removedLights);
            this.renderer.prepareLights(lightRenderer, this.lights, this.removedLights, frustum);
            this.removedLights.clear();
        }

        private void render(LightRenderer lightRenderer) {
            this.renderer.renderLights(lightRenderer, this.lights);
        }

        private void addLight(Light light) {
            this.lights.add(light);
        }

        @Override
        public void free() {
            this.renderer.free();
        }
    }
}

