/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.GuiInfo;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.rendertype.DynamicRenderTypeManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import foundry.veil.mixin.accessor.ReloadableResourceManagerAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilRenderer
implements NativeResource {
    private final DynamicBufferManger dynamicBufferManger = new DynamicBufferManger();
    private final ShaderModificationManager shaderModificationManager = new ShaderModificationManager();
    private final ShaderPreDefinitions shaderPreDefinitions = new ShaderPreDefinitions();
    private final ShaderManager shaderManager = new ShaderManager(ShaderManager.PROGRAM_SET, this.shaderPreDefinitions, this.dynamicBufferManger);
    private final FramebufferManager framebufferManager = new FramebufferManager();
    private final PostProcessingManager postProcessingManager = new PostProcessingManager();
    private final VeilDeferredRenderer deferredRenderer;
    private final DynamicRenderTypeManager dynamicRenderTypeManager;
    private final ParticleSystemManager quasarParticleManager;
    private final EditorManager editorManager;
    private final CameraMatrices cameraMatrices;
    private final GuiInfo guiInfo;

    @ApiStatus.Internal
    public VeilRenderer(ReloadableResourceManager resourceManager) {
        ShaderManager deferredShaderManager = new ShaderManager(ShaderManager.DEFERRED_SET, this.shaderPreDefinitions, this.dynamicBufferManger);
        this.deferredRenderer = new VeilDeferredRenderer(deferredShaderManager, this.shaderPreDefinitions, this.framebufferManager, this.postProcessingManager);
        this.dynamicRenderTypeManager = new DynamicRenderTypeManager();
        this.quasarParticleManager = new ParticleSystemManager();
        this.editorManager = new EditorManager(resourceManager);
        this.cameraMatrices = new CameraMatrices();
        this.guiInfo = new GuiInfo();
        List<PreparableReloadListener> listeners = ((ReloadableResourceManagerAccessor)resourceManager).getListeners();
        listeners.add(0, (PreparableReloadListener)this.shaderModificationManager);
        listeners.add(1, this.shaderManager);
        resourceManager.registerReloadListener((PreparableReloadListener)this.framebufferManager);
        resourceManager.registerReloadListener((PreparableReloadListener)this.postProcessingManager);
        resourceManager.registerReloadListener((PreparableReloadListener)this.deferredRenderer);
        resourceManager.registerReloadListener((PreparableReloadListener)this.dynamicRenderTypeManager);
    }

    public boolean enableBuffers(DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        int active = this.dynamicBufferManger.getActiveBuffers() | DynamicBufferType.encode(buffers);
        return this.dynamicBufferManger.setActiveBuffers(active);
    }

    public boolean disableBuffers(DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        int active = this.dynamicBufferManger.getActiveBuffers() & ~DynamicBufferType.encode(buffers);
        return this.dynamicBufferManger.setActiveBuffers(active);
    }

    public ShaderModificationManager getShaderModificationManager() {
        return this.shaderModificationManager;
    }

    public ShaderPreDefinitions getShaderDefinitions() {
        return this.shaderPreDefinitions;
    }

    public ShaderManager getShaderManager() {
        return this.shaderManager;
    }

    public FramebufferManager getFramebufferManager() {
        return this.framebufferManager;
    }

    public PostProcessingManager getPostProcessingManager() {
        return this.postProcessingManager;
    }

    public VeilDeferredRenderer getDeferredRenderer() {
        return this.deferredRenderer;
    }

    public DynamicRenderTypeManager getDynamicRenderTypeManager() {
        return this.dynamicRenderTypeManager;
    }

    public ParticleSystemManager getParticleManager() {
        return this.quasarParticleManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public CameraMatrices getCameraMatrices() {
        return this.cameraMatrices;
    }

    public GuiInfo getGuiInfo() {
        return this.guiInfo;
    }

    public static boolean hasImGui() {
        return VeilImGuiImpl.get() instanceof VeilImGuiImpl;
    }

    public static CullFrustum getCullingFrustum() {
        return ((LevelRendererExtension)Minecraft.getInstance().levelRenderer).veil$getCullFrustum();
    }

    @Override
    public void free() {
        this.shaderManager.close();
        this.framebufferManager.free();
        this.postProcessingManager.free();
        this.deferredRenderer.free();
        this.quasarParticleManager.clear();
        this.cameraMatrices.free();
        this.guiInfo.free();
    }
}

