/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DynamicBufferManger {
    private static final int[] GL_MAPPING = new int[]{35633, 36488, 36487, 36313, 35632, 37305};
    private int activeBuffers = 0;

    public int getActiveBuffers() {
        return this.activeBuffers;
    }

    public boolean setActiveBuffers(int activeBuffers) {
        if (this.activeBuffers == activeBuffers) {
            return false;
        }
        this.activeBuffers = activeBuffers;
        try {
            VeilRenderSystem.renderer().getShaderManager().setActiveBuffers(activeBuffers);
            for (ShaderInstance shaderInstance : ((GameRendererAccessor)Minecraft.getInstance().gameRenderer).getShaders().values()) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public int getAttachmentIndex(DynamicBufferType type) {
        if ((this.activeBuffers & type.getMask()) == 0) {
            return -1;
        }
        int index = 1;
        for (DynamicBufferType value : DynamicBufferType.values()) {
            if (value == type) break;
            ++index;
        }
        return index;
    }

    public static int getShaderIndex(int glType, int activeBuffers) {
        for (int i = 0; i < GL_MAPPING.length; ++i) {
            if (GL_MAPPING[i] != glType) continue;
            return i | activeBuffers << 4;
        }
        throw new IllegalArgumentException("Invalid GL Shader Type: 0x" + Integer.toHexString(glType).toUpperCase(Locale.ROOT));
    }

    public static int getShaderType(int key) {
        return GL_MAPPING[key & 0xF];
    }
}

