/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.google.common.base.Suppliers;
import foundry.veil.api.TickTaskScheduler;
import foundry.veil.api.quasar.data.ParticleSettings;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.emitters.module.CollisionParticleModule;
import foundry.veil.api.quasar.emitters.module.InitParticleModule;
import foundry.veil.api.quasar.emitters.module.ParticleModule;
import foundry.veil.api.quasar.emitters.module.RenderParticleModule;
import foundry.veil.api.quasar.emitters.module.UpdateParticleModule;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleModuleSet;
import foundry.veil.api.quasar.particle.RenderData;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class QuasarParticle {
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);
    private final ClientLevel level;
    private final RandomSource randomSource;
    private final TickTaskScheduler scheduler;
    private final QuasarParticleData data;
    private final ParticleSettings settings;
    private final ParticleEmitter emitter;
    private final ParticleModuleSet modules;
    private final Vector3d position;
    private final Vector3d velocity;
    private final Vector3f rotation;
    private final BlockPos.MutableBlockPos blockPosition;
    private final boolean hasCollision;
    private float radius;
    private final int lifetime;
    private int age;
    private AABB boundingBox;
    private boolean stoppedByCollision;
    private final Supplier<MolangRuntime> environment;
    private final RenderData renderData;

    public QuasarParticle(ClientLevel level, RandomSource randomSource, TickTaskScheduler scheduler, QuasarParticleData data, ParticleModuleSet modules, ParticleSettings settings, ParticleEmitter emitter) {
        this.level = level;
        this.randomSource = randomSource;
        this.scheduler = scheduler;
        this.data = data;
        this.settings = settings;
        this.emitter = emitter;
        this.modules = modules;
        this.position = new Vector3d();
        this.velocity = new Vector3d();
        this.rotation = new Vector3f();
        this.blockPosition = new BlockPos.MutableBlockPos();
        this.hasCollision = this.modules.getCollisionModules().length > 0;
        this.radius = settings.particleSize(this.randomSource);
        this.lifetime = settings.particleLifetime(this.randomSource);
        this.age = 0;
        this.renderData = new RenderData(data);
        this.environment = Suppliers.memoize(() -> (MolangRuntime)MolangRuntime.runtime().setQuery("x", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().x()))).setQuery("y", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().y()))).setQuery("z", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().z()))).setQuery("velX", MolangExpression.of(() -> Float.valueOf((float)this.velocity.x()))).setQuery("velY", MolangExpression.of(() -> Float.valueOf((float)this.velocity.y()))).setQuery("velZ", MolangExpression.of(() -> Float.valueOf((float)this.velocity.z()))).setQuery("speedSq", MolangExpression.of(() -> Float.valueOf((float)this.velocity.lengthSquared()))).setQuery("speed", MolangExpression.of(() -> Float.valueOf((float)this.velocity.length()))).setQuery("xRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().x())))).setQuery("yRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().y())))).setQuery("zRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().z())))).setQuery("scale", MolangExpression.of(this.renderData::getRenderRadius)).setQuery("age", MolangExpression.of(this.renderData::getRenderAge)).setQuery("agePercent", MolangExpression.of(this.renderData::getAgePercent)).setQuery("lifetime", this.lifetime).create());
    }

    private void move(double dx, double dy, double dz) {
        if (this.stoppedByCollision || dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        AABB box = this.getBoundingBox();
        double d0 = dx;
        double d1 = dy;
        double d2 = dz;
        if (this.hasCollision && dx * dx + dy * dy + dz * dz < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(dx, dy, dz), (AABB)box, (Level)this.level, List.of());
            dx = vec3.x;
            dy = vec3.y;
            dz = vec3.z;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.position.add(dx, dy, dz);
            this.updateBoundingBox();
        }
        if (!this.hasCollision) {
            return;
        }
        List entities = this.level.getEntities(null, box);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive()) continue;
            this.stoppedByCollision = true;
            break;
        }
        if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
            this.stoppedByCollision = true;
        }
        if (d0 != dx) {
            this.velocity.x = 0.0;
            this.stoppedByCollision = true;
        }
        if (d1 != dy) {
            this.velocity.y = 0.0;
            this.stoppedByCollision = true;
        }
        if (d2 != dz) {
            this.velocity.z = 0.0;
            this.stoppedByCollision = true;
        }
        if (this.stoppedByCollision) {
            for (CollisionParticleModule collisionParticle : this.modules.getCollisionModules()) {
                collisionParticle.collide(this);
            }
        }
    }

    private void updateBoundingBox() {
        double r = (double)this.radius / 2.0;
        this.boundingBox = new AABB(this.position.x - r, this.position.y - r, this.position.z - r, this.position.x + r, this.position.y + r, this.position.z + r);
    }

    private int getLightColor() {
        return LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.getBlockPosition());
    }

    @ApiStatus.Internal
    public void init() {
        for (InitParticleModule initModule : this.modules.getInitModules()) {
            initModule.init(this);
        }
        this.renderData.tick(this, this.getLightColor());
        this.updateBoundingBox();
    }

    @ApiStatus.Internal
    public void tick() {
        this.renderData.tick(this, this.getLightColor());
        this.modules.updateEnabled();
        for (UpdateParticleModule updateParticleModule : this.modules.getUpdateModules()) {
            updateParticleModule.update(this);
        }
        for (ParticleModule particleModule : this.modules.getForceModules()) {
            particleModule.applyForce(this);
        }
        this.move(this.velocity.x, this.velocity.y, this.velocity.z);
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
    }

    @ApiStatus.Internal
    public void render(float partialTicks) {
        Iterator<RenderParticleModule> iterator = this.modules.getEnabledRenderModules();
        while (iterator.hasNext()) {
            iterator.next().render(this, partialTicks);
        }
        this.renderData.render(this, partialTicks);
    }

    @ApiStatus.Internal
    public void onRemove() {
        for (ParticleModule module : this.modules.getAllModules()) {
            module.onRemove();
        }
    }

    public void remove() {
        this.age = Integer.MIN_VALUE;
    }

    public boolean isRemoved() {
        return this.age < 0;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    public TickTaskScheduler getScheduler() {
        return this.scheduler;
    }

    public QuasarParticleData getData() {
        return this.data;
    }

    public ParticleSettings getSettings() {
        return this.settings;
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public ParticleModuleSet getModules() {
        return this.modules;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public BlockPos getBlockPosition() {
        return this.blockPosition.set(this.position.x, this.position.y, this.position.z);
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public BlockState getBlockStateInOrUnder() {
        BlockState in = this.level.getBlockState(BlockPos.containing((double)this.position.x, (double)(this.position.y + 0.5), (double)this.position.z));
        if (!in.isAir()) {
            return in;
        }
        return this.level.getBlockState(BlockPos.containing((double)this.position.x, (double)(this.position.y - 0.5), (double)this.position.z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getAge() {
        return this.age;
    }

    public int getLifetime() {
        return this.settings.particleLifetime();
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }

    public RenderData getRenderData() {
        return this.renderData;
    }

    public MolangEnvironment getEnvironment() {
        return this.environment.get();
    }

    public void vectorToRotation(double x, double y, double z) {
        this.rotation.set((float)Math.asin(y), (float)Math.atan2(x, z), 0.0f);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.updateBoundingBox();
    }

    public void setAge(int age) {
        this.age = age;
    }
}

