/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import net.minecraft.util.Mth;

public class Easings {
    public static float ease(float x, Easing eType) {
        return eType.ease(x);
    }

    public static enum Easing implements IEasing
    {
        linear{

            @Override
            public float ease(float x) {
                return x;
            }
        }
        ,
        easeInQuad{

            @Override
            public float ease(float x) {
                return x * x;
            }
        }
        ,
        easeOutQuad{

            @Override
            public float ease(float x) {
                return 1.0f - (1.0f - x) * (1.0f - x);
            }
        }
        ,
        easeInOutQuad{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
            }
        }
        ,
        easeInCubic{

            @Override
            public float ease(float x) {
                return x * x * x;
            }
        }
        ,
        easeOutCubic{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 3.0));
            }
        }
        ,
        easeInOutCubic{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
            }
        }
        ,
        easeInQuart{

            @Override
            public float ease(float x) {
                return x * x * x * x;
            }
        }
        ,
        easeOutQuart{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 4.0));
            }
        }
        ,
        easeInOutQuart{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 8.0f * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
            }
        }
        ,
        easeInQuint{

            @Override
            public float ease(float x) {
                return x * x * x * x * x;
            }
        }
        ,
        easeOutQuint{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 5.0));
            }
        }
        ,
        easeInOutQuint{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 16.0f * x * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
            }
        }
        ,
        easeInSine{

            @Override
            public float ease(float x) {
                return 1.0f - Mth.cos((float)((float)((double)x * Math.PI / 2.0)));
            }
        }
        ,
        easeOutSine{

            @Override
            public float ease(float x) {
                return Mth.sin((float)((float)((double)x * Math.PI / 2.0)));
            }
        }
        ,
        easeInOutSine{

            @Override
            public float ease(float x) {
                return -(Mth.cos((float)((float)(Math.PI * (double)x))) - 1.0f) / 2.0f;
            }
        }
        ,
        easeInExpo{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f);
            }
        }
        ,
        easeOutExpo{

            @Override
            public float ease(float x) {
                return x == 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * x));
            }
        }
        ,
        easeInOutExpo{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0));
            }
        }
        ,
        easeInCirc{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));
            }
        }
        ,
        easeOutCirc{

            @Override
            public float ease(float x) {
                return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
            }
        }
        ,
        easeInOutCirc{

            @Override
            public float ease(float x) {
                return (float)((double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0);
            }
        }
        ,
        easeInBack{

            @Override
            public float ease(float x) {
                return 2.70158f * x * x * x - 1.70158f * x * x;
            }
        }
        ,
        easeOutBack{

            @Override
            public float ease(float x) {
                return (float)(1.0 + (double)2.70158f * Math.pow(x - 1.0f, 3.0) + (double)1.70158f * Math.pow(x - 1.0f, 2.0));
            }
        }
        ,
        easeInOutBack{

            @Override
            public float ease(float x) {
                return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * (double)(7.189819f * x - 2.5949094f) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * (double)(3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0) / 2.0);
            }
        }
        ,
        easeInElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * (double)Mth.sin((float)((float)(((double)(x * 10.0f) - 10.75) * 2.0943951023931953))));
            }
        }
        ,
        easeOutElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * (double)Mth.sin((float)((float)(((double)(x * 10.0f) - 0.75) * 2.0943951023931953))) + 1.0);
            }
        }
        ,
        easeInOutElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * (double)Mth.sin((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636)))) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * (double)Mth.sin((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636))) / 2.0 + 1.0));
            }
        }
        ,
        easeInBounce{

            @Override
            public float ease(float x) {
                return 1.0f - Easing.bounceOut(1.0f - x);
            }
        }
        ,
        easeOutBounce{

            @Override
            public float ease(float x) {
                return 1.0f - Easing.bounceOut(1.0f - x);
            }
        }
        ,
        easeInOutBounce{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? (1.0f - Easing.bounceOut(1.0f - 2.0f * x)) / 2.0f : (1.0f + Easing.bounceOut(2.0f * x - 1.0f)) / 2.0f;
            }
        };


        private static float bounceOut(float x) {
            float n1 = 7.5625f;
            float d1 = 2.75f;
            if (x < 1.0f / d1) {
                return n1 * x * x;
            }
            if (x < 2.0f / d1) {
                x = (float)((double)x - 1.5 / (double)d1);
                return n1 * x * x + 0.75f;
            }
            if ((double)x < 2.5 / (double)d1) {
                x = (float)((double)x - 2.25 / (double)d1);
                return n1 * x * x + 0.9375f;
            }
            x = (float)((double)x - 2.625 / (double)d1);
            return n1 * x * x + 0.984375f;
        }
    }

    public static interface IEasing {
        public float ease(float var1);
    }
}

