/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.deferred.light.IndirectLight;
import foundry.veil.api.client.render.deferred.light.Light;
import imgui.ImGui;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.nio.ByteBuffer;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PointLight
extends Light
implements IndirectLight<PointLight>,
EditorAttributeProvider {
    protected final Vector3d position = new Vector3d();
    protected float radius = 1.0f;

    @Override
    public void store(ByteBuffer buffer) {
        this.position.getf(buffer.position(), buffer);
        buffer.position(buffer.position() + 12);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        buffer.putFloat(this.radius);
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public PointLight setColor(float red, float green, float blue) {
        return (PointLight)super.setColor(red, green, blue);
    }

    @Override
    public PointLight setColor(Vector3fc color) {
        return (PointLight)super.setColor(color);
    }

    @Override
    public PointLight setBrightness(float brightness) {
        return (PointLight)super.setBrightness(brightness);
    }

    @Override
    public PointLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.markDirty();
        return this;
    }

    @Override
    public PointLight setRadius(float radius) {
        this.radius = radius;
        this.markDirty();
        return this;
    }

    @Override
    public PointLight setTo(Camera camera) {
        Vec3 pos = camera.getPosition();
        return this.setPosition(pos.x, pos.y, pos.z);
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.POINT.get();
    }

    @Override
    public PointLight clone() {
        return ((PointLight)new PointLight().setPosition((Vector3dc)this.position)).setColor((Vector3fc)this.color).setRadius(this.radius).setBrightness(this.brightness);
    }

    @Override
    public void renderImGuiAttributes() {
        ImDouble editX = new ImDouble(this.position.x());
        ImDouble editY = new ImDouble(this.position.y());
        ImDouble editZ = new ImDouble(this.position.z());
        ImFloat editRadius = new ImFloat(this.radius);
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##x", 9, editX, 0.02f)) {
            this.setPosition(editX.get(), this.position.y(), this.position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##y", 9, editY, 0.02f)) {
            this.setPosition(this.position.x(), editY.get(), this.position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##z", 9, editZ, 0.02f)) {
            this.setPosition(this.position.x(), this.position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("position");
        if (ImGui.dragScalar("radius", 8, editRadius, 0.02f, 0.0f)) {
            this.setRadius(editRadius.get());
        }
    }
}

