/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api;

import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.object.MolangObject;
import gg.moonflower.molangcompiler.core.ImmutableMolangEnvironment;
import java.util.Collection;
import java.util.Locale;

public interface MolangEnvironment {
    default public void loadLibrary(String name, MolangObject object) {
        this.loadLibrary(name, object, new String[0]);
    }

    public void loadLibrary(String var1, MolangObject var2, String ... var3);

    public void loadAlias(String var1, String var2, String ... var3) throws IllegalArgumentException;

    public void loadParameter(float var1) throws MolangRuntimeException;

    public void clearParameters();

    public float getThis();

    default public boolean has(String name) {
        return this.getObjects().contains(name.toLowerCase(Locale.ROOT));
    }

    public MolangObject get(String var1) throws MolangRuntimeException;

    public float getParameter(int var1) throws MolangRuntimeException;

    default public boolean hasParameter(int parameter) {
        return parameter >= 0 && parameter < this.getParameters();
    }

    public int getParameters();

    public Collection<String> getObjects();

    public void setThisValue(float var1);

    public boolean canEdit();

    public MolangEnvironmentBuilder<? extends MolangEnvironment> edit() throws IllegalStateException;

    default public MolangEnvironment copy() {
        return MolangRuntime.runtime().copy(this).create(this.getThis());
    }

    default public float resolve(MolangExpression expression) throws MolangRuntimeException {
        return expression.get(this);
    }

    default public float safeResolve(MolangExpression expression) {
        try {
            return this.resolve(expression);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0.0f;
        }
    }

    public static MolangEnvironment immutable(MolangEnvironment environment) {
        ImmutableMolangEnvironment immutableEnvironment;
        return environment instanceof ImmutableMolangEnvironment ? (immutableEnvironment = (ImmutableMolangEnvironment)environment) : new ImmutableMolangEnvironment(environment);
    }
}

