/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_name_version")
public class CLNameVersion
extends Struct<CLNameVersion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int NAME;

    protected CLNameVersion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CLNameVersion create(long address, @Nullable ByteBuffer container) {
        return new CLNameVersion(address, container);
    }

    public CLNameVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLNameVersion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_version")
    public int version() {
        return CLNameVersion.nversion(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer name() {
        return CLNameVersion.nname(this.address());
    }

    @NativeType(value="char[64]")
    public String nameString() {
        return CLNameVersion.nnameString(this.address());
    }

    public static CLNameVersion malloc() {
        return new CLNameVersion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CLNameVersion calloc() {
        return new CLNameVersion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CLNameVersion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CLNameVersion(MemoryUtil.memAddress(container), container);
    }

    public static CLNameVersion create(long address) {
        return new CLNameVersion(address, null);
    }

    @Nullable
    public static CLNameVersion createSafe(long address) {
        return address == 0L ? null : new CLNameVersion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CLNameVersion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLNameVersion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CLNameVersion malloc(MemoryStack stack) {
        return new CLNameVersion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLNameVersion calloc(MemoryStack stack) {
        return new CLNameVersion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    static {
        Struct.Layout layout = CLNameVersion.__struct(CLNameVersion.__member(4), CLNameVersion.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLNameVersion, Buffer>
    implements NativeResource {
        private static final CLNameVersion ELEMENT_FACTORY = CLNameVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLNameVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_version")
        public int version() {
            return CLNameVersion.nversion(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer name() {
            return CLNameVersion.nname(this.address());
        }

        @NativeType(value="char[64]")
        public String nameString() {
            return CLNameVersion.nnameString(this.address());
        }
    }
}

