/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.packs.resources.ResourceProvider;

public class ShaderCustomProcessor
implements ShaderPreProcessor {
    private static final String CUSTOM_KEY = "#custom ";
    private final ShaderImportProcessor importProcessor;

    public ShaderCustomProcessor(ResourceProvider resourceProvider) {
        this.importProcessor = new ShaderImportProcessor(resourceProvider);
    }

    @Override
    public void prepare() {
        this.importProcessor.prepare();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context, String source) throws IOException {
        List<String> inputLines = source.lines().toList();
        LinkedList<String> output = new LinkedList<String>();
        for (String line : inputLines) {
            if (!line.startsWith(CUSTOM_KEY)) {
                output.add(line);
                continue;
            }
            String[] parts = line.split(" ", 3);
            if (parts.length < 3) {
                throw new IOException("Invalid Veil custom directive syntax: " + line);
            }
            String directive = parts[1];
            if ("veil:include".equalsIgnoreCase(directive)) {
                output.add(this.importProcessor.modify(context, "#include " + parts[2]));
                continue;
            }
            throw new IOException("Invalid Veil custom directive: " + directive);
        }
        return String.join((CharSequence)"\n", output);
    }
}

