/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public record FramebufferAttachmentDefinition(Type type, Format format, DataType dataType, boolean depth, boolean linear, int levels, @Nullable String name) {
    public static final Codec<FramebufferAttachmentDefinition> COLOR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.optionalFieldOf("type", (Object)Type.TEXTURE).forGetter(FramebufferAttachmentDefinition::type), (App)Format.CODEC.optionalFieldOf("format", (Object)Format.RGBA8).forGetter(FramebufferAttachmentDefinition::format), (App)DataType.CODEC.optionalFieldOf("dataType", (Object)DataType.UNSIGNED_BYTE).forGetter(FramebufferAttachmentDefinition::dataType), (App)Codec.BOOL.optionalFieldOf("linear", (Object)false).forGetter(FramebufferAttachmentDefinition::linear), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("levels", (Object)0).forGetter(FramebufferAttachmentDefinition::levels), (App)Codec.STRING.optionalFieldOf("name").forGetter(attachment -> Optional.ofNullable(attachment.name()))).apply((Applicative)instance, (type, format, dataType, linear, levels, name) -> new FramebufferAttachmentDefinition((Type)((Object)((Object)type)), (Format)((Object)((Object)format)), (DataType)((Object)((Object)dataType)), false, (boolean)linear, (int)levels, name.orElse(null))));
    public static final Codec<FramebufferAttachmentDefinition> DEPTH_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.optionalFieldOf("type", (Object)Type.TEXTURE).forGetter(FramebufferAttachmentDefinition::type), (App)Format.CODEC.optionalFieldOf("format", (Object)Format.DEPTH_COMPONENT).forGetter(FramebufferAttachmentDefinition::format), (App)DataType.CODEC.optionalFieldOf("dataType", (Object)DataType.FLOAT).forGetter(FramebufferAttachmentDefinition::dataType), (App)Codec.BOOL.optionalFieldOf("linear", (Object)false).forGetter(FramebufferAttachmentDefinition::linear), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("levels", (Object)0).forGetter(FramebufferAttachmentDefinition::levels), (App)Codec.STRING.optionalFieldOf("name").forGetter(attachment -> Optional.ofNullable(attachment.name()))).apply((Applicative)instance, (type, format, dataType, linear, levels, name) -> new FramebufferAttachmentDefinition((Type)((Object)((Object)type)), (Format)((Object)((Object)format)), (DataType)((Object)((Object)dataType)), true, (boolean)linear, (int)levels, name.orElse(null))));

    public boolean isCompactDepthAttachment() {
        return this.type == Type.TEXTURE && this.format == Format.DEPTH_COMPONENT && this.dataType == DataType.FLOAT && !this.linear && this.levels == 0 && this.name == null;
    }

    public static enum Type {
        TEXTURE("Texture"),
        RENDER_BUFFER("Render Buffer");

        public static final Codec<Type> CODEC;
        private final String dislpayName;

        private Type(String dislpayName) {
            this.dislpayName = dislpayName;
        }

        public String getDisplayName() {
            return this.dislpayName;
        }

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                for (Type type : Type.values()) {
                    if (!type.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)type));
                }
                return DataResult.error(() -> "Unknown attachment type: " + name);
            }, type -> DataResult.success((Object)type.name()));
        }
    }

    public static enum Format {
        RED(6403, 6403),
        RG(33319, 33319),
        RGB(6407, 6407),
        BGR(32992, 32992),
        RGBA(6408, 6408),
        BGRA(32993, 32993),
        DEPTH_COMPONENT(6402, 6402),
        DEPTH_STENCIL(34041, 34041),
        R8(6403, 33321),
        R8_SNORM(6403, 36756),
        R16(6403, 33322),
        R16_SNORM(6403, 36760),
        RG8(33319, 33323),
        RG8_SNORM(33319, 36757),
        RG16(33319, 33324),
        RG16_SNORM(33319, 36761),
        R3_G3_B2(6407, 10768),
        RGB4(6407, 32847),
        RGB5(6407, 32848),
        RGB565(6407, 36194),
        RGB8(6407, 32849),
        RGB8_SNORM(6407, 36758),
        RGB10(6407, 32850),
        RGB12(6407, 32851),
        RGB16(6407, 32852),
        RGB16_SNORM(6407, 36762),
        RGBA2(6408, 32853),
        RGBA4(6408, 32854),
        RGB5_A1(6408, 32855),
        RGBA8(6408, 32856),
        RGBA8_SNORM(6408, 36759),
        RGB10_A2(6408, 32857),
        RGB10_A2UI(6408, 36975),
        RGBA12(6408, 32858),
        RGBA16(6408, 32859),
        RGBA16_SNORM(6408, 36763),
        SRGB(6407, 35904),
        SRGB8(6407, 35905),
        SRGB_ALPHA(6408, 35906),
        SRGB8_ALPHA8(6408, 35907),
        COMPRESSED_SRGB(6407, 35912),
        COMPRESSED_SRGB_ALPHA(6408, 35913),
        R16F(6403, 33325),
        RG16F(33319, 33327),
        RGB16F(6407, 34843),
        RGBA16F(6408, 34842),
        R32F(6403, 33326),
        RG32F(33319, 33326),
        RGB32F(6407, 34837),
        RGBA32F(6408, 34836),
        R11F_G11F_B10F(6408, 35898),
        R8I(36244, 33329),
        R8UI(36244, 33330),
        R16I(36244, 33331),
        R16UI(36244, 33332),
        R32I(36244, 33333),
        R32UI(36244, 33334),
        RG8I(33320, 33335),
        RG8UI(33320, 33336),
        RG16I(33320, 33337),
        RG16UI(33320, 33338),
        RG32I(33320, 33339),
        RG32UI(33320, 33340),
        RGB8I(36248, 36239),
        RGB8UI(36248, 36221),
        RGB16I(36248, 36233),
        RGB16UI(36248, 36215),
        RGB32I(36248, 36227),
        RGB32UI(36248, 36209),
        RGBA8I(36249, 36238),
        RGBA8UI(36249, 36220),
        RGBA16I(36249, 36232),
        RGBA16UI(36249, 36214),
        RGBA32I(36249, 36226),
        RGBA32UI(36249, 36208),
        DEPTH_COMPONENT16(6402, 33189),
        DEPTH_COMPONENT24(6402, 33190),
        DEPTH_COMPONENT32(6402, 33191),
        DEPTH_COMPONENT32F(6402, 36012),
        DEPTH24_STENCIL8(34041, 35056),
        DEPTH32F_STENCIL8(34041, 36013);

        public static final Codec<Format> CODEC;
        private final int id;
        private final int internalId;

        private Format(int id, int internalId) {
            this.id = id;
            this.internalId = internalId;
        }

        public int getId() {
            return this.id;
        }

        public int getInternalId() {
            return this.internalId;
        }

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                for (Format type : Format.values()) {
                    if (!type.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)type));
                }
                return DataResult.error(() -> "Unknown attachment format: " + name);
            }, type -> DataResult.success((Object)type.name()));
        }
    }

    public static enum DataType {
        UNSIGNED_BYTE(5121),
        BYTE(5120),
        UNSIGNED_SHORT(5123),
        SHORT(5122),
        UNSIGNED_INT(5125),
        INT(5124),
        HALF_FLOAT(5131),
        FLOAT(5126),
        UNSIGNED_BYTE_3_3_2(32818),
        UNSIGNED_BYTE_2_3_3_REV(33634),
        UNSIGNED_SHORT_5_6_5(33635),
        UNSIGNED_SHORT_5_6_5_REV(33636),
        UNSIGNED_SHORT_4_4_4_4(32819),
        UNSIGNED_SHORT_4_4_4_4_REV(33637),
        UNSIGNED_SHORT_5_5_5_1(32820),
        UNSIGNED_SHORT_1_5_5_5_REV(33638),
        UNSIGNED_INT_8_8_8_8(32821),
        UNSIGNED_INT_8_8_8_8_REV(33639),
        UNSIGNED_INT_10_10_10_2(32822),
        UNSIGNED_INT_2_10_10_10_REV(33640),
        UNSIGNED_INT_24_8(34042),
        UNSIGNED_INT_10F_11F_11F_REV(35899),
        UNSIGNED_INT_5_9_9_9_REV(35902),
        FLOAT_32_UNSIGNED_INT_24_8_REV(36269);

        public static final Codec<DataType> CODEC;
        private final int id;

        private DataType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                for (DataType type : DataType.values()) {
                    if (!type.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)type));
                }
                return DataResult.error(() -> "Unknown attachment data type: " + name);
            }, type -> DataResult.success((Object)type.name()));
        }
    }
}

