/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.deferred.light.Light;
import imgui.ImGui;
import net.minecraft.client.Camera;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DirectionalLight
extends Light
implements EditorAttributeProvider {
    protected final Vector3f direction = new Vector3f(0.0f, -1.0f, 0.0f);

    public Vector3fc getDirection() {
        return this.direction;
    }

    @Override
    public DirectionalLight setColor(float red, float green, float blue) {
        return (DirectionalLight)super.setColor(red, green, blue);
    }

    @Override
    public DirectionalLight setColor(Vector3fc color) {
        return (DirectionalLight)super.setColor(color);
    }

    @Override
    public DirectionalLight setColor(int color) {
        return (DirectionalLight)super.setColor(color);
    }

    public DirectionalLight setDirection(Vector3fc direction) {
        return this.setDirection(direction.x(), direction.y(), direction.z());
    }

    public DirectionalLight setDirection(float x, float y, float z) {
        this.direction.set(x, y, z).normalize();
        this.markDirty();
        return this;
    }

    @Override
    public DirectionalLight setTo(Camera camera) {
        Vector3f look = camera.getLookVector();
        return this.setDirection(look.x, look.y, look.z);
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.DIRECTIONAL.get();
    }

    @Override
    public DirectionalLight clone() {
        return new DirectionalLight().setColor((Vector3fc)this.color).setDirection((Vector3fc)this.direction);
    }

    @Override
    public void renderImGuiAttributes() {
        float[] editDirection = new float[]{this.direction.x(), this.direction.y(), this.direction.z()};
        if (ImGui.sliderFloat3("##direction", editDirection, -1.0f, 1.0f)) {
            Vector3f vector = new Vector3f(editDirection).normalize();
            if (!(Float.isNaN(vector.x) || Float.isNaN(vector.y) || Float.isNaN(vector.z))) {
                this.setDirection((Vector3fc)vector);
            }
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("direction");
    }
}

