/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node;

import foundry.veil.impl.glsl.node.GlslNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GlslCompoundNode
implements GlslNode {
    private final List<GlslNode> children;

    public GlslCompoundNode(List<GlslNode> children) {
        this.children = children;
    }

    @Override
    public List<GlslNode> toList() {
        return new ArrayList<GlslNode>(this.children);
    }

    public List<GlslNode> getChildren() {
        return this.children;
    }

    public GlslCompoundNode setChildren(Collection<GlslNode> children) {
        this.children.clear();
        this.children.addAll(children);
        return this;
    }

    public GlslCompoundNode setChildren(GlslNode ... children) {
        this.children.clear();
        this.children.addAll(Arrays.asList(children));
        return this;
    }

    @Override
    public String getSourceString() {
        StringBuilder builder = new StringBuilder("{\n");
        for (GlslNode child : this.children) {
            builder.append('\t').append(child.getSourceString().replaceAll("\n", "\n\t")).append(";\n");
        }
        builder.append('}');
        return builder.toString();
    }

    public String toString() {
        return "GlslCompoundNode{children=" + String.valueOf(this.children) + "}";
    }
}

