/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.shader;

import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import foundry.veil.Veil;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import java.io.InputStream;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Program.class})
public class ProgramMixin {
    @Unique
    private static ResourceLocation veil$captureId;

    @Inject(method={"compileShaderInternal"}, at={@At(value="HEAD")})
    private static void veil$captureId(Program.Type type, String name, InputStream stream, String pack, GlslPreprocessor glslPreprocessor, CallbackInfoReturnable<Integer> cir) {
        ResourceLocation loc = ResourceLocation.parse((String)name);
        String s = "shaders/core/" + loc.getPath() + type.getExtension();
        veil$captureId = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)s);
    }

    @Inject(method={"compileShaderInternal"}, at={@At(value="RETURN")})
    private static void veil$clear(Program.Type type, String name, InputStream stream, String pack, GlslPreprocessor glslPreprocessor, CallbackInfoReturnable<Integer> cir) {
        veil$captureId = null;
    }

    @ModifyArg(method={"compileShaderInternal"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;glShaderSource(ILjava/util/List;)V"), index=1)
    private static List<String> veil$modifyVanillaShader(List<String> sourceLines) {
        try {
            StringBuilder source = new StringBuilder();
            for (String sourceLine : sourceLines) {
                source.append(sourceLine);
            }
            return List.of(SimpleShaderProcessor.modify(veil$captureId, source.toString()));
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to modify vanilla source for shader: {}", (Object)veil$captureId, (Object)e);
            return sourceLines;
        }
    }
}

