/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class ClientEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> Component.translatable((String)"commands.veil.arguments.enum.invalid", (Object[])new Object[]{found, constants}));
    private final Class<T> enumClass;

    private ClientEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public static <R extends Enum<R>> ClientEnumArgument<R> enumArgument(Class<R> enumClass) {
        return new ClientEnumArgument<R>(enumClass);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(value -> value.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(value -> value.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
    }
}

