/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import foundry.veil.Veil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class VeilMixinPlugin
implements IMixinConfigPlugin {
    private static final String PACKAGE_NAME = Veil.platform().getPlatformType().getMixinPackageName();
    private static final Set<String> COMPAT = Set.of("foundry.veil." + PACKAGE_NAME + ".mixin.client.stage", "foundry.veil." + PACKAGE_NAME + ".mixin.client.perspective", "foundry.veil." + PACKAGE_NAME + ".mixin.client.debug");
    private static final Set<String> SODIUM_WITHOUT_IRIS_COMPAT = Set.of();
    private static final Map<String, Set<String>> INCOMPATIBLE_MIXINS = new Object2ObjectArrayMap();
    private final Map<String, Boolean> loadedMods = new HashMap<String, Boolean>();

    private static void addModIncompatibility(String modId, String ... mixinClasses) {
        INCOMPATIBLE_MIXINS.computeIfAbsent(modId, a -> new ObjectArraySet()).addAll(Arrays.asList(mixinClasses));
    }

    private boolean isModLoaded(String modId) {
        return this.loadedMods.computeIfAbsent(modId, Veil.platform()::isModLoaded);
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (String string : COMPAT) {
            if (!mixinClassName.startsWith(string)) continue;
            return Veil.SODIUM ? !mixinClassName.startsWith(string + ".vanilla") : !mixinClassName.startsWith(string + ".sodium");
        }
        if (mixinClassName.startsWith("foundry.veil." + PACKAGE_NAME + ".mixin.compat")) {
            if (Veil.IRIS && SODIUM_WITHOUT_IRIS_COMPAT.contains(mixinClassName)) {
                return false;
            }
            String[] parts = mixinClassName.split("\\.");
            return this.isModLoaded(parts[5]);
        }
        for (Map.Entry entry : INCOMPATIBLE_MIXINS.entrySet()) {
            if (!((Set)entry.getValue()).contains(mixinClassName)) continue;
            return !this.isModLoaded((String)entry.getKey());
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void preApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        VeilMixinPlugin.addModIncompatibility("affinity", "foundry.veil.mixin.performance.client.PerformanceRenderTargetMixin");
    }
}

