/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.vertex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import foundry.veil.impl.client.render.vertex.ARBVertexArray;
import foundry.veil.impl.client.render.vertex.DSAVertexArray;
import foundry.veil.impl.client.render.vertex.LegacyVertexArray;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBMultiDrawIndirect;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public abstract class VertexArray
implements NativeResource {
    public static final int VERTEX_BUFFER = 0;
    public static final int ELEMENT_ARRAY_BUFFER = 1;
    private static VertexArrayType vertexArrayType;
    protected final int id;
    protected final VertexArrayBuilder builder;
    protected final Int2IntMap buffers;
    protected int indexCount;
    protected IndexType indexType;
    protected VertexFormat.Mode drawMode;

    @ApiStatus.Internal
    protected VertexArray(int id, Function<VertexArray, VertexArrayBuilder> builder) {
        this.id = id;
        this.builder = builder.apply(this);
        this.buffers = new Int2IntArrayMap();
        this.indexCount = 0;
        this.indexType = IndexType.BYTE;
        this.drawMode = VertexFormat.Mode.TRIANGLES;
    }

    private static void loadType() {
        if (vertexArrayType == null) {
            if (VeilRenderSystem.directStateAccessSupported()) {
                vertexArrayType = VertexArrayType.DSA;
            } else {
                GLCapabilities caps = GL.getCapabilities();
                vertexArrayType = caps.OpenGL43 || caps.GL_ARB_vertex_attrib_binding ? VertexArrayType.ARB : VertexArrayType.LEGACY;
            }
        }
    }

    public static VertexArray create() {
        RenderSystem.assertOnRenderThreadOrInit();
        VertexArray.loadType();
        return VertexArray.vertexArrayType.factory.apply(VeilRenderSystem.directStateAccessSupported() ? ARBDirectStateAccess.glCreateVertexArrays() : GL30C.glGenVertexArrays());
    }

    public static VertexArray[] create(int count) {
        VertexArray[] fill = new VertexArray[count];
        VertexArray.create(fill);
        return fill;
    }

    public static void create(VertexArray[] fill) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (fill.length == 0) {
            return;
        }
        VertexArray.loadType();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer arrays = stack.mallocInt(fill.length);
            if (VeilRenderSystem.directStateAccessSupported()) {
                ARBDirectStateAccess.glCreateVertexArrays((IntBuffer)arrays);
            } else {
                GL30C.glGenVertexArrays((IntBuffer)arrays);
            }
            for (int i = 0; i < arrays.limit(); ++i) {
                fill[i] = VertexArray.vertexArrayType.factory.apply(arrays.get(i));
            }
        }
    }

    public void setup(RenderType renderType) {
        renderType.setupRenderState();
        ShaderInstance shader = RenderSystem.getShader();
        if (shader != null) {
            shader.apply();
            shader.setDefaultUniforms(this.drawMode, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
        }
    }

    public void clear(RenderType renderType) {
        ShaderInstance shader = RenderSystem.getShader();
        if (shader != null) {
            shader.clear();
        }
        renderType.clearRenderState();
    }

    public int getOrCreateBuffer(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.buffers.computeIfAbsent(index, unused -> GlStateManager._glGenBuffers());
    }

    public int getId() {
        return this.id;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public VertexFormat.Mode getDrawMode() {
        return this.drawMode;
    }

    public static void upload(int buffer, ByteBuffer data, DrawUsage usage) {
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glNamedBufferData((int)buffer, (ByteBuffer)data, (int)usage.getGlType());
        } else {
            GL15C.glBindBuffer((int)34962, (int)buffer);
            GL15C.glBufferData((int)34962, (ByteBuffer)data, (int)usage.getGlType());
            GL15C.glBindBuffer((int)34962, (int)0);
        }
    }

    public void upload(MeshData meshData, DrawUsage usage) {
        this.upload(0, meshData, usage);
    }

    public void upload(int attributeStart, MeshData meshData, DrawUsage usage) {
        try (MeshData meshData2 = meshData;){
            RenderSystem.assertOnRenderThread();
            MeshData.DrawState drawState = meshData.drawState();
            VertexArrayBuilder builder = this.editFormat();
            int vertexBuffer = this.getOrCreateBuffer(0);
            VertexArray.upload(vertexBuffer, meshData.vertexBuffer(), usage);
            builder.applyFrom(0, vertexBuffer, attributeStart, drawState.format());
            ByteBuffer indexBuffer = meshData.indexBuffer();
            if (indexBuffer != null) {
                this.uploadIndexBuffer(indexBuffer);
            } else {
                this.uploadIndexBuffer(drawState);
            }
            this.indexCount = drawState.indexCount();
            this.indexType = IndexType.fromBlaze3D(drawState.indexType());
            this.drawMode = drawState.mode();
        }
    }

    public void uploadIndexBuffer(MeshData.DrawState drawState) {
        RenderSystem.getSequentialBuffer((VertexFormat.Mode)drawState.mode()).bind(drawState.indexCount());
    }

    public void uploadIndexBuffer(ByteBuffer data) {
        GlStateManager._glBindBuffer((int)34963, (int)this.getOrCreateBuffer(1));
        RenderSystem.glBufferData((int)34963, (ByteBuffer)data, (int)35044);
    }

    public void uploadIndexBuffer(ByteBuffer data, IndexType indexType) {
        this.uploadIndexBuffer(data);
        this.setIndexCount(data.remaining() >> indexType.ordinal(), indexType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public void uploadVertexBuffer(int buffer, ByteBuffer data, int usage) {
        DrawUsage drawUsage = switch (usage) {
            case 35040, 35041, 35042 -> DrawUsage.STREAM;
            case 35048, 35049, 35050 -> DrawUsage.DYNAMIC;
            default -> DrawUsage.STATIC;
        };
        VertexArray.upload(buffer, data, drawUsage);
    }

    public VertexArrayBuilder editFormat() {
        this.bind();
        return this.builder;
    }

    public void bind() {
        VeilRenderSystem.bindVertexArray(this.id);
    }

    public static void unbind() {
        VeilRenderSystem.bindVertexArray(0);
    }

    public void draw() {
        GL15C.glDrawElements((int)this.drawMode.asGLMode, (int)this.indexCount, (int)this.indexType.getGlType(), (long)0L);
    }

    public void drawInstanced(int instances) {
        GL31C.glDrawElementsInstanced((int)this.drawMode.asGLMode, (int)this.indexCount, (int)this.indexType.getGlType(), (long)0L, (int)instances);
    }

    public void drawIndirect(long indirect, int drawCount, int stride) {
        if (!VeilRenderSystem.multiDrawIndirectSupported()) {
            throw new UnsupportedOperationException("Indirect rendering is not supported");
        }
        ARBMultiDrawIndirect.glMultiDrawElementsIndirect((int)this.drawMode.asGLMode, (int)this.indexType.getGlType(), (long)indirect, (int)drawCount, (int)stride);
    }

    public void drawWithRenderType(RenderType renderType) {
        this.setup(renderType);
        this.draw();
        this.clear(renderType);
        if (renderType instanceof VeilRenderType.LayeredRenderType) {
            VeilRenderType.LayeredRenderType layeredRenderType = (VeilRenderType.LayeredRenderType)renderType;
            for (RenderType layer : layeredRenderType.getLayers()) {
                this.setup(layer);
                this.draw();
                this.clear(layer);
            }
        }
    }

    public void drawInstancedWithRenderType(RenderType renderType, int instances) {
        this.setup(renderType);
        this.drawInstanced(instances);
        this.clear(renderType);
        if (renderType instanceof VeilRenderType.LayeredRenderType) {
            VeilRenderType.LayeredRenderType layeredRenderType = (VeilRenderType.LayeredRenderType)renderType;
            for (RenderType layer : layeredRenderType.getLayers()) {
                this.setup(layer);
                this.drawInstanced(instances);
                this.clear(layer);
            }
        }
    }

    public void drawIndirectWithRenderType(RenderType renderType, long indirect, int drawCount, int stride) {
        this.setup(renderType);
        this.drawIndirect(indirect, drawCount, stride);
        this.clear(renderType);
        if (renderType instanceof VeilRenderType.LayeredRenderType) {
            VeilRenderType.LayeredRenderType layeredRenderType = (VeilRenderType.LayeredRenderType)renderType;
            for (RenderType layer : layeredRenderType.getLayers()) {
                this.setup(layer);
                this.drawIndirect(indirect, drawCount, stride);
                this.clear(layer);
            }
        }
    }

    public void setIndexCount(int indexCount, IndexType indexType) {
        this.indexCount = indexCount;
        this.indexType = indexType;
    }

    public void setDrawMode(VertexFormat.Mode drawMode) {
        this.drawMode = drawMode;
    }

    public void free() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15C.glDeleteBuffers((int[])this.buffers.values().toIntArray());
        GL30C.glDeleteVertexArrays((int)this.id);
        this.buffers.clear();
    }

    public static enum IndexType {
        BYTE(5121),
        SHORT(5123),
        INT(5125);

        private final int glType;
        private final int bytes;

        private IndexType(int glType) {
            this.glType = glType;
            this.bytes = 1 << this.ordinal();
        }

        public int getGlType() {
            return this.glType;
        }

        public int getBytes() {
            return this.bytes;
        }

        public static IndexType fromBlaze3D(VertexFormat.IndexType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case VertexFormat.IndexType.SHORT -> SHORT;
                case VertexFormat.IndexType.INT -> INT;
            };
        }

        public static IndexType least(int maxIndex) {
            if ((maxIndex & 0xFFFFFF00) == 0) {
                return BYTE;
            }
            if ((maxIndex & 0xFFFF0000) == 0) {
                return SHORT;
            }
            return INT;
        }
    }

    private static enum VertexArrayType {
        LEGACY(LegacyVertexArray::new),
        ARB(ARBVertexArray::new),
        DSA(DSAVertexArray::new);

        private final IntFunction<VertexArray> factory;

        private VertexArrayType(IntFunction<VertexArray> factory) {
            this.factory = factory;
        }
    }

    public static enum DrawUsage {
        STATIC(35044),
        DYNAMIC(35048),
        STREAM(35040);

        private final int glType;

        private DrawUsage(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }

        public static DrawUsage fromBlaze3D(VertexBuffer.Usage type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case VertexBuffer.Usage.STATIC -> STATIC;
                case VertexBuffer.Usage.DYNAMIC -> DYNAMIC;
            };
        }
    }
}

