/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NativeResource;

public class CachedBufferSource
implements MultiBufferSource,
NativeResource {
    private final Object2ObjectMap<RenderType, ByteBufferBuilder> buffers = new Object2ObjectArrayMap();
    private final Object2ObjectMap<RenderType, BufferBuilder> startedBuilders = new Object2ObjectArrayMap();
    @Nullable
    private RenderType lastSharedType;

    @NotNull
    public VertexConsumer getBuffer(@NotNull RenderType renderType) {
        BufferBuilder last = (BufferBuilder)this.startedBuilders.get((Object)renderType);
        if (last != null && !renderType.canConsolidateConsecutiveGeometry()) {
            this.endBatch(renderType, last);
            last = null;
        }
        if (last != null) {
            return last;
        }
        ByteBufferBuilder bytebufferbuilder = (ByteBufferBuilder)this.buffers.computeIfAbsent((Object)renderType, unused -> new ByteBufferBuilder(renderType.bufferSize()));
        BufferBuilder builder = new BufferBuilder(bytebufferbuilder, renderType.mode(), renderType.format());
        this.startedBuilders.put((Object)renderType, (Object)builder);
        return builder;
    }

    public void free() {
        this.buffers.values().forEach(ByteBufferBuilder::clear);
        this.buffers.clear();
        this.startedBuilders.clear();
        this.lastSharedType = null;
    }

    public void endLastBatch() {
        if (this.lastSharedType != null) {
            this.endBatch(this.lastSharedType);
            this.lastSharedType = null;
        }
    }

    public void endBatch() {
        this.endLastBatch();
        for (RenderType rendertype : this.buffers.keySet()) {
            this.endBatch(rendertype);
        }
    }

    public void endBatch(RenderType pRenderType) {
        BufferBuilder bufferbuilder = (BufferBuilder)this.startedBuilders.remove((Object)pRenderType);
        if (bufferbuilder != null) {
            this.endBatch(pRenderType, bufferbuilder);
        }
    }

    private void endBatch(RenderType renderType, BufferBuilder pBuilder) {
        MeshData meshdata = pBuilder.build();
        if (meshdata != null) {
            if (renderType.sortOnUpload()) {
                ByteBufferBuilder bytebufferbuilder = (ByteBufferBuilder)this.buffers.computeIfAbsent((Object)renderType, unused -> new ByteBufferBuilder(renderType.bufferSize()));
                meshdata.sortQuads(bytebufferbuilder, RenderSystem.getVertexSorting());
            }
            renderType.draw(meshdata);
        }
        if (renderType.equals(this.lastSharedType)) {
            this.lastSharedType = null;
        }
    }
}

